/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.nitrite;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelNitriteSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_NITRITE_PATH_DATABASE_CONF = "camel.source.path.database";
    public static final String CAMEL_SOURCE_NITRITE_PATH_DATABASE_DOC = "Path to database file. Will be created if not exists.";
    public static final String CAMEL_SOURCE_NITRITE_PATH_DATABASE_DEFAULT = null;
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_COLLECTION_CONF = "camel.source.endpoint.collection";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_COLLECTION_DOC = "Name of Nitrite collection. Cannot be used in combination with repositoryClass option.";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_COLLECTION_DEFAULT = null;
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_CLASS_CONF = "camel.source.endpoint.repositoryClass";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_CLASS_DOC = "Class of Nitrite ObjectRepository. Cannot be used in combination with collection option.";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_CLASS_DEFAULT = null;
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_NAME_CONF = "camel.source.endpoint.repositoryName";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_NAME_DOC = "Optional name of ObjectRepository. Can be only used in combination with repositoryClass, otherwise have no effect";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_NITRITE_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_NITRITE_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_PASSWORD_CONF = "camel.source.endpoint.password";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_PASSWORD_DOC = "Password for Nitrite database. Required, if option username specified.";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_USERNAME_CONF = "camel.source.endpoint.username";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_USERNAME_DOC = "Username for Nitrite database. Database is not secured if option not specified.";
    public static final String CAMEL_SOURCE_NITRITE_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_NITRITE_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.nitrite.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_NITRITE_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_NITRITE_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_NITRITE_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.nitrite.autowiredEnabled";
    public static final String CAMEL_SOURCE_NITRITE_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_NITRITE_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelNitriteSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelNitriteSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_NITRITE_PATH_DATABASE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NITRITE_PATH_DATABASE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_NITRITE_PATH_DATABASE_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_ENDPOINT_COLLECTION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NITRITE_ENDPOINT_COLLECTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_ENDPOINT_COLLECTION_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_CLASS_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_ENDPOINT_REPOSITORY_NAME_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NITRITE_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NITRITE_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NITRITE_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NITRITE_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NITRITE_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_NITRITE_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NITRITE_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_NITRITE_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_NITRITE_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_NITRITE_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}