/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.io.Serializable;
import org.dizitart.no2.IndexType;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.util.IndexUtils;
import org.dizitart.no2.util.ValidationUtils;

public class Index
implements Comparable<Index>,
Serializable {
    private IndexType indexType;
    private String field;
    private String collectionName;

    public Index(IndexType indexType, String field, String collectionName) {
        ValidationUtils.notNull((Object)indexType, ErrorMessage.errorMessage("indexType can not be null", 1011));
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1012));
        ValidationUtils.notEmpty(field, ErrorMessage.errorMessage("field can not be empty", 1013));
        ValidationUtils.notNull(collectionName, ErrorMessage.errorMessage("collectionName can not be null", 1014));
        ValidationUtils.notEmpty(collectionName, ErrorMessage.errorMessage("collectionName can not be empty", 1015));
        this.indexType = indexType;
        this.field = field;
        this.collectionName = collectionName;
    }

    private Index() {
    }

    @Override
    public int compareTo(Index other) {
        return IndexUtils.internalName(this).compareTo(IndexUtils.internalName(other));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Index)) {
            return false;
        }
        Index other = (Index)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IndexType this$indexType = this.getIndexType();
        IndexType other$indexType = other.getIndexType();
        if (this$indexType == null ? other$indexType != null : !((Object)((Object)this$indexType)).equals((Object)other$indexType)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        return !(this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Index;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IndexType $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : ((Object)((Object)$indexType)).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        return result;
    }

    public String toString() {
        return "Index(indexType=" + (Object)((Object)this.getIndexType()) + ", field=" + this.getField() + ", collectionName=" + this.getCollectionName() + ")";
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public String getField() {
        return this.field;
    }

    public String getCollectionName() {
        return this.collectionName;
    }
}

