/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class Iterables {
    public static <T> T firstOrDefault(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T item = iterator.next();
            return item;
        }
        return null;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list;
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> type) {
        Object[] dummy = (Object[])Array.newInstance(type, 0);
        if (iterable instanceof Collection) {
            return ((Collection)iterable).toArray(dummy);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list.toArray(dummy);
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Iterable<T> iterable, boolean ascending) {
        Iterator<T> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return true;
        }
        Comparable t = (Comparable)iter.next();
        while (iter.hasNext()) {
            Comparable t2 = (Comparable)iter.next();
            if (ascending ? t.compareTo(t2) > 0 : t.compareTo(t2) < 0) {
                return false;
            }
            t = t2;
        }
        return true;
    }

    static Object[] toArray(Iterable iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).toArray();
        }
        ArrayList list = new ArrayList();
        for (Object item : iterable) {
            list.add(item);
        }
        return list.toArray();
    }

    private Iterables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

