/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dizitart.no2.util.ErrorAwareThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorUtils {
    private static final Logger log = LoggerFactory.getLogger(ExecutorUtils.class);

    public static ExecutorService daemonExecutor() {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ErrorAwareThreadFactory(){

            @Override
            public Thread createThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("Worker.NO\u2082");
                thread.setDaemon(true);
                return thread;
            }
        });
        threadPool.allowCoreThreadTimeOut(true);
        return threadPool;
    }

    public static ScheduledExecutorService scheduledExecutor() {
        return Executors.newScheduledThreadPool(1, new ErrorAwareThreadFactory(){

            @Override
            public Thread createThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("ScheduledWorker.NO\u2082");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAndAwaitTermination(ExecutorService pool, int timeout) {
        block12: {
            ExecutorService executorService = pool;
            synchronized (executorService) {
                pool.shutdown();
            }
            try {
                if (pool.awaitTermination(timeout, TimeUnit.SECONDS)) break block12;
                executorService = pool;
                synchronized (executorService) {
                    pool.shutdownNow();
                }
                if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    log.error("Executor did not terminate");
                }
            }
            catch (InterruptedException ie) {
                ExecutorService executorService2 = pool;
                synchronized (executorService2) {
                    pool.shutdownNow();
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    private ExecutorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

