/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.ComparisonFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.NumberUtils;

class GreaterEqualFilter
extends ComparisonFilter {
    GreaterEqualFilter(String field, Object value) {
        super(field, value);
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        if (this.field.equals("_id")) {
            LinkedHashSet<NitriteId> nitriteIdSet = new LinkedHashSet<NitriteId>();
            NitriteId nitriteId = null;
            if (this.comparable instanceof Long) {
                nitriteId = NitriteId.createId((Long)this.comparable);
            }
            if (nitriteId != null) {
                NitriteId ceilingKey = documentMap.ceilingKey(nitriteId);
                while (ceilingKey != null) {
                    nitriteIdSet.add(ceilingKey);
                    ceilingKey = documentMap.higherKey(ceilingKey);
                }
            }
            return nitriteIdSet;
        }
        if (this.nitriteService.hasIndex(this.field) && !this.nitriteService.isIndexing(this.field)) {
            return this.nitriteService.findGreaterEqualWithIndex(this.field, this.comparable);
        }
        return this.matchedSet(documentMap);
    }

    private Set<NitriteId> matchedSet(NitriteMap<NitriteId, Document> documentMap) {
        LinkedHashSet<NitriteId> nitriteIdSet = new LinkedHashSet<NitriteId>();
        for (Map.Entry<NitriteId, Document> entry : documentMap.entrySet()) {
            Document document = entry.getValue();
            Object fieldValue = DocumentUtils.getFieldValue(document, this.field);
            if (fieldValue == null) continue;
            if (fieldValue instanceof Number && this.comparable instanceof Number) {
                if (NumberUtils.compare((Number)fieldValue, (Number)((Object)this.comparable)) < 0) continue;
                nitriteIdSet.add(entry.getKey());
                continue;
            }
            if (fieldValue instanceof Comparable) {
                Comparable arg = (Comparable)fieldValue;
                if (arg.compareTo(this.comparable) < 0) continue;
                nitriteIdSet.add(entry.getKey());
                continue;
            }
            throw new FilterException(ErrorMessage.errorMessage(fieldValue + " is not comparable", 4017));
        }
        return nitriteIdSet;
    }

    @Override
    public String toString() {
        return "GreaterEqualFilter()";
    }
}

