/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.AndFilter;
import org.dizitart.no2.filters.BaseFilter;
import org.dizitart.no2.filters.EqualsFilter;
import org.dizitart.no2.filters.GreaterEqualFilter;
import org.dizitart.no2.filters.GreaterThanFilter;
import org.dizitart.no2.filters.InFilter;
import org.dizitart.no2.filters.LesserEqualFilter;
import org.dizitart.no2.filters.LesserThanFilter;
import org.dizitart.no2.filters.NotFilter;
import org.dizitart.no2.filters.NotInFilter;
import org.dizitart.no2.filters.OrFilter;
import org.dizitart.no2.filters.RegexFilter;
import org.dizitart.no2.filters.TextFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.EqualsUtils;
import org.dizitart.no2.util.NumberUtils;

class ElementMatchFilter
extends BaseFilter {
    private String field;
    private Filter elementFilter;

    ElementMatchFilter(String field, Filter elementFilter) {
        this.field = field;
        this.elementFilter = elementFilter;
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        if (this.elementFilter instanceof ElementMatchFilter) {
            throw new FilterException(ErrorMessage.NESTED_ELEM_MATCH_NOT_SUPPORTED);
        }
        if (this.elementFilter instanceof TextFilter) {
            throw new FilterException(ErrorMessage.FULL_TEXT_ELEM_MATCH_NOT_SUPPORTED);
        }
        this.elementFilter.setNitriteService(this.nitriteService);
        LinkedHashSet<NitriteId> nitriteIdSet = new LinkedHashSet<NitriteId>();
        for (Map.Entry<NitriteId, Document> entry : documentMap.entrySet()) {
            Document document = entry.getValue();
            Object fieldValue = DocumentUtils.getFieldValue(document, this.field);
            if (fieldValue == null) continue;
            if (fieldValue.getClass().isArray()) {
                int length = Array.getLength(fieldValue);
                ArrayList<Object> list = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(fieldValue, i);
                    list.add(item);
                }
                if (!this.matches(list, this.elementFilter)) continue;
                nitriteIdSet.add(entry.getKey());
                continue;
            }
            if (fieldValue instanceof Iterable) {
                if (!this.matches((Iterable)fieldValue, this.elementFilter)) continue;
                nitriteIdSet.add(entry.getKey());
                continue;
            }
            throw new FilterException(ErrorMessage.ELEM_MATCH_SUPPORTED_ON_ARRAY_ONLY);
        }
        return nitriteIdSet;
    }

    private boolean matches(Iterable iterable, Filter filter) {
        for (Object item : iterable) {
            if (!this.matchElement(item, filter)) continue;
            return true;
        }
        return false;
    }

    private boolean matchElement(Object item, Filter filter) {
        if (filter instanceof AndFilter) {
            Filter[] filters;
            for (Filter f : filters = ((AndFilter)filter).getFilters()) {
                if (this.matchElement(item, f)) continue;
                return false;
            }
            return true;
        }
        if (filter instanceof OrFilter) {
            Filter[] filters;
            for (Filter f : filters = ((OrFilter)filter).getFilters()) {
                if (!this.matchElement(item, f)) continue;
                return true;
            }
            return false;
        }
        if (filter instanceof NotFilter) {
            Filter not = ((NotFilter)filter).getFilter();
            return !this.matchElement(item, not);
        }
        if (filter instanceof EqualsFilter) {
            return this.matchEqual(item, filter);
        }
        if (filter instanceof GreaterEqualFilter) {
            return this.matchGreaterEqual(item, filter);
        }
        if (filter instanceof GreaterThanFilter) {
            return this.matchGreater(item, filter);
        }
        if (filter instanceof LesserEqualFilter) {
            return this.matchLesserEqual(item, filter);
        }
        if (filter instanceof LesserThanFilter) {
            return this.matchLesser(item, filter);
        }
        if (filter instanceof InFilter) {
            return this.matchIn(item, filter);
        }
        if (filter instanceof NotInFilter) {
            return this.matchNotIn(item, filter);
        }
        if (filter instanceof RegexFilter) {
            return this.matchRegex(item, filter);
        }
        throw new FilterException(ErrorMessage.errorMessage("filter " + filter.getClass().getName() + " is not a supported in elemMatch", 4006));
    }

    private boolean matchEqual(Object item, Filter filter) {
        Object value = ((EqualsFilter)filter).getValue();
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((EqualsFilter)filter).getField());
            return EqualsUtils.deepEquals(value, docValue);
        }
        return EqualsUtils.deepEquals(item, value);
    }

    private boolean matchGreater(Object item, Filter filter) {
        Comparable comparable = ((GreaterThanFilter)filter).getComparable();
        if (item instanceof Number && comparable instanceof Number) {
            return NumberUtils.compare((Number)item, (Number)((Object)comparable)) > 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) > 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((GreaterThanFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) > 0;
            }
            throw new FilterException(ErrorMessage.errorMessage(((GreaterThanFilter)filter).getField() + " is not comparable", 4007));
        }
        throw new FilterException(ErrorMessage.errorMessage(item + " is not comparable", 4008));
    }

    private boolean matchGreaterEqual(Object item, Filter filter) {
        Comparable comparable = ((GreaterEqualFilter)filter).getComparable();
        if (item instanceof Number && comparable instanceof Number) {
            return NumberUtils.compare((Number)item, (Number)((Object)comparable)) >= 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) >= 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((GreaterEqualFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) >= 0;
            }
            throw new FilterException(ErrorMessage.errorMessage(((GreaterEqualFilter)filter).getField() + " is not comparable", 4009));
        }
        throw new FilterException(ErrorMessage.errorMessage(item + " is not comparable", 4010));
    }

    private boolean matchLesserEqual(Object item, Filter filter) {
        Comparable comparable = ((LesserEqualFilter)filter).getComparable();
        if (item instanceof Number && comparable instanceof Number) {
            return NumberUtils.compare((Number)item, (Number)((Object)comparable)) <= 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) <= 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((LesserEqualFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) <= 0;
            }
            throw new FilterException(ErrorMessage.errorMessage(((LesserEqualFilter)filter).getField() + " is not comparable", 4013));
        }
        throw new FilterException(ErrorMessage.errorMessage(item + " is not comparable", 4014));
    }

    private boolean matchLesser(Object item, Filter filter) {
        Comparable comparable = ((LesserThanFilter)filter).getComparable();
        if (item instanceof Number && comparable instanceof Number) {
            return NumberUtils.compare((Number)item, (Number)((Object)comparable)) < 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) < 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((LesserThanFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) < 0;
            }
            throw new FilterException(ErrorMessage.errorMessage(((LesserThanFilter)filter).getField() + " is not comparable", 4011));
        }
        throw new FilterException(ErrorMessage.errorMessage(item + " is not comparable", 4012));
    }

    private boolean matchIn(Object item, Filter filter) {
        HashSet values = new HashSet();
        Collections.addAll(values, ((InFilter)filter).getValues());
        if (!values.isEmpty()) {
            if (item instanceof Document) {
                Document document = (Document)item;
                Object docValue = DocumentUtils.getFieldValue(document, ((InFilter)filter).getField());
                return values.contains(docValue);
            }
            return values.contains(item);
        }
        return false;
    }

    private boolean matchNotIn(Object item, Filter filter) {
        HashSet values = new HashSet();
        Collections.addAll(values, ((NotInFilter)filter).getValues());
        if (!values.isEmpty()) {
            if (item instanceof Document) {
                Document document = (Document)item;
                Object docValue = DocumentUtils.getFieldValue(document, ((NotInFilter)filter).getField());
                return !values.contains(docValue);
            }
            return !values.contains(item);
        }
        return false;
    }

    private boolean matchRegex(Object item, Filter filter) {
        String value = ((RegexFilter)filter).getValue();
        if (item instanceof String) {
            Pattern pattern = Pattern.compile(value);
            Matcher matcher = pattern.matcher((String)item);
            return matcher.find();
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((RegexFilter)filter).getField());
            if (docValue instanceof String) {
                Pattern pattern = Pattern.compile(value);
                Matcher matcher = pattern.matcher((String)docValue);
                return matcher.find();
            }
            throw new FilterException(ErrorMessage.errorMessage(((RegexFilter)filter).getField() + " is not a string", 4015));
        }
        throw new FilterException(ErrorMessage.errorMessage(item + " is not a string", 4016));
    }

    public String toString() {
        return "ElementMatchFilter(field=" + this.field + ", elementFilter=" + this.elementFilter + ")";
    }
}

