/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.dizitart.no2.Index;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.util.ValidationUtils;

public final class IndexUtils {
    public static String internalName(Index index) {
        ValidationUtils.notNull(index, ErrorMessage.errorMessage("index can not be null", 1031));
        return "$nitrite_index|" + index.getCollectionName() + "|" + index.getField() + "|" + (Object)((Object)index.getIndexType());
    }

    public static <K, V extends Comparable<V>> Map<K, V> sortByScore(Map<K, V> unsortedMap) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(unsortedMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                return ((Comparable)e2.getValue()).compareTo(e1.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private IndexUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

