/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.language;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.Predicate;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.CSimpleExpression;
import org.apache.camel.model.language.DatasonnetExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.JoorExpression;
import org.apache.camel.model.language.JqExpression;
import org.apache.camel.model.language.JsonPathExpression;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.model.language.SingleInputTypedExpressionDefinition;
import org.apache.camel.model.language.TokenizerExpression;
import org.apache.camel.model.language.TypedExpressionDefinition;
import org.apache.camel.model.language.XMLTokenizerExpression;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.model.language.XQueryExpression;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.language.CSimpleExpressionReifier;
import org.apache.camel.reifier.language.DatasonnetExpressionReifier;
import org.apache.camel.reifier.language.JoorExpressionReifier;
import org.apache.camel.reifier.language.JqExpressionReifier;
import org.apache.camel.reifier.language.JsonPathExpressionReifier;
import org.apache.camel.reifier.language.MethodCallExpressionReifier;
import org.apache.camel.reifier.language.SimpleExpressionReifier;
import org.apache.camel.reifier.language.SingleInputTypedExpressionReifier;
import org.apache.camel.reifier.language.TokenizerExpressionReifier;
import org.apache.camel.reifier.language.TypedExpressionReifier;
import org.apache.camel.reifier.language.XMLTokenizerExpressionReifier;
import org.apache.camel.reifier.language.XPathExpressionReifier;
import org.apache.camel.reifier.language.XQueryExpressionReifier;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.util.ObjectHelper;

public class ExpressionReifier<T extends ExpressionDefinition>
extends AbstractReifier {
    private static final Pattern SINGLE_TO_DOUBLE = Pattern.compile("'(\\{\\{.*?}})'");
    private static final Map<Class<?>, BiFunction<CamelContext, ExpressionDefinition, ExpressionReifier<? extends ExpressionDefinition>>> EXPRESSIONS = new HashMap(0);
    protected final T definition;

    public ExpressionReifier(CamelContext camelContext, T definition) {
        super(camelContext);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> processorClass, BiFunction<CamelContext, ExpressionDefinition, ExpressionReifier<? extends ExpressionDefinition>> creator) {
        if (EXPRESSIONS.isEmpty()) {
            ReifierStrategy.addReifierClearer(ExpressionReifier::clearReifiers);
        }
        EXPRESSIONS.put(processorClass, creator);
    }

    public static ExpressionReifier<? extends ExpressionDefinition> reifier(CamelContext camelContext, ExpressionSubElementDefinition definition) {
        return ExpressionReifier.reifier(camelContext, definition.getExpressionType());
    }

    public static ExpressionReifier<? extends ExpressionDefinition> reifier(CamelContext camelContext, ExpressionDefinition definition) {
        BiFunction<CamelContext, ExpressionDefinition, ExpressionReifier<? extends ExpressionDefinition>> reifier;
        ExpressionReifier<ExpressionDefinition> answer = null;
        if (!EXPRESSIONS.isEmpty() && (reifier = EXPRESSIONS.get(definition.getClass())) != null) {
            answer = reifier.apply(camelContext, definition);
        }
        if (answer == null) {
            answer = ExpressionReifier.coreReifier(camelContext, definition);
        }
        if (answer == null) {
            throw new IllegalStateException("Unsupported definition: " + definition);
        }
        return answer;
    }

    private static ExpressionReifier<? extends ExpressionDefinition> coreReifier(CamelContext camelContext, ExpressionDefinition definition) {
        if (definition instanceof CSimpleExpression) {
            return new CSimpleExpressionReifier(camelContext, definition);
        }
        if (definition instanceof DatasonnetExpression) {
            return new DatasonnetExpressionReifier(camelContext, definition);
        }
        if (definition instanceof JoorExpression) {
            return new JoorExpressionReifier(camelContext, definition);
        }
        if (definition instanceof JqExpression) {
            return new JqExpressionReifier(camelContext, definition);
        }
        if (definition instanceof JsonPathExpression) {
            return new JsonPathExpressionReifier(camelContext, definition);
        }
        if (definition instanceof MethodCallExpression) {
            return new MethodCallExpressionReifier(camelContext, definition);
        }
        if (definition instanceof SimpleExpression) {
            return new SimpleExpressionReifier(camelContext, definition);
        }
        if (definition instanceof TokenizerExpression) {
            return new TokenizerExpressionReifier(camelContext, definition);
        }
        if (definition instanceof XMLTokenizerExpression) {
            return new XMLTokenizerExpressionReifier(camelContext, definition);
        }
        if (definition instanceof XPathExpression) {
            return new XPathExpressionReifier(camelContext, definition);
        }
        if (definition instanceof XQueryExpression) {
            return new XQueryExpressionReifier(camelContext, definition);
        }
        if (definition instanceof SingleInputTypedExpressionDefinition) {
            return new SingleInputTypedExpressionReifier(camelContext, definition);
        }
        if (definition instanceof TypedExpressionDefinition) {
            return new TypedExpressionReifier(camelContext, definition);
        }
        if (definition != null) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        return null;
    }

    public static void clearReifiers() {
        EXPRESSIONS.clear();
    }

    public boolean isResolveOptionalExternalScriptEnabled() {
        return true;
    }

    public Expression createExpression() {
        Expression expression = this.definition.getExpressionValue();
        if (expression == null) {
            this.prepareExpression();
            if (this.definition.getExpressionType() != null) {
                expression = ExpressionReifier.reifier(this.camelContext, this.definition.getExpressionType()).createExpression();
            } else if (this.definition.getExpressionValue() != null) {
                expression = this.definition.getExpressionValue();
            } else {
                ObjectHelper.notNull((Object)this.definition.getLanguage(), (String)"language");
                Language language = this.camelContext.resolveLanguage(this.definition.getLanguage());
                if (language == null) {
                    throw new NoSuchLanguageException(this.definition.getLanguage());
                }
                String exp = this.parseString(this.definition.getExpression());
                boolean isTrim = this.parseBoolean(this.definition.getTrim(), true);
                if (exp != null && isTrim) {
                    exp = exp.trim();
                }
                if (this.isResolveOptionalExternalScriptEnabled()) {
                    exp = ScriptHelper.resolveOptionalExternalScript((CamelContext)this.camelContext, (String)exp);
                }
                this.configureLanguage(language);
                expression = this.createExpression(language, exp);
                this.configureExpression(expression);
            }
        }
        CamelContextAware.trySetCamelContext((Object)expression, (CamelContext)this.camelContext);
        expression.init(this.camelContext);
        return expression;
    }

    public Predicate createPredicate() {
        Predicate predicate = this.definition.getPredicate();
        if (predicate == null) {
            this.prepareExpression();
            if (this.definition.getExpressionType() != null) {
                predicate = ExpressionReifier.reifier(this.camelContext, this.definition.getExpressionType()).createPredicate();
            } else if (this.definition.getExpressionValue() != null) {
                predicate = new ExpressionToPredicateAdapter(this.definition.getExpressionValue());
            } else {
                ObjectHelper.notNull((Object)this.definition.getLanguage(), (String)"language");
                Language language = this.camelContext.resolveLanguage(this.definition.getLanguage());
                if (language == null) {
                    throw new NoSuchLanguageException(this.definition.getLanguage());
                }
                String exp = this.parseString(this.definition.getExpression());
                boolean isTrim = this.parseBoolean(this.definition.getTrim(), true);
                if (exp != null && isTrim) {
                    exp = exp.trim();
                }
                exp = ScriptHelper.resolveOptionalExternalScript((CamelContext)this.camelContext, (String)exp);
                this.configureLanguage(language);
                predicate = this.createPredicate(language, exp);
                this.configurePredicate(predicate);
            }
        }
        CamelContextAware.trySetCamelContext((Object)predicate, (CamelContext)this.camelContext);
        predicate.initPredicate(this.camelContext);
        return predicate;
    }

    protected Expression createExpression(Language language, String exp) {
        return language.createExpression(exp);
    }

    protected Predicate createPredicate(Language language, String exp) {
        return language.createPredicate(exp);
    }

    protected void configureLanguage(Language language) {
    }

    protected void configurePredicate(Predicate predicate) {
        if (predicate instanceof AfterPropertiesConfigured) {
            ((AfterPropertiesConfigured)predicate).afterPropertiesConfigured(this.camelContext);
        }
    }

    protected void configureExpression(Expression expression) {
        if (expression instanceof AfterPropertiesConfigured) {
            ((AfterPropertiesConfigured)expression).afterPropertiesConfigured(this.camelContext);
        }
    }

    protected void prepareExpression() {
        String text = this.definition.getExpression();
        if (text != null && text.contains("{{")) {
            boolean changed = false;
            Matcher matcher = SINGLE_TO_DOUBLE.matcher(text);
            while (matcher.find()) {
                String group = matcher.group(1);
                String resolved = this.camelContext.resolvePropertyPlaceholders(group);
                if (resolved == null || resolved.indexOf(39) == -1) continue;
                text = matcher.replaceFirst("\"$1\"");
                matcher.reset(text);
                changed = true;
            }
            if (changed) {
                this.definition.setExpression(text);
            }
        }
    }
}

