/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.File;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class NettyComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private NettyConfiguration getOrCreateConfiguration(NettyComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new NettyConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        NettyComponent target = (NettyComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowdefaultcodec": 
            case "allowDefaultCodec": {
                this.getOrCreateConfiguration(target).setAllowDefaultCodec((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                this.getOrCreateConfiguration(target).setAllowSerializedHeaders((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autoappenddelimiter": 
            case "autoAppendDelimiter": {
                this.getOrCreateConfiguration(target).setAutoAppendDelimiter((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "backlog": {
                this.getOrCreateConfiguration(target).setBacklog((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "bosscount": 
            case "bossCount": {
                this.getOrCreateConfiguration(target).setBossCount((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "bossgroup": 
            case "bossGroup": {
                this.getOrCreateConfiguration(target).setBossGroup((EventLoopGroup)NettyComponentConfigurer.property((CamelContext)camelContext, EventLoopGroup.class, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "broadcast": {
                this.getOrCreateConfiguration(target).setBroadcast((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "channelgroup": 
            case "channelGroup": {
                this.getOrCreateConfiguration(target).setChannelGroup((ChannelGroup)NettyComponentConfigurer.property((CamelContext)camelContext, ChannelGroup.class, (Object)value));
                return true;
            }
            case "clientinitializerfactory": 
            case "clientInitializerFactory": {
                this.getOrCreateConfiguration(target).setClientInitializerFactory((ClientInitializerFactory)((Object)NettyComponentConfigurer.property((CamelContext)camelContext, ClientInitializerFactory.class, (Object)value)));
                return true;
            }
            case "clientmode": 
            case "clientMode": {
                this.getOrCreateConfiguration(target).setClientMode((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((NettyConfiguration)NettyComponentConfigurer.property((CamelContext)camelContext, NettyConfiguration.class, (Object)value));
                return true;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                this.getOrCreateConfiguration(target).setConnectTimeout((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "correlationmanager": 
            case "correlationManager": {
                this.getOrCreateConfiguration(target).setCorrelationManager((NettyCamelStateCorrelationManager)NettyComponentConfigurer.property((CamelContext)camelContext, NettyCamelStateCorrelationManager.class, (Object)value));
                return true;
            }
            case "decodermaxlinelength": 
            case "decoderMaxLineLength": {
                this.getOrCreateConfiguration(target).setDecoderMaxLineLength((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "decoders": {
                this.getOrCreateConfiguration(target).setDecoders((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "delimiter": {
                this.getOrCreateConfiguration(target).setDelimiter((TextLineDelimiter)((Object)NettyComponentConfigurer.property((CamelContext)camelContext, TextLineDelimiter.class, (Object)value)));
                return true;
            }
            case "disconnect": {
                this.getOrCreateConfiguration(target).setDisconnect((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "disconnectonnoreply": 
            case "disconnectOnNoReply": {
                this.getOrCreateConfiguration(target).setDisconnectOnNoReply((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "enabledprotocols": 
            case "enabledProtocols": {
                this.getOrCreateConfiguration(target).setEnabledProtocols((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "encoders": {
                this.getOrCreateConfiguration(target).setEncoders((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "encoding": {
                this.getOrCreateConfiguration(target).setEncoding((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "executorservice": 
            case "executorService": {
                target.setExecutorService((EventExecutorGroup)NettyComponentConfigurer.property((CamelContext)camelContext, EventExecutorGroup.class, (Object)value));
                return true;
            }
            case "hostnameverification": 
            case "hostnameVerification": {
                this.getOrCreateConfiguration(target).setHostnameVerification((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keepalive": 
            case "keepAlive": {
                this.getOrCreateConfiguration(target).setKeepAlive((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keystorefile": 
            case "keyStoreFile": {
                this.getOrCreateConfiguration(target).setKeyStoreFile((File)NettyComponentConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "keystoreformat": 
            case "keyStoreFormat": {
                this.getOrCreateConfiguration(target).setKeyStoreFormat((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keystoreresource": 
            case "keyStoreResource": {
                this.getOrCreateConfiguration(target).setKeyStoreResource((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazychannelcreation": 
            case "lazyChannelCreation": {
                this.getOrCreateConfiguration(target).setLazyChannelCreation((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maximumpoolsize": 
            case "maximumPoolSize": {
                target.setMaximumPoolSize((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "nativetransport": 
            case "nativeTransport": {
                this.getOrCreateConfiguration(target).setNativeTransport((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "needclientauth": 
            case "needClientAuth": {
                this.getOrCreateConfiguration(target).setNeedClientAuth((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "nettyserverbootstrapfactory": 
            case "nettyServerBootstrapFactory": {
                this.getOrCreateConfiguration(target).setNettyServerBootstrapFactory((NettyServerBootstrapFactory)NettyComponentConfigurer.property((CamelContext)camelContext, NettyServerBootstrapFactory.class, (Object)value));
                return true;
            }
            case "networkinterface": 
            case "networkInterface": {
                this.getOrCreateConfiguration(target).setNetworkInterface((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "noreplyloglevel": 
            case "noReplyLogLevel": {
                this.getOrCreateConfiguration(target).setNoReplyLogLevel((LoggingLevel)NettyComponentConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "options": {
                this.getOrCreateConfiguration(target).setOptions((Map)NettyComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "passphrase": {
                this.getOrCreateConfiguration(target).setPassphrase((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "producerpoolenabled": 
            case "producerPoolEnabled": {
                this.getOrCreateConfiguration(target).setProducerPoolEnabled((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "producerpoolmaxidle": 
            case "producerPoolMaxIdle": {
                this.getOrCreateConfiguration(target).setProducerPoolMaxIdle((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "producerpoolmaxtotal": 
            case "producerPoolMaxTotal": {
                this.getOrCreateConfiguration(target).setProducerPoolMaxTotal((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "producerpoolminevictableidle": 
            case "producerPoolMinEvictableIdle": {
                this.getOrCreateConfiguration(target).setProducerPoolMinEvictableIdle((Long)NettyComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "producerpoolminidle": 
            case "producerPoolMinIdle": {
                this.getOrCreateConfiguration(target).setProducerPoolMinIdle((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                this.getOrCreateConfiguration(target).setReceiveBufferSize((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "receivebuffersizepredictor": 
            case "receiveBufferSizePredictor": {
                this.getOrCreateConfiguration(target).setReceiveBufferSizePredictor((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "reconnect": {
                this.getOrCreateConfiguration(target).setReconnect((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "reconnectinterval": 
            case "reconnectInterval": {
                this.getOrCreateConfiguration(target).setReconnectInterval((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                this.getOrCreateConfiguration(target).setRequestTimeout((Long)NettyComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "reuseaddress": 
            case "reuseAddress": {
                this.getOrCreateConfiguration(target).setReuseAddress((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "reusechannel": 
            case "reuseChannel": {
                this.getOrCreateConfiguration(target).setReuseChannel((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "securityprovider": 
            case "securityProvider": {
                this.getOrCreateConfiguration(target).setSecurityProvider((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                this.getOrCreateConfiguration(target).setSendBufferSize((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "serverclosedchannelexceptioncaughtloglevel": 
            case "serverClosedChannelExceptionCaughtLogLevel": {
                this.getOrCreateConfiguration(target).setServerClosedChannelExceptionCaughtLogLevel((LoggingLevel)NettyComponentConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "serverexceptioncaughtloglevel": 
            case "serverExceptionCaughtLogLevel": {
                this.getOrCreateConfiguration(target).setServerExceptionCaughtLogLevel((LoggingLevel)NettyComponentConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "serverinitializerfactory": 
            case "serverInitializerFactory": {
                this.getOrCreateConfiguration(target).setServerInitializerFactory((ServerInitializerFactory)((Object)NettyComponentConfigurer.property((CamelContext)camelContext, ServerInitializerFactory.class, (Object)value)));
                return true;
            }
            case "ssl": {
                this.getOrCreateConfiguration(target).setSsl((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "sslclientcertheaders": 
            case "sslClientCertHeaders": {
                this.getOrCreateConfiguration(target).setSslClientCertHeaders((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                this.getOrCreateConfiguration(target).setSslContextParameters((SSLContextParameters)NettyComponentConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "sslhandler": 
            case "sslHandler": {
                this.getOrCreateConfiguration(target).setSslHandler((SslHandler)NettyComponentConfigurer.property((CamelContext)camelContext, SslHandler.class, (Object)value));
                return true;
            }
            case "sync": {
                this.getOrCreateConfiguration(target).setSync((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                this.getOrCreateConfiguration(target).setTcpNoDelay((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "textline": {
                this.getOrCreateConfiguration(target).setTextline((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transferexchange": 
            case "transferExchange": {
                this.getOrCreateConfiguration(target).setTransferExchange((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "truststorefile": 
            case "trustStoreFile": {
                this.getOrCreateConfiguration(target).setTrustStoreFile((File)NettyComponentConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "truststoreresource": 
            case "trustStoreResource": {
                this.getOrCreateConfiguration(target).setTrustStoreResource((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "udpbytearraycodec": 
            case "udpByteArrayCodec": {
                this.getOrCreateConfiguration(target).setUdpByteArrayCodec((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "udpconnectionlesssending": 
            case "udpConnectionlessSending": {
                this.getOrCreateConfiguration(target).setUdpConnectionlessSending((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usebytebuf": 
            case "useByteBuf": {
                this.getOrCreateConfiguration(target).setUseByteBuf((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                target.setUseGlobalSslContextParameters((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usingexecutorservice": 
            case "usingExecutorService": {
                this.getOrCreateConfiguration(target).setUsingExecutorService((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "workercount": 
            case "workerCount": {
                this.getOrCreateConfiguration(target).setWorkerCount((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "workergroup": 
            case "workerGroup": {
                this.getOrCreateConfiguration(target).setWorkerGroup((EventLoopGroup)NettyComponentConfigurer.property((CamelContext)camelContext, EventLoopGroup.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowdefaultcodec": 
            case "allowDefaultCodec": {
                return Boolean.TYPE;
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return Boolean.TYPE;
            }
            case "autoappenddelimiter": 
            case "autoAppendDelimiter": {
                return Boolean.TYPE;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "backlog": {
                return Integer.TYPE;
            }
            case "bosscount": 
            case "bossCount": {
                return Integer.TYPE;
            }
            case "bossgroup": 
            case "bossGroup": {
                return EventLoopGroup.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "broadcast": {
                return Boolean.TYPE;
            }
            case "channelgroup": 
            case "channelGroup": {
                return ChannelGroup.class;
            }
            case "clientinitializerfactory": 
            case "clientInitializerFactory": {
                return ClientInitializerFactory.class;
            }
            case "clientmode": 
            case "clientMode": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return NettyConfiguration.class;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return Integer.TYPE;
            }
            case "correlationmanager": 
            case "correlationManager": {
                return NettyCamelStateCorrelationManager.class;
            }
            case "decodermaxlinelength": 
            case "decoderMaxLineLength": {
                return Integer.TYPE;
            }
            case "decoders": {
                return String.class;
            }
            case "delimiter": {
                return TextLineDelimiter.class;
            }
            case "disconnect": {
                return Boolean.TYPE;
            }
            case "disconnectonnoreply": 
            case "disconnectOnNoReply": {
                return Boolean.TYPE;
            }
            case "enabledprotocols": 
            case "enabledProtocols": {
                return String.class;
            }
            case "encoders": {
                return String.class;
            }
            case "encoding": {
                return String.class;
            }
            case "executorservice": 
            case "executorService": {
                return EventExecutorGroup.class;
            }
            case "hostnameverification": 
            case "hostnameVerification": {
                return Boolean.TYPE;
            }
            case "keepalive": 
            case "keepAlive": {
                return Boolean.TYPE;
            }
            case "keystorefile": 
            case "keyStoreFile": {
                return File.class;
            }
            case "keystoreformat": 
            case "keyStoreFormat": {
                return String.class;
            }
            case "keystoreresource": 
            case "keyStoreResource": {
                return String.class;
            }
            case "lazychannelcreation": 
            case "lazyChannelCreation": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maximumpoolsize": 
            case "maximumPoolSize": {
                return Integer.TYPE;
            }
            case "nativetransport": 
            case "nativeTransport": {
                return Boolean.TYPE;
            }
            case "needclientauth": 
            case "needClientAuth": {
                return Boolean.TYPE;
            }
            case "nettyserverbootstrapfactory": 
            case "nettyServerBootstrapFactory": {
                return NettyServerBootstrapFactory.class;
            }
            case "networkinterface": 
            case "networkInterface": {
                return String.class;
            }
            case "noreplyloglevel": 
            case "noReplyLogLevel": {
                return LoggingLevel.class;
            }
            case "options": {
                return Map.class;
            }
            case "passphrase": {
                return String.class;
            }
            case "producerpoolenabled": 
            case "producerPoolEnabled": {
                return Boolean.TYPE;
            }
            case "producerpoolmaxidle": 
            case "producerPoolMaxIdle": {
                return Integer.TYPE;
            }
            case "producerpoolmaxtotal": 
            case "producerPoolMaxTotal": {
                return Integer.TYPE;
            }
            case "producerpoolminevictableidle": 
            case "producerPoolMinEvictableIdle": {
                return Long.TYPE;
            }
            case "producerpoolminidle": 
            case "producerPoolMinIdle": {
                return Integer.TYPE;
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                return Integer.TYPE;
            }
            case "receivebuffersizepredictor": 
            case "receiveBufferSizePredictor": {
                return Integer.TYPE;
            }
            case "reconnect": {
                return Boolean.TYPE;
            }
            case "reconnectinterval": 
            case "reconnectInterval": {
                return Integer.TYPE;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return Long.TYPE;
            }
            case "reuseaddress": 
            case "reuseAddress": {
                return Boolean.TYPE;
            }
            case "reusechannel": 
            case "reuseChannel": {
                return Boolean.TYPE;
            }
            case "securityprovider": 
            case "securityProvider": {
                return String.class;
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                return Integer.TYPE;
            }
            case "serverclosedchannelexceptioncaughtloglevel": 
            case "serverClosedChannelExceptionCaughtLogLevel": {
                return LoggingLevel.class;
            }
            case "serverexceptioncaughtloglevel": 
            case "serverExceptionCaughtLogLevel": {
                return LoggingLevel.class;
            }
            case "serverinitializerfactory": 
            case "serverInitializerFactory": {
                return ServerInitializerFactory.class;
            }
            case "ssl": {
                return Boolean.TYPE;
            }
            case "sslclientcertheaders": 
            case "sslClientCertHeaders": {
                return Boolean.TYPE;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "sslhandler": 
            case "sslHandler": {
                return SslHandler.class;
            }
            case "sync": {
                return Boolean.TYPE;
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                return Boolean.TYPE;
            }
            case "textline": {
                return Boolean.TYPE;
            }
            case "transferexchange": 
            case "transferExchange": {
                return Boolean.TYPE;
            }
            case "truststorefile": 
            case "trustStoreFile": {
                return File.class;
            }
            case "truststoreresource": 
            case "trustStoreResource": {
                return String.class;
            }
            case "udpbytearraycodec": 
            case "udpByteArrayCodec": {
                return Boolean.TYPE;
            }
            case "udpconnectionlesssending": 
            case "udpConnectionlessSending": {
                return Boolean.TYPE;
            }
            case "usebytebuf": 
            case "useByteBuf": {
                return Boolean.TYPE;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return Boolean.TYPE;
            }
            case "usingexecutorservice": 
            case "usingExecutorService": {
                return Boolean.TYPE;
            }
            case "workercount": 
            case "workerCount": {
                return Integer.TYPE;
            }
            case "workergroup": 
            case "workerGroup": {
                return EventLoopGroup.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        NettyComponent target = (NettyComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowdefaultcodec": 
            case "allowDefaultCodec": {
                return this.getOrCreateConfiguration(target).isAllowDefaultCodec();
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return this.getOrCreateConfiguration(target).isAllowSerializedHeaders();
            }
            case "autoappenddelimiter": 
            case "autoAppendDelimiter": {
                return this.getOrCreateConfiguration(target).isAutoAppendDelimiter();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "backlog": {
                return this.getOrCreateConfiguration(target).getBacklog();
            }
            case "bosscount": 
            case "bossCount": {
                return this.getOrCreateConfiguration(target).getBossCount();
            }
            case "bossgroup": 
            case "bossGroup": {
                return this.getOrCreateConfiguration(target).getBossGroup();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "broadcast": {
                return this.getOrCreateConfiguration(target).isBroadcast();
            }
            case "channelgroup": 
            case "channelGroup": {
                return this.getOrCreateConfiguration(target).getChannelGroup();
            }
            case "clientinitializerfactory": 
            case "clientInitializerFactory": {
                return this.getOrCreateConfiguration(target).getClientInitializerFactory();
            }
            case "clientmode": 
            case "clientMode": {
                return this.getOrCreateConfiguration(target).isClientMode();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return this.getOrCreateConfiguration(target).getConnectTimeout();
            }
            case "correlationmanager": 
            case "correlationManager": {
                return this.getOrCreateConfiguration(target).getCorrelationManager();
            }
            case "decodermaxlinelength": 
            case "decoderMaxLineLength": {
                return this.getOrCreateConfiguration(target).getDecoderMaxLineLength();
            }
            case "decoders": {
                return this.getOrCreateConfiguration(target).getDecoders();
            }
            case "delimiter": {
                return this.getOrCreateConfiguration(target).getDelimiter();
            }
            case "disconnect": {
                return this.getOrCreateConfiguration(target).isDisconnect();
            }
            case "disconnectonnoreply": 
            case "disconnectOnNoReply": {
                return this.getOrCreateConfiguration(target).isDisconnectOnNoReply();
            }
            case "enabledprotocols": 
            case "enabledProtocols": {
                return this.getOrCreateConfiguration(target).getEnabledProtocols();
            }
            case "encoders": {
                return this.getOrCreateConfiguration(target).getEncoders();
            }
            case "encoding": {
                return this.getOrCreateConfiguration(target).getEncoding();
            }
            case "executorservice": 
            case "executorService": {
                return target.getExecutorService();
            }
            case "hostnameverification": 
            case "hostnameVerification": {
                return this.getOrCreateConfiguration(target).isHostnameVerification();
            }
            case "keepalive": 
            case "keepAlive": {
                return this.getOrCreateConfiguration(target).isKeepAlive();
            }
            case "keystorefile": 
            case "keyStoreFile": {
                return this.getOrCreateConfiguration(target).getKeyStoreFile();
            }
            case "keystoreformat": 
            case "keyStoreFormat": {
                return this.getOrCreateConfiguration(target).getKeyStoreFormat();
            }
            case "keystoreresource": 
            case "keyStoreResource": {
                return this.getOrCreateConfiguration(target).getKeyStoreResource();
            }
            case "lazychannelcreation": 
            case "lazyChannelCreation": {
                return this.getOrCreateConfiguration(target).isLazyChannelCreation();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maximumpoolsize": 
            case "maximumPoolSize": {
                return target.getMaximumPoolSize();
            }
            case "nativetransport": 
            case "nativeTransport": {
                return this.getOrCreateConfiguration(target).isNativeTransport();
            }
            case "needclientauth": 
            case "needClientAuth": {
                return this.getOrCreateConfiguration(target).isNeedClientAuth();
            }
            case "nettyserverbootstrapfactory": 
            case "nettyServerBootstrapFactory": {
                return this.getOrCreateConfiguration(target).getNettyServerBootstrapFactory();
            }
            case "networkinterface": 
            case "networkInterface": {
                return this.getOrCreateConfiguration(target).getNetworkInterface();
            }
            case "noreplyloglevel": 
            case "noReplyLogLevel": {
                return this.getOrCreateConfiguration(target).getNoReplyLogLevel();
            }
            case "options": {
                return this.getOrCreateConfiguration(target).getOptions();
            }
            case "passphrase": {
                return this.getOrCreateConfiguration(target).getPassphrase();
            }
            case "producerpoolenabled": 
            case "producerPoolEnabled": {
                return this.getOrCreateConfiguration(target).isProducerPoolEnabled();
            }
            case "producerpoolmaxidle": 
            case "producerPoolMaxIdle": {
                return this.getOrCreateConfiguration(target).getProducerPoolMaxIdle();
            }
            case "producerpoolmaxtotal": 
            case "producerPoolMaxTotal": {
                return this.getOrCreateConfiguration(target).getProducerPoolMaxTotal();
            }
            case "producerpoolminevictableidle": 
            case "producerPoolMinEvictableIdle": {
                return this.getOrCreateConfiguration(target).getProducerPoolMinEvictableIdle();
            }
            case "producerpoolminidle": 
            case "producerPoolMinIdle": {
                return this.getOrCreateConfiguration(target).getProducerPoolMinIdle();
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                return this.getOrCreateConfiguration(target).getReceiveBufferSize();
            }
            case "receivebuffersizepredictor": 
            case "receiveBufferSizePredictor": {
                return this.getOrCreateConfiguration(target).getReceiveBufferSizePredictor();
            }
            case "reconnect": {
                return this.getOrCreateConfiguration(target).isReconnect();
            }
            case "reconnectinterval": 
            case "reconnectInterval": {
                return this.getOrCreateConfiguration(target).getReconnectInterval();
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return this.getOrCreateConfiguration(target).getRequestTimeout();
            }
            case "reuseaddress": 
            case "reuseAddress": {
                return this.getOrCreateConfiguration(target).isReuseAddress();
            }
            case "reusechannel": 
            case "reuseChannel": {
                return this.getOrCreateConfiguration(target).isReuseChannel();
            }
            case "securityprovider": 
            case "securityProvider": {
                return this.getOrCreateConfiguration(target).getSecurityProvider();
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                return this.getOrCreateConfiguration(target).getSendBufferSize();
            }
            case "serverclosedchannelexceptioncaughtloglevel": 
            case "serverClosedChannelExceptionCaughtLogLevel": {
                return this.getOrCreateConfiguration(target).getServerClosedChannelExceptionCaughtLogLevel();
            }
            case "serverexceptioncaughtloglevel": 
            case "serverExceptionCaughtLogLevel": {
                return this.getOrCreateConfiguration(target).getServerExceptionCaughtLogLevel();
            }
            case "serverinitializerfactory": 
            case "serverInitializerFactory": {
                return this.getOrCreateConfiguration(target).getServerInitializerFactory();
            }
            case "ssl": {
                return this.getOrCreateConfiguration(target).isSsl();
            }
            case "sslclientcertheaders": 
            case "sslClientCertHeaders": {
                return this.getOrCreateConfiguration(target).isSslClientCertHeaders();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return this.getOrCreateConfiguration(target).getSslContextParameters();
            }
            case "sslhandler": 
            case "sslHandler": {
                return this.getOrCreateConfiguration(target).getSslHandler();
            }
            case "sync": {
                return this.getOrCreateConfiguration(target).isSync();
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                return this.getOrCreateConfiguration(target).isTcpNoDelay();
            }
            case "textline": {
                return this.getOrCreateConfiguration(target).isTextline();
            }
            case "transferexchange": 
            case "transferExchange": {
                return this.getOrCreateConfiguration(target).isTransferExchange();
            }
            case "truststorefile": 
            case "trustStoreFile": {
                return this.getOrCreateConfiguration(target).getTrustStoreFile();
            }
            case "truststoreresource": 
            case "trustStoreResource": {
                return this.getOrCreateConfiguration(target).getTrustStoreResource();
            }
            case "udpbytearraycodec": 
            case "udpByteArrayCodec": {
                return this.getOrCreateConfiguration(target).isUdpByteArrayCodec();
            }
            case "udpconnectionlesssending": 
            case "udpConnectionlessSending": {
                return this.getOrCreateConfiguration(target).isUdpConnectionlessSending();
            }
            case "usebytebuf": 
            case "useByteBuf": {
                return this.getOrCreateConfiguration(target).isUseByteBuf();
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return target.isUseGlobalSslContextParameters();
            }
            case "usingexecutorservice": 
            case "usingExecutorService": {
                return this.getOrCreateConfiguration(target).isUsingExecutorService();
            }
            case "workercount": 
            case "workerCount": {
                return this.getOrCreateConfiguration(target).getWorkerCount();
            }
            case "workergroup": 
            case "workerGroup": {
                return this.getOrCreateConfiguration(target).getWorkerGroup();
            }
        }
        return null;
    }

    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "options": {
                return Object.class;
            }
        }
        return null;
    }
}

