/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="properties")
public class PropertiesDevConsole
extends AbstractDevConsole {
    public PropertiesDevConsole() {
        super("camel", "properties", "Properties", "Displays the properties loaded by Camel");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        String loc = String.join((CharSequence)", ", pc.getLocations());
        sb.append(String.format("Properties loaded from locations: %s", loc));
        sb.append("\n");
        for (Map.Entry<Object, Object> entry : pc.loadProperties().entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            sb.append(String.format("\n    %s = %s", k, v));
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        root.put((Object)"locations", (Object)pc.getLocations());
        JsonObject props = new JsonObject();
        root.put((Object)"properties", (Object)props);
        for (Map.Entry<Object, Object> entry : pc.loadProperties().entrySet()) {
            String k = entry.getKey().toString();
            Object v = entry.getValue();
            props.put((Object)k, v);
        }
        return root;
    }
}

