/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.NatsJetStreamClientError;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

public abstract class Validator {
    static final char[] WILD_GT = new char[]{'*', '>'};
    static final char[] WILD_GT_DOT = new char[]{'*', '>', '.'};
    static final char[] WILD_GT_DOT_SLASHES = new char[]{'*', '>', '.', '\\', '/'};

    private Validator() {
    }

    public static String validateSubject(String s, boolean required) {
        return Validator.validatePrintable(s, "Subject", required);
    }

    public static String validateReplyTo(String s, boolean required) {
        return Validator.validatePrintableExceptWildGt(s, "Reply To", required);
    }

    public static String validateQueueName(String s, boolean required) {
        return Validator.validatePrintableExceptWildDotGt(s, "Queue", required);
    }

    public static String validateStreamName(String s, boolean required) {
        return Validator.validatePrintableExceptWildDotGtSlashes(s, "Stream", required);
    }

    public static String validateDurable(String s, boolean required) {
        return Validator.validatePrintableExceptWildDotGtSlashes(s, "Durable", required);
    }

    public static String validateConsumerName(String s, boolean required) {
        return Validator.validatePrintableExceptWildDotGtSlashes(s, "Name", required);
    }

    public static String validatePrefixOrDomain(String s, String label, boolean required) {
        return Validator._validate(s, required, label, () -> {
            if (s.startsWith(".")) {
                throw new IllegalArgumentException(label + " cannot start with `.` [" + s + "]");
            }
            if (Validator.notPrintableOrHasWildGt(s)) {
                throw new IllegalArgumentException(label + " must be in the printable ASCII range and cannot include `*`, `>` [" + s + "]");
            }
            return s;
        });
    }

    public static String validateKvKeyWildcardAllowedRequired(String s) {
        return Validator.validateWildcardKvKey(s, "Key", true);
    }

    public static String validateNonWildcardKvKeyRequired(String s) {
        return Validator.validateNonWildcardKvKey(s, "Key", true);
    }

    public static void validateNotSupplied(String s, NatsJetStreamClientError err) {
        if (!Validator.nullOrEmpty(s)) {
            throw err.instance();
        }
    }

    public static String validateMustMatchIfBothSupplied(String s1, String s2, NatsJetStreamClientError err) {
        s1 = Validator.emptyAsNull(s1);
        s2 = Validator.emptyAsNull(s2);
        if (s1 == null) {
            return s2;
        }
        if (s2 == null || s1.equals(s2)) {
            return s1;
        }
        throw err.instance();
    }

    public static String required(String s, String label) {
        if (Validator.emptyAsNull(s) == null) {
            throw new IllegalArgumentException(label + " cannot be null or empty.");
        }
        return s;
    }

    public static String _validate(String s, boolean required, String label, Check check) {
        if (Validator.emptyAsNull(s) == null) {
            if (required) {
                throw new IllegalArgumentException(label + " cannot be null or empty.");
            }
            return null;
        }
        return check.check();
    }

    public static String validateMaxLength(String s, int maxLength, boolean required, String label) {
        return Validator._validate(s, required, label, () -> {
            int len = s.getBytes(StandardCharsets.UTF_8).length;
            if (len > maxLength) {
                throw new IllegalArgumentException(label + " cannot be longer than " + maxLength + " bytes but was " + len + " bytes");
            }
            return s;
        });
    }

    public static String validatePrintable(String s, String label, boolean required) {
        return Validator._validate(s, required, label, () -> {
            if (Validator.notPrintable(s)) {
                throw new IllegalArgumentException(label + " must be in the printable ASCII range [" + s + "]");
            }
            return s;
        });
    }

    public static String validatePrintableExceptWildDotGt(String s, String label, boolean required) {
        return Validator._validate(s, required, label, () -> {
            if (Validator.notPrintableOrHasWildGtDot(s)) {
                throw new IllegalArgumentException(label + " must be in the printable ASCII range and cannot include `*`, `.` or `>` [" + s + "]");
            }
            return s;
        });
    }

    public static String validatePrintableExceptWildDotGtSlashes(String s, String label, boolean required) {
        return Validator._validate(s, required, label, () -> {
            if (Validator.notPrintableOrHasWildGtDotSlashes(s)) {
                throw new IllegalArgumentException(label + " must be in the printable ASCII range and cannot include `*`, `.`, `>`, `\\` or  `/` [" + s + "]");
            }
            return s;
        });
    }

    public static String validatePrintableExceptWildGt(String s, String label, boolean required) {
        return Validator._validate(s, required, label, () -> {
            if (Validator.notPrintableOrHasWildGt(s)) {
                throw new IllegalArgumentException(label + " must be in the printable ASCII range and cannot include `*` or `>` [" + s + "]");
            }
            return s;
        });
    }

    public static String validateBucketName(String s, boolean required) {
        return Validator._validate(s, required, "Bucket Name", () -> {
            if (Validator.notRestrictedTerm(s)) {
                throw new IllegalArgumentException("Bucket Name must only contain A-Z, a-z, 0-9, `-` or `_` [" + s + "]");
            }
            return s;
        });
    }

    public static String validateWildcardKvKey(String s, String label, boolean required) {
        return Validator._validate(s, required, label, () -> {
            if (Validator.notWildcardKvKey(s)) {
                throw new IllegalArgumentException(label + " must only contain A-Z, a-z, 0-9, `*`, `-`, `_`, `/`, `=`, `>` or `.` and cannot start with `.` [" + s + "]");
            }
            return s;
        });
    }

    public static String validateNonWildcardKvKey(String s, String label, boolean required) {
        return Validator._validate(s, required, label, () -> {
            if (Validator.notNonWildcardKvKey(s)) {
                throw new IllegalArgumentException(label + " must only contain A-Z, a-z, 0-9, `-`, `_`, `/`, `=` or `.` and cannot start with `.` [" + s + "]");
            }
            return s;
        });
    }

    public static long validateMaxConsumers(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Consumers");
    }

    public static long validateMaxMessages(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Messages");
    }

    public static long validateMaxMessagesPerSubject(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Messages Per Subject");
    }

    public static int validateMaxHistory(int max) {
        if (max < 2) {
            return 1;
        }
        if (max > 64) {
            throw new IllegalArgumentException("Max History Per Key cannot be more than 64");
        }
        return max;
    }

    public static long validateMaxBytes(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Bytes");
    }

    public static long validateMaxBucketBytes(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Bucket Bytes");
    }

    public static long validateMaxMessageSize(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Message Size");
    }

    public static long validateMaxValueSize(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Value Size");
    }

    public static int validateNumberOfReplicas(int replicas) {
        if (replicas < 1 || replicas > 5) {
            throw new IllegalArgumentException("Replicas must be from 1 to 5 inclusive.");
        }
        return replicas;
    }

    public static Duration validateDurationRequired(Duration d) {
        if (d == null || d.isZero() || d.isNegative()) {
            throw new IllegalArgumentException("Duration required and must be greater than 0.");
        }
        return d;
    }

    public static Duration validateDurationNotRequiredGtOrEqZero(Duration d, Duration ifNull) {
        if (d == null) {
            return ifNull;
        }
        if (d.isNegative()) {
            throw new IllegalArgumentException("Duration must be greater than or equal to 0.");
        }
        return d;
    }

    public static Duration validateDurationNotRequiredGtOrEqZero(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Duration must be greater than or equal to 0.");
        }
        return Duration.ofMillis(millis);
    }

    public static String validateNotNull(String s, String fieldName) {
        if (s == null) {
            throw new IllegalArgumentException(fieldName + " cannot be null");
        }
        return s;
    }

    public static Object validateNotNull(Object o, String fieldName) {
        if (o == null) {
            throw new IllegalArgumentException(fieldName + " cannot be null");
        }
        return o;
    }

    public static int validateGtZero(int i, String label) {
        if (i < 1) {
            throw new IllegalArgumentException(label + " must be greater than zero");
        }
        return i;
    }

    public static long validateGtZeroOrMinus1(long l, String label) {
        if (Validator.zeroOrLtMinus1(l)) {
            throw new IllegalArgumentException(label + " must be greater than zero or -1 for unlimited");
        }
        return l;
    }

    public static long validateGtEqMinus1(long l, String label) {
        if (l < -1L) {
            throw new IllegalArgumentException(label + " must be greater than zero or -1 for unlimited");
        }
        return l;
    }

    public static long validateNotNegative(long l, String label) {
        if (l < 0L) {
            throw new IllegalArgumentException(label + " cannot be negative");
        }
        return l;
    }

    public static long validateGtEqZero(long l, String label) {
        if (l < 0L) {
            throw new IllegalArgumentException(label + " must be greater than or equal to zero");
        }
        return l;
    }

    public static boolean nullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean notPrintable(String s) {
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c >= '!' && c <= '~') continue;
            return true;
        }
        return false;
    }

    public static boolean notPrintableOrHasChars(String s, char[] charsToNotHave) {
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c < '!' || c > '~') {
                return true;
            }
            for (char cx : charsToNotHave) {
                if (c != cx) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean notRestrictedTerm(String s) {
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c < '0') {
                if (c == '-') continue;
                return true;
            }
            if (c < ':') continue;
            if (c < 'A') {
                return true;
            }
            if (c < '[') continue;
            if (c < 'a') {
                if (c == '_') continue;
                return true;
            }
            if (c <= 'z') continue;
            return true;
        }
        return false;
    }

    public static boolean notNonWildcardKvKey(String s) {
        if (s.charAt(0) == '.') {
            return true;
        }
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c < '0') {
                if (c == '-' || c == '.' || c == '/') continue;
                return true;
            }
            if (c < ':') continue;
            if (c < 'A') {
                if (c == '=') continue;
                return true;
            }
            if (c < '[') continue;
            if (c < 'a') {
                if (c == '_') continue;
                return true;
            }
            if (c <= 'z') continue;
            return true;
        }
        return false;
    }

    public static boolean notWildcardKvKey(String s) {
        if (s.charAt(0) == '.') {
            return true;
        }
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c < '0') {
                if (c == '*' || c == '-' || c == '.' || c == '/') continue;
                return true;
            }
            if (c < ':') continue;
            if (c < 'A') {
                if (c == '=' || c == '>') continue;
                return true;
            }
            if (c < '[') continue;
            if (c < 'a') {
                if (c == '_') continue;
                return true;
            }
            if (c <= 'z') continue;
            return true;
        }
        return false;
    }

    private static boolean notPrintableOrHasWildGt(String s) {
        return Validator.notPrintableOrHasChars(s, WILD_GT);
    }

    private static boolean notPrintableOrHasWildGtDot(String s) {
        return Validator.notPrintableOrHasChars(s, WILD_GT_DOT);
    }

    private static boolean notPrintableOrHasWildGtDotSlashes(String s) {
        return Validator.notPrintableOrHasChars(s, WILD_GT_DOT_SLASHES);
    }

    public static String emptyAsNull(String s) {
        return Validator.nullOrEmpty(s) ? null : s;
    }

    public static String emptyOrNullAs(String s, String ifEmpty) {
        return Validator.nullOrEmpty(s) ? ifEmpty : s;
    }

    public static boolean zeroOrLtMinus1(long l) {
        return l == 0L || l < -1L;
    }

    public static Duration ensureNotNullAndNotLessThanMin(Duration provided, Duration minimum, Duration dflt) {
        return provided == null || provided.toNanos() < minimum.toNanos() ? dflt : provided;
    }

    public static Duration ensureDurationNotLessThanMin(long providedMillis, Duration minimum, Duration dflt) {
        return Validator.ensureNotNullAndNotLessThanMin(Duration.ofMillis(providedMillis), minimum, dflt);
    }

    public static String ensureEndsWithDot(String s) {
        return s == null || s.endsWith(".") ? s : s + ".";
    }

    static interface Check {
        public String check();
    }
}

