/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.impl.Headers;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public abstract class NatsObjectStoreUtil {
    public static final int DEFAULT_CHUNK_SIZE = 131072;
    public static final String OBJ_STREAM_PREFIX = "OBJ_";
    public static final int OBJ_STREAM_PREFIX_LEN = "OBJ_".length();
    public static final String OBJ_SUBJECT_PREFIX = "$O.";
    public static final String OBJ_SUBJECT_SUFFIX = ".>";
    public static final String OBJ_META_PART = ".M";
    public static final String OBJ_CHUNK_PART = ".C";

    private NatsObjectStoreUtil() {
    }

    public static String extractBucketName(String streamName) {
        return streamName.substring(OBJ_STREAM_PREFIX_LEN);
    }

    public static String toStreamName(String bucketName) {
        return OBJ_STREAM_PREFIX + bucketName;
    }

    public static String toMetaStreamSubject(String bucketName) {
        return OBJ_SUBJECT_PREFIX + bucketName + OBJ_META_PART + OBJ_SUBJECT_SUFFIX;
    }

    public static String toChunkStreamSubject(String bucketName) {
        return OBJ_SUBJECT_PREFIX + bucketName + OBJ_CHUNK_PART + OBJ_SUBJECT_SUFFIX;
    }

    public static String toMetaPrefix(String bucketName) {
        return OBJ_SUBJECT_PREFIX + bucketName + OBJ_META_PART + ".";
    }

    public static String toChunkPrefix(String bucketName) {
        return OBJ_SUBJECT_PREFIX + bucketName + OBJ_CHUNK_PART + ".";
    }

    public static String encodeForSubject(String name) {
        return Base64.getEncoder().encodeToString(name.getBytes(StandardCharsets.UTF_8));
    }

    public static Headers getMetaHeaders() {
        return new Headers().put("Nats-Rollup", "sub");
    }
}

