/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.impl.Headers;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.IncomingHeadersProcessor;
import io.nats.client.support.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;

public class MessageInfo
extends ApiResponse<MessageInfo> {
    private final String subject;
    private final long seq;
    private final byte[] data;
    private final ZonedDateTime time;
    private final Headers headers;
    private final String stream;
    private final long lastSeq;

    @Deprecated
    public MessageInfo(Message msg) {
        this(msg, null, false);
    }

    public MessageInfo(Message msg, String streamName, boolean fromDirect) {
        super(fromDirect ? null : new String(msg.getData(), StandardCharsets.UTF_8));
        if (fromDirect) {
            this.headers = msg.getHeaders();
            this.subject = this.headers.getFirst("Nats-Subject");
            this.data = msg.getData();
            this.seq = Long.parseLong(this.headers.getFirst("Nats-Sequence"));
            this.time = DateTimeUtils.parseDateTime(this.headers.getFirst("Nats-Time-Stamp"));
            this.stream = this.headers.getFirst("Nats-Stream");
            String temp = this.headers.getFirst("Nats-Last-Sequence");
            this.lastSeq = temp == null ? -1L : JsonUtils.safeParseLong(temp, -1L);
            this.headers.remove("Nats-Subject", "Nats-Sequence", "Nats-Time-Stamp", "Nats-Stream", "Nats-Last-Sequence");
        } else if (this.hasError()) {
            this.subject = null;
            this.data = null;
            this.seq = -1L;
            this.time = null;
            this.headers = null;
            this.stream = null;
            this.lastSeq = -1L;
        } else {
            this.subject = JsonUtils.readString(this.json, ApiConstants.SUBJECT_RE);
            this.data = JsonUtils.readBase64(this.json, ApiConstants.DATA_RE);
            this.seq = JsonUtils.readLong(this.json, ApiConstants.SEQ_RE, 0L);
            this.time = JsonUtils.readDate(this.json, ApiConstants.TIME_RE);
            byte[] hdrBytes = JsonUtils.readBase64(this.json, ApiConstants.HDRS_RE);
            this.headers = hdrBytes == null ? null : new IncomingHeadersProcessor(hdrBytes).getHeaders();
            this.stream = streamName;
            this.lastSeq = -1L;
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public long getSeq() {
        return this.seq;
    }

    public byte[] getData() {
        return this.data;
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getStream() {
        return this.stream;
    }

    public long getLastSeq() {
        return this.lastSeq;
    }

    public String toString() {
        return "MessageInfo{subject='" + this.subject + '\'' + ", seq=" + this.seq + ", " + (this.data == null ? "data=null" : "data bytes " + this.data.length) + ", time=" + this.time + ", stream=" + this.stream + (this.lastSeq < 1L ? "" : ", lastSeq=" + this.lastSeq) + ", headers=" + this.headers + '}';
    }
}

