/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task;

import java.time.Duration;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.camel.support.task.AbstractTaskBuilder;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.budget.IterationBudget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForegroundTask
implements BlockingTask {
    private static final Logger LOG = LoggerFactory.getLogger(ForegroundTask.class);
    private final String name;
    private IterationBudget budget;
    private Duration elapsed = Duration.ZERO;

    ForegroundTask(IterationBudget budget, String name) {
        this.budget = budget;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean run(Predicate<T> predicate, T payload) {
        boolean completed = false;
        try {
            if (this.budget.initialDelay() > 0L) {
                Thread.sleep(this.budget.initialDelay());
            }
            while (this.budget.next()) {
                if (predicate.test(payload)) {
                    LOG.debug("Task {} is complete after {} iterations and it is ready to continue", (Object)this.name, (Object)this.budget.iteration());
                    completed = true;
                    break;
                }
                if (!this.budget.canContinue()) continue;
                Thread.sleep(this.budget.interval());
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted {} while waiting for the repeatable task to finish", (Object)this.name);
            Thread.currentThread().interrupt();
        }
        finally {
            this.elapsed = this.budget.elapsed();
        }
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(BooleanSupplier supplier) {
        boolean completed = false;
        try {
            if (this.budget.initialDelay() > 0L) {
                Thread.sleep(this.budget.initialDelay());
            }
            while (this.budget.next()) {
                if (supplier.getAsBoolean()) {
                    LOG.debug("Task {} is complete after {} iterations and it is ready to continue", (Object)this.name, (Object)this.budget.iteration());
                    completed = true;
                    break;
                }
                if (!this.budget.canContinue()) continue;
                Thread.sleep(this.budget.interval());
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted {} while waiting for the repeatable task to finish", (Object)this.name);
            Thread.currentThread().interrupt();
        }
        finally {
            this.elapsed = this.budget.elapsed();
        }
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Optional<T> run(Supplier<T> supplier, Predicate<T> predicate) {
        try {
            if (this.budget.initialDelay() > 0L) {
                Thread.sleep(this.budget.initialDelay());
            }
            while (this.budget.next()) {
                T ret = supplier.get();
                if (predicate.test(ret)) {
                    LOG.debug("Task {} is complete after {} iterations and it is ready to continue", (Object)this.name, (Object)this.budget.iteration());
                    Optional<T> optional = Optional.ofNullable(ret);
                    return optional;
                }
                if (!this.budget.canContinue()) continue;
                Thread.sleep(this.budget.interval());
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted {} while waiting for the repeatable task to finish", (Object)this.name);
            Thread.currentThread().interrupt();
        }
        finally {
            this.elapsed = this.budget.elapsed();
        }
        return Optional.empty();
    }

    @Override
    public Duration elapsed() {
        return this.elapsed;
    }

    public static class ForegroundTaskBuilder
    extends AbstractTaskBuilder<ForegroundTask> {
        private IterationBudget budget;

        public ForegroundTaskBuilder withBudget(IterationBudget budget) {
            this.budget = budget;
            return this;
        }

        @Override
        public ForegroundTask build() {
            return new ForegroundTask(this.budget, this.getName());
        }
    }
}

