/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.KvOperation;
import io.nats.client.api.MessageInfo;
import io.nats.client.support.NatsKeyValueUtil;
import java.time.ZonedDateTime;

public class KvEntry
extends ApiResponse<KvEntry> {
    private final String bucket;
    private final String key;
    private final long seq;
    private final byte[] data;
    private final ZonedDateTime created;
    private final KvOperation kvOperation;

    public KvEntry(MessageInfo mi) {
        String[] bk = KvEntry.extractBK(mi.getSubject());
        this.bucket = bk[1];
        this.key = bk[2];
        this.seq = mi.getSeq();
        this.data = KvEntry.extractData(mi.getData());
        this.created = mi.getTime();
        this.kvOperation = KvOperation.getOrDefault(NatsKeyValueUtil.getHeader(mi.getHeaders()), KvOperation.PUT);
    }

    public KvEntry(Message m) {
        String[] bk = KvEntry.extractBK(m.getSubject());
        this.bucket = bk[1];
        this.key = bk[2];
        this.seq = m.metaData().streamSequence();
        this.data = KvEntry.extractData(m.getData());
        this.created = m.metaData().timestamp();
        this.kvOperation = KvOperation.getOrDefault(NatsKeyValueUtil.getHeader(m.getHeaders()), KvOperation.PUT);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public long getSeq() {
        return this.seq;
    }

    public byte[] getData() {
        return this.data;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public KvOperation getKvOperation() {
        return this.kvOperation;
    }

    public String toString() {
        return "KvEntry{bucket='" + this.bucket + '\'' + ", key='" + this.key + '\'' + ", kvOperation=" + (Object)((Object)this.kvOperation) + ", seq=" + this.seq + ", data=" + (this.data == null ? "null" : "[" + this.data.length + " bytes]") + ", created=" + this.created + '}';
    }

    private static byte[] extractData(byte[] data) {
        return data == null || data.length == 0 ? null : data;
    }

    private static String[] extractBK(String subject) {
        return subject.split("\\Q.\\E");
    }
}

