/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.WebsocketFrameHeader;
import java.io.IOException;
import java.io.InputStream;

public class WebsocketInputStream
extends InputStream {
    private byte[] buffer = new byte[WebsocketFrameHeader.MAX_FRAME_HEADER_SIZE];
    private WebsocketFrameHeader header = new WebsocketFrameHeader();
    private InputStream in;
    private byte[] oneByte = new byte[1];

    public WebsocketInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        while (0L == this.header.getPayloadLength()) {
            if (this.readHeader()) continue;
            return -1;
        }
        if (this.header.getOpCode() == WebsocketFrameHeader.OpCode.CLOSE) {
            this.in.skip(this.header.getPayloadLength());
            return -1;
        }
        long headerPayloadLength = this.header.getPayloadLength();
        int payloadLength = Math.min(length, headerPayloadLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)headerPayloadLength);
        if (-1 == (length = this.in.read(buffer, offset, payloadLength))) {
            return length;
        }
        return this.header.filterPayload(buffer, offset, length);
    }

    @Override
    public int read() throws IOException {
        int result = this.read(this.oneByte, 0, 1);
        if (-1 == result) {
            return result;
        }
        return this.oneByte[0];
    }

    private boolean readHeader() throws IOException {
        int len;
        int result;
        for (len = 0; len < 2; len += result) {
            result = this.in.read(this.buffer, len, 2 - len);
            if (result >= 0) continue;
            return false;
        }
        int headerSize = WebsocketFrameHeader.size(this.buffer, 0);
        if (headerSize > 2) {
            while (len < headerSize) {
                int result2 = this.in.read(this.buffer, len, headerSize - len);
                if (result2 < 0) {
                    return false;
                }
                len += result2;
            }
        }
        this.header.write(this.buffer, 0, headerSize);
        return true;
    }
}

