/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

public class ServerVersion
implements Comparable<ServerVersion> {
    final Integer major;
    final Integer minor;
    final Integer patch;
    final String extra;

    public ServerVersion(String v) {
        int mjr;
        int mnr = -1;
        int ptch = -1;
        String xtra = null;
        try {
            String[] split = v.startsWith("v") ? v.substring(1).replaceAll("-", ".").split("\\Q.\\E") : v.replaceAll("-", ".").split("\\Q.\\E");
            mjr = Integer.parseInt(split[0]);
            mnr = Integer.parseInt(split[1]);
            ptch = split.length < 3 ? -1 : Integer.parseInt(split[2]);
            for (int i = 3; i < split.length; ++i) {
                xtra = i == 3 ? "-" + split[i] : xtra + "." + split[i];
            }
        }
        catch (NumberFormatException nfe) {
            mjr = -1;
        }
        if (mjr == -1) {
            this.major = -1;
            this.minor = -1;
            this.patch = -1;
            this.extra = null;
        } else {
            this.major = mjr;
            this.minor = mnr;
            this.patch = ptch;
            this.extra = xtra;
        }
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (this.extra == null ? "" : this.extra);
    }

    @Override
    public int compareTo(ServerVersion o) {
        int c = this.major.compareTo(o.major);
        if (c == 0 && (c = this.minor.compareTo(o.minor)) == 0 && (c = this.patch.compareTo(o.patch)) == 0) {
            c = this.extra == null ? (o.extra == null ? 0 : 1) : (o.extra == null ? -1 : this.extra.compareTo(o.extra));
        }
        return c;
    }

    public static boolean isNewer(String v, String than) {
        return new ServerVersion(v).compareTo(new ServerVersion(than)) > 0;
    }

    public static boolean isSame(String v, String than) {
        return new ServerVersion(v).compareTo(new ServerVersion(than)) == 0;
    }

    public static boolean isOlder(String v, String than) {
        return new ServerVersion(v).compareTo(new ServerVersion(than)) < 0;
    }

    public static boolean isSameOrOlder(String v, String than) {
        return new ServerVersion(v).compareTo(new ServerVersion(than)) <= 0;
    }

    public static boolean isSameOrNewer(String v, String than) {
        return new ServerVersion(v).compareTo(new ServerVersion(than)) >= 0;
    }
}

