/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ErrorListener;
import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.Status;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;

class PushMessageManager
extends MessageManager {
    protected static final List<Integer> PUSH_KNOWN_STATUS_CODES = Collections.singletonList(409);
    protected static final int THRESHOLD = 3;
    protected final NatsConnection conn;
    protected final NatsJetStream js;
    protected final String stream;
    protected final ConsumerConfiguration serverCC;
    protected final NatsDispatcher dispatcher;
    protected final boolean syncMode;
    protected final boolean queueMode;
    protected final boolean hb;
    protected final boolean fc;
    protected final long idleHeartbeatSetting;
    protected final long alarmPeriodSetting;
    protected String lastFcSubject;
    protected long lastStreamSeq;
    protected long lastConsumerSeq;
    protected final AtomicLong lastMsgReceived;
    protected HeartbeatTimer heartbeatTimer;

    PushMessageManager(NatsConnection conn, NatsJetStream js, String stream, SubscribeOptions so, ConsumerConfiguration serverCC, boolean queueMode, NatsDispatcher dispatcher) {
        this.conn = conn;
        this.js = js;
        this.stream = stream;
        this.serverCC = serverCC;
        this.dispatcher = dispatcher;
        this.syncMode = dispatcher == null;
        this.queueMode = queueMode;
        this.lastStreamSeq = -1L;
        this.lastConsumerSeq = -1L;
        this.lastMsgReceived = new AtomicLong(System.currentTimeMillis());
        if (queueMode) {
            this.hb = false;
            this.fc = false;
            this.idleHeartbeatSetting = 0L;
            this.alarmPeriodSetting = 0L;
        } else {
            long l = this.idleHeartbeatSetting = serverCC.getIdleHeartbeat() == null ? 0L : serverCC.getIdleHeartbeat().toMillis();
            if (this.idleHeartbeatSetting <= 0L) {
                this.alarmPeriodSetting = 0L;
                this.hb = false;
            } else {
                long mat = so.getMessageAlarmTime();
                this.alarmPeriodSetting = mat < this.idleHeartbeatSetting ? this.idleHeartbeatSetting * 3L : mat;
                this.hb = true;
            }
            this.fc = this.hb && serverCC.isFlowControl();
        }
    }

    @Override
    void startup(NatsJetStreamSubscription sub) {
        super.startup(sub);
        if (this.hb) {
            sub.setBeforeQueueProcessor(this::beforeQueueProcessor);
            this.heartbeatTimer = new HeartbeatTimer();
        }
    }

    @Override
    void shutdown() {
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.shutdown();
            this.heartbeatTimer = null;
        }
        super.shutdown();
    }

    protected void handleHeartbeatError() {
        this.conn.executeCallback((c, el) -> el.heartbeatAlarm(c, this.sub, this.lastStreamSeq, this.lastConsumerSeq));
    }

    boolean isSyncMode() {
        return this.syncMode;
    }

    boolean isQueueMode() {
        return this.queueMode;
    }

    boolean isFc() {
        return this.fc;
    }

    boolean isHb() {
        return this.hb;
    }

    long getIdleHeartbeatSetting() {
        return this.idleHeartbeatSetting;
    }

    long getAlarmPeriodSetting() {
        return this.alarmPeriodSetting;
    }

    String getLastFcSubject() {
        return this.lastFcSubject;
    }

    long getLastStreamSequence() {
        return this.lastStreamSeq;
    }

    long getLastConsumerSequence() {
        return this.lastConsumerSeq;
    }

    long getLastMsgReceived() {
        return this.lastMsgReceived.get();
    }

    NatsMessage beforeQueueProcessor(NatsMessage msg) {
        this.lastMsgReceived.set(System.currentTimeMillis());
        if (msg.isStatusMessage() && msg.getStatus().isHeartbeat() && this.extractFcSubject(msg) == null) {
            return null;
        }
        return msg;
    }

    protected boolean subManage(Message msg) {
        return false;
    }

    @Override
    boolean manage(Message msg) {
        if (!this.sub.getSID().equals(msg.getSID())) {
            return true;
        }
        if (msg.isStatusMessage()) {
            Status status = msg.getStatus();
            if (status.isFlowControl()) {
                if (this.fc) {
                    this._processFlowControl(msg.getReplyTo(), ErrorListener.FlowControlSource.FLOW_CONTROL);
                }
            } else if (status.isHeartbeat()) {
                if (this.fc) {
                    this._processFlowControl(this.extractFcSubject(msg), ErrorListener.FlowControlSource.HEARTBEAT);
                }
            } else if (!PUSH_KNOWN_STATUS_CODES.contains(status.getCode())) {
                this.conn.executeCallback((c, el) -> el.unhandledStatus(c, this.sub, status));
                if (this.syncMode) {
                    throw new JetStreamStatusException(this.sub, status);
                }
            }
            return true;
        }
        if (this.subManage(msg)) {
            return true;
        }
        this.lastStreamSeq = msg.metaData().streamSequence();
        this.lastConsumerSeq = msg.metaData().consumerSequence();
        return false;
    }

    String extractFcSubject(Message msg) {
        return msg.getHeaders() == null ? null : msg.getHeaders().getFirst("Nats-Consumer-Stalled");
    }

    private void _processFlowControl(String fcSubject, ErrorListener.FlowControlSource source) {
        if (fcSubject != null && !fcSubject.equals(this.lastFcSubject)) {
            this.conn.publishInternal(fcSubject, null, null, null, false);
            this.lastFcSubject = fcSubject;
            this.conn.executeCallback((c, el) -> el.flowControlProcessed(c, this.sub, fcSubject, source));
        }
    }

    class HeartbeatTimer {
        Timer timer;
        boolean alive = true;

        public HeartbeatTimer() {
            this.restart();
        }

        synchronized void restart() {
            this.cancel();
            if (this.alive) {
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new HeartbeatTimerTask(), PushMessageManager.this.alarmPeriodSetting);
            }
        }

        public synchronized void shutdown() {
            this.alive = false;
            this.cancel();
        }

        private void cancel() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
                this.timer = null;
            }
        }

        class HeartbeatTimerTask
        extends TimerTask {
            HeartbeatTimerTask() {
            }

            @Override
            public void run() {
                long sinceLast = System.currentTimeMillis() - PushMessageManager.this.lastMsgReceived.get();
                if (sinceLast > PushMessageManager.this.alarmPeriodSetting) {
                    PushMessageManager.this.handleHeartbeatError();
                }
                HeartbeatTimer.this.restart();
            }
        }
    }
}

