/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.KeyValue;
import io.nats.client.KeyValueOptions;
import io.nats.client.Message;
import io.nats.client.PurgeOptions;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.KeyValueEntry;
import io.nats.client.api.KeyValueOperation;
import io.nats.client.api.KeyValuePurgeOptions;
import io.nats.client.api.KeyValueStatus;
import io.nats.client.api.KeyValueWatchOption;
import io.nats.client.api.KeyValueWatcher;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.PublishAck;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsFeatureBase;
import io.nats.client.impl.NatsKeyValueWatchSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.NatsKeyValueUtil;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class NatsKeyValue
extends NatsFeatureBase
implements KeyValue {
    private final String bucketName;
    private final String streamSubject;
    private final String rawKeyPrefix;
    private final String pubSubKeyPrefix;

    NatsKeyValue(NatsConnection connection, String bucketName, KeyValueOptions kvo) throws IOException {
        super(connection, kvo);
        this.bucketName = Validator.validateBucketName(bucketName, true);
        this.streamName = NatsKeyValueUtil.toStreamName(bucketName);
        this.streamSubject = NatsKeyValueUtil.toStreamSubject(bucketName);
        this.rawKeyPrefix = NatsKeyValueUtil.toKeyPrefix(bucketName);
        this.pubSubKeyPrefix = kvo == null ? this.rawKeyPrefix : (kvo.getJetStreamOptions().isDefaultPrefix() ? this.rawKeyPrefix : kvo.getJetStreamOptions().getPrefix() + this.rawKeyPrefix);
    }

    String rawKeySubject(String key) {
        return this.rawKeyPrefix + key;
    }

    String pubSubKeySubject(String key) {
        return this.pubSubKeyPrefix + key;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public KeyValueEntry get(String key) throws IOException, JetStreamApiException {
        return this.existingOnly(this._get(Validator.validateNonWildcardKvKeyRequired(key)));
    }

    @Override
    public KeyValueEntry get(String key, long revision) throws IOException, JetStreamApiException {
        return this.existingOnly(this._get(Validator.validateNonWildcardKvKeyRequired(key), revision));
    }

    KeyValueEntry existingOnly(KeyValueEntry kve) {
        return kve == null || kve.getOperation() != KeyValueOperation.PUT ? null : kve;
    }

    KeyValueEntry _get(String key) throws IOException, JetStreamApiException {
        MessageInfo mi = this._getLast(this.rawKeySubject(key));
        return mi == null ? null : new KeyValueEntry(mi);
    }

    KeyValueEntry _get(String key, long revision) throws IOException, JetStreamApiException {
        KeyValueEntry kve;
        MessageInfo mi = this._getBySeq(revision);
        if (mi != null && key.equals((kve = new KeyValueEntry(mi)).getKey())) {
            return kve;
        }
        return null;
    }

    @Override
    public long put(String key, byte[] value) throws IOException, JetStreamApiException {
        return this._publishWithNonWildcardKey(key, value, null).getSeqno();
    }

    @Override
    public long put(String key, String value) throws IOException, JetStreamApiException {
        return this.put(key, value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public long put(String key, Number value) throws IOException, JetStreamApiException {
        return this.put(key, value.toString().getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public long create(String key, byte[] value) throws IOException, JetStreamApiException {
        Validator.validateNonWildcardKvKeyRequired(key);
        try {
            return this.update(key, value, 0L);
        }
        catch (JetStreamApiException e) {
            KeyValueEntry kve;
            if (e.getApiErrorCode() == 10071 && (kve = this._get(key)) != null && kve.getOperation() != KeyValueOperation.PUT) {
                return this.update(key, value, kve.getRevision());
            }
            throw e;
        }
    }

    @Override
    public long update(String key, byte[] value, long expectedRevision) throws IOException, JetStreamApiException {
        Validator.validateNonWildcardKvKeyRequired(key);
        Headers h = new Headers().add("Nats-Expected-Last-Subject-Sequence", Long.toString(expectedRevision));
        return this._publishWithNonWildcardKey(key, value, h).getSeqno();
    }

    @Override
    public void delete(String key) throws IOException, JetStreamApiException {
        Validator.validateNonWildcardKvKeyRequired(key);
        this._publishWithNonWildcardKey(key, null, NatsKeyValueUtil.getDeleteHeaders());
    }

    @Override
    public void purge(String key) throws IOException, JetStreamApiException {
        this._publishWithNonWildcardKey(key, null, NatsKeyValueUtil.getPurgeHeaders());
    }

    private PublishAck _publishWithNonWildcardKey(String key, byte[] data, Headers h) throws IOException, JetStreamApiException {
        Validator.validateNonWildcardKvKeyRequired(key);
        return this.js.publish(NatsMessage.builder().subject(this.pubSubKeySubject(key)).data(data).headers(h).build());
    }

    @Override
    public NatsKeyValueWatchSubscription watch(String key, KeyValueWatcher watcher, KeyValueWatchOption ... watchOptions) throws IOException, JetStreamApiException, InterruptedException {
        Validator.validateKvKeyWildcardAllowedRequired(key);
        Validator.validateNotNull(watcher, "Watcher is required");
        return new NatsKeyValueWatchSubscription(this, key, watcher, watchOptions);
    }

    @Override
    public NatsKeyValueWatchSubscription watchAll(KeyValueWatcher watcher, KeyValueWatchOption ... watchOptions) throws IOException, JetStreamApiException, InterruptedException {
        Validator.validateNotNull(watcher, "Watcher is required");
        return new NatsKeyValueWatchSubscription(this, ">", watcher, watchOptions);
    }

    @Override
    public List<String> keys() throws IOException, JetStreamApiException, InterruptedException {
        ArrayList<String> list = new ArrayList<String>();
        this.visitSubject(this.rawKeySubject(">"), DeliverPolicy.LastPerSubject, true, false, m -> {
            KeyValueOperation op = NatsKeyValueUtil.getOperation(m.getHeaders());
            if (op == KeyValueOperation.PUT) {
                list.add(new NatsKeyValueUtil.BucketAndKey((Message)m).key);
            }
        });
        return list;
    }

    @Override
    public List<KeyValueEntry> history(String key) throws IOException, JetStreamApiException, InterruptedException {
        Validator.validateNonWildcardKvKeyRequired(key);
        ArrayList<KeyValueEntry> list = new ArrayList<KeyValueEntry>();
        this.visitSubject(this.rawKeySubject(key), DeliverPolicy.All, false, true, m -> list.add(new KeyValueEntry(m)));
        return list;
    }

    @Override
    public void purgeDeletes() throws IOException, JetStreamApiException, InterruptedException {
        this.purgeDeletes(null);
    }

    @Override
    public void purgeDeletes(KeyValuePurgeOptions options) throws IOException, JetStreamApiException, InterruptedException {
        long dmThresh;
        long l = dmThresh = options == null ? KeyValuePurgeOptions.DEFAULT_THRESHOLD_MILLIS : options.getDeleteMarkersThresholdMillis();
        ZonedDateTime limit = dmThresh < 0L ? DateTimeUtils.fromNow(600000L) : (dmThresh == 0L ? DateTimeUtils.fromNow(KeyValuePurgeOptions.DEFAULT_THRESHOLD_MILLIS) : DateTimeUtils.fromNow(-dmThresh));
        ArrayList keep0List = new ArrayList();
        ArrayList keep1List = new ArrayList();
        this.visitSubject(this.streamSubject, DeliverPolicy.LastPerSubject, true, false, m -> {
            KeyValueEntry kve = new KeyValueEntry(m);
            if (kve.getOperation() != KeyValueOperation.PUT) {
                if (kve.getCreated().isAfter(limit)) {
                    keep1List.add(new NatsKeyValueUtil.BucketAndKey((Message)m).key);
                } else {
                    keep0List.add(new NatsKeyValueUtil.BucketAndKey((Message)m).key);
                }
            }
        });
        for (String key : keep0List) {
            this.jsm.purgeStream(this.streamName, PurgeOptions.subject(this.rawKeySubject(key)));
        }
        for (String key : keep1List) {
            PurgeOptions po = PurgeOptions.builder().subject(this.rawKeySubject(key)).keep(1L).build();
            this.jsm.purgeStream(this.streamName, po);
        }
    }

    @Override
    public KeyValueStatus getStatus() throws IOException, JetStreamApiException, InterruptedException {
        return new KeyValueStatus(this.jsm.getStreamInfo(this.streamName));
    }
}

