/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Options;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.util.Properties;

public class PublishOptions {
    public static final Duration DEFAULT_TIMEOUT = Options.DEFAULT_CONNECTION_TIMEOUT;
    public static final String UNSET_STREAM = null;
    public static final long UNSET_LAST_SEQUENCE = -1L;
    private final String stream;
    private final Duration streamTimeout;
    private final String expectedStream;
    private final String expectedLastId;
    private final long expectedLastSeq;
    private final long expectedLastSubSeq;
    private final String msgId;
    public static final String PROP_STREAM_NAME = "io.nats.client.publish.stream";
    public static final String PROP_PUBLISH_TIMEOUT = "io.nats.client.publish.timeout";

    private PublishOptions(String stream, Duration streamTimeout, String expectedStream, String expectedLastId, long expectedLastSeq, long expectedLastSubSeq, String msgId) {
        this.stream = stream;
        this.streamTimeout = streamTimeout;
        this.expectedStream = expectedStream;
        this.expectedLastId = expectedLastId;
        this.expectedLastSeq = expectedLastSeq;
        this.expectedLastSubSeq = expectedLastSubSeq;
        this.msgId = msgId;
    }

    public String getStream() {
        return this.stream;
    }

    public Duration getStreamTimeout() {
        return this.streamTimeout;
    }

    public String getExpectedStream() {
        return this.expectedStream;
    }

    public String getExpectedLastMsgId() {
        return this.expectedLastId;
    }

    public long getExpectedLastSequence() {
        return this.expectedLastSeq;
    }

    public long getExpectedLastSubjectSequence() {
        return this.expectedLastSubSeq;
    }

    public String getMessageId() {
        return this.msgId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String stream = UNSET_STREAM;
        Duration streamTimeout = DEFAULT_TIMEOUT;
        String expectedStream;
        String expectedLastId;
        long expectedLastSeq = -1L;
        long expectedLastSubSeq = -1L;
        String msgId;

        public Builder() {
        }

        public Builder(Properties properties) {
            String s = properties.getProperty(PublishOptions.PROP_PUBLISH_TIMEOUT);
            if (s != null) {
                this.streamTimeout = Duration.parse(s);
            }
            if ((s = properties.getProperty(PublishOptions.PROP_STREAM_NAME)) != null) {
                this.stream = s;
            }
        }

        public Builder stream(String stream) {
            this.stream = Validator.validateStreamName(stream, false);
            return this;
        }

        public Builder streamTimeout(Duration timeout) {
            this.streamTimeout = Validator.validateDurationNotRequiredGtOrEqZero(timeout, DEFAULT_TIMEOUT);
            return this;
        }

        public Builder expectedStream(String stream) {
            this.expectedStream = Validator.validateStreamName(stream, false);
            return this;
        }

        public Builder expectedLastMsgId(String lastMsgId) {
            this.expectedLastId = Validator.emptyAsNull(lastMsgId);
            return this;
        }

        public Builder expectedLastSequence(long sequence) {
            this.expectedLastSeq = Validator.validateGtEqMinus1(sequence, "Last Sequence");
            return this;
        }

        public Builder expectedLastSubjectSequence(long sequence) {
            this.expectedLastSubSeq = Validator.validateGtEqMinus1(sequence, "Last Subject Sequence");
            return this;
        }

        public Builder messageId(String msgId) {
            this.msgId = Validator.emptyAsNull(msgId);
            return this;
        }

        public Builder clearExpected() {
            this.expectedLastId = null;
            this.expectedLastSeq = -1L;
            this.expectedLastSubSeq = -1L;
            this.msgId = null;
            return this;
        }

        public PublishOptions build() {
            return new PublishOptions(this.stream, this.streamTimeout, this.expectedStream, this.expectedLastId, this.expectedLastSeq, this.expectedLastSubSeq, this.msgId);
        }
    }
}

