/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resume.kafka;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.resume.kafka.KafkaResumeStrategy;
import org.apache.camel.processor.resume.kafka.KafkaResumeStrategyConfiguration;
import org.apache.camel.processor.resume.kafka.RecordError;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.Deserializable;
import org.apache.camel.resume.Offset;
import org.apache.camel.resume.OffsetKey;
import org.apache.camel.resume.Resumable;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.util.IOHelper;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleNodeKafkaResumeStrategy<T extends Resumable>
implements KafkaResumeStrategy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleNodeKafkaResumeStrategy.class);
    private Consumer<byte[], byte[]> consumer;
    private Producer<byte[], byte[]> producer;
    private Duration pollDuration = Duration.ofSeconds(1L);
    private final Queue<RecordError> producerErrors = new ConcurrentLinkedQueue<RecordError>();
    private boolean subscribed;
    private ResumeAdapter adapter;
    private final KafkaResumeStrategyConfiguration resumeStrategyConfiguration;

    public SingleNodeKafkaResumeStrategy(KafkaResumeStrategyConfiguration resumeStrategyConfiguration) {
        this.resumeStrategyConfiguration = resumeStrategyConfiguration;
    }

    protected void produce(byte[] key, byte[] message) throws ExecutionException, InterruptedException {
        ProducerRecord record = new ProducerRecord(this.resumeStrategyConfiguration.getTopic(), (Object)key, (Object)message);
        this.producer.send(record, (recordMetadata, e) -> {
            if (e != null) {
                LOG.error("Failed to send message {}", (Object)e.getMessage(), (Object)e);
                this.producerErrors.add(new RecordError(recordMetadata, e));
            }
        });
    }

    protected void doAdd(OffsetKey<?> key, Offset<?> offsetValue) {
        if (this.adapter instanceof Cacheable) {
            Cacheable cacheable = (Cacheable)this.adapter;
            cacheable.add(key, offsetValue);
        }
    }

    public void updateLastOffset(T offset) throws Exception {
        this.createProducer();
        OffsetKey key = offset.getOffsetKey();
        Offset offsetValue = offset.getLastOffset();
        LOG.debug("Updating offset on Kafka with key {} to {}", key.getValue(), offsetValue.getValue());
        ByteBuffer keyBuffer = key.serialize();
        ByteBuffer valueBuffer = offsetValue.serialize();
        this.produce(keyBuffer.array(), valueBuffer.array());
        this.doAdd(key, offsetValue);
    }

    public void loadCache() throws Exception {
        this.createConsumer();
        this.subscribe();
        LOG.debug("Loading records from topic {}", (Object)this.resumeStrategyConfiguration.getTopic());
        if (!(this.adapter instanceof Deserializable)) {
            throw new RuntimeCamelException("Cannot load data for an adapter that is not deserializable");
        }
        this.poll();
        this.unsubscribe();
    }

    protected void poll() {
        ConsumerRecords<byte[], byte[]> records;
        Deserializable deserializable = (Deserializable)this.adapter;
        block0: while (!(records = this.consume()).isEmpty()) {
            for (ConsumerRecord record : records) {
                byte[] value = (byte[])record.value();
                LOG.trace("Read from Kafka: {}", (Object)value);
                if (deserializable.deserialize(ByteBuffer.wrap((byte[])record.key()), ByteBuffer.wrap((byte[])record.value()))) continue;
                continue block0;
            }
        }
    }

    protected void checkAndSubscribe(String topic) {
        if (!this.subscribed) {
            this.consumer.subscribe(Collections.singletonList(topic));
            this.subscribed = true;
        }
    }

    public void checkAndSubscribe(String topic, long remaining) {
        if (!this.subscribed) {
            this.consumer.subscribe(Collections.singletonList(topic), this.getConsumerRebalanceListener(remaining));
            this.subscribed = true;
        }
    }

    protected ConsumerRebalanceListener getConsumerRebalanceListener(final long remaining) {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> collection) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> assignments) {
                for (TopicPartition assignment : assignments) {
                    long endPosition = SingleNodeKafkaResumeStrategy.this.consumer.position(assignment);
                    long startPosition = endPosition - remaining;
                    if (startPosition >= 0L) {
                        SingleNodeKafkaResumeStrategy.this.consumer.seek(assignment, startPosition);
                        continue;
                    }
                    LOG.info("Ignoring the seek command because the initial offset is negative (the topic is likely empty)");
                }
            }
        };
    }

    protected void unsubscribe() {
        try {
            this.consumer.unsubscribe();
        }
        catch (IllegalStateException e) {
            LOG.warn("The consumer is likely already closed. Skipping unsubscribing from {}", (Object)this.resumeStrategyConfiguration.getTopic());
        }
        catch (Exception e) {
            LOG.error("Error unsubscribing from the Kafka topic {}: {}", new Object[]{this.resumeStrategyConfiguration.getTopic(), e.getMessage(), e});
        }
    }

    protected ConsumerRecords<byte[], byte[]> consume() {
        int retries = 10;
        return this.consume(retries);
    }

    protected ConsumerRecords<byte[], byte[]> consume(int retries) {
        while (retries > 0) {
            ConsumerRecords records = this.consumer.poll(this.pollDuration);
            if (!records.isEmpty()) {
                return records;
            }
            --retries;
        }
        return ConsumerRecords.empty();
    }

    protected ConsumerRecords<byte[], byte[]> consume(int retries, Consumer<byte[], byte[]> consumer) {
        while (retries > 0) {
            ConsumerRecords records = consumer.poll(this.pollDuration);
            if (!records.isEmpty()) {
                return records;
            }
            --retries;
        }
        return ConsumerRecords.empty();
    }

    public void subscribe() throws Exception {
        if (this.adapter instanceof Cacheable) {
            ResumeCache cache = ((Cacheable)this.adapter).getCache();
            if (cache.capacity() >= 1L) {
                this.checkAndSubscribe(this.resumeStrategyConfiguration.getTopic(), cache.capacity());
            } else {
                this.checkAndSubscribe(this.resumeStrategyConfiguration.getTopic());
            }
        } else {
            this.checkAndSubscribe(this.resumeStrategyConfiguration.getTopic());
        }
    }

    public ResumeAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(ResumeAdapter adapter) {
        this.adapter = adapter;
    }

    protected Collection<RecordError> getProducerErrors() {
        return Collections.unmodifiableCollection(this.producerErrors);
    }

    public void build() {
    }

    public void init() {
        LOG.debug("Initializing the Kafka resume strategy");
    }

    private void createProducer() {
        if (this.producer == null) {
            this.producer = new KafkaProducer(this.resumeStrategyConfiguration.getProducerProperties());
        }
    }

    private void createConsumer() {
        if (this.consumer == null) {
            this.consumer = new KafkaConsumer(this.resumeStrategyConfiguration.getConsumerProperties());
        }
    }

    public void stop() {
        LOG.info("Closing the Kafka producer");
        IOHelper.close(this.producer, (String)"Kafka producer", (Logger)LOG);
        LOG.info("Closing the Kafka consumer");
        IOHelper.close(this.producer, (String)"Kafka consumer", (Logger)LOG);
    }

    public void close() throws IOException {
        this.stop();
    }

    public void start() {
        LOG.info("Starting the kafka resume strategy");
    }

    public Duration getPollDuration() {
        return this.pollDuration;
    }

    public void setPollDuration(Duration pollDuration) {
        this.pollDuration = Objects.requireNonNull(pollDuration, "The poll duration cannot be null");
    }

    protected Consumer<byte[], byte[]> getConsumer() {
        return this.consumer;
    }

    protected Producer<byte[], byte[]> getProducer() {
        return this.producer;
    }

    public void resetProducerErrors() {
        this.producerErrors.clear();
    }

    protected KafkaResumeStrategyConfiguration getResumeStrategyConfiguration() {
        return this.resumeStrategyConfiguration;
    }
}

