/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.transforms;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.dataformat.avro.AvroFactory;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaGenerator;
import io.apicurio.registry.utils.converter.avro.AvroData;
import io.apicurio.registry.utils.converter.avro.AvroDataConfig;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourcePojoToSchemaAndStructTransform<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOG = LoggerFactory.getLogger(SourcePojoToSchemaAndStructTransform.class);
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new AvroFactory());
    private AvroData avroData;
    private ConcurrentMap<String, CacheEntry> avroSchemaWrapperCache;

    public R apply(final R r) {
        LOG.debug("Incoming record: {}", r);
        if (r.value() != null) {
            String recordClassCanonicalName = r.value().getClass().getName();
            CacheEntry cacheEntry = this.avroSchemaWrapperCache.computeIfAbsent(recordClassCanonicalName, new Function<String, CacheEntry>(){

                @Override
                public CacheEntry apply(String s) {
                    AvroSchemaGenerator gen = new AvroSchemaGenerator();
                    try {
                        MAPPER.acceptJsonFormatVisitor(r.value().getClass(), (JsonFormatVisitorWrapper)gen);
                        AvroSchema schemaWrapper = gen.getGeneratedSchema();
                        LOG.debug("Generated and cached avro schema: {}", (Object)schemaWrapper.getAvroSchema().toString(true));
                        return new CacheEntry(schemaWrapper, MAPPER.writer((FormatSchema)schemaWrapper));
                    }
                    catch (Exception e) {
                        throw new ConnectException("Error in generating POJO schema.", (Throwable)e);
                    }
                }
            });
            SchemaAndValue connectSchemaAndData = null;
            try {
                byte[] avroDataByte = cacheEntry.getObjectWriter().writeValueAsBytes(r.value());
                BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(avroDataByte, null);
                Schema avroSchema = cacheEntry.getAvroSchemaWrapper().getAvroSchema();
                GenericDatumReader datumReader = new GenericDatumReader(avroSchema);
                GenericRecord genericAvroData = (GenericRecord)datumReader.read(null, (Decoder)decoder);
                connectSchemaAndData = this.avroData.toConnectData(avroSchema, (Object)genericAvroData);
            }
            catch (IOException e) {
                throw new ConnectException("Error in generating POJO Struct.", (Throwable)e);
            }
            LOG.debug("Generate kafka connect schema: {}", (Object)connectSchemaAndData.schema());
            LOG.debug("Generate kafka connect value (as Struct): {}", connectSchemaAndData.value());
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), r.keySchema(), r.key(), connectSchemaAndData.schema(), connectSchemaAndData.value(), r.timestamp());
        }
        LOG.debug("Incoming record with a null value, nothing to be done.");
        return r;
    }

    public ConfigDef config() {
        return AvroDataConfig.baseConfigDef();
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        this.avroSchemaWrapperCache = new ConcurrentHashMap<String, CacheEntry>();
        this.avroData = new AvroData(new AvroDataConfig(configs));
    }

    public Map<String, CacheEntry> getCache() {
        return this.avroSchemaWrapperCache;
    }

    public class CacheEntry {
        private AvroSchema avroSchemaWrapper;
        private ObjectWriter objectWriter;

        public CacheEntry(AvroSchema avroSchemaWrapper, ObjectWriter objectWriter) {
            this.avroSchemaWrapper = avroSchemaWrapper;
            this.objectWriter = objectWriter;
        }

        public AvroSchema getAvroSchemaWrapper() {
            return this.avroSchemaWrapper;
        }

        public ObjectWriter getObjectWriter() {
            return this.objectWriter;
        }
    }
}

