/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.TimeUnit;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;

public class ThreadPoolProfileBuilder {
    private final ThreadPoolProfile profile;

    public ThreadPoolProfileBuilder(String id) {
        this.profile = new ThreadPoolProfile(id);
    }

    public ThreadPoolProfileBuilder(String id, ThreadPoolProfile origProfile) {
        this.profile = origProfile.clone();
        this.profile.setId(id);
    }

    public ThreadPoolProfileBuilder defaultProfile(Boolean defaultProfile) {
        if (defaultProfile != null) {
            this.profile.setDefaultProfile(defaultProfile);
        }
        return this;
    }

    public ThreadPoolProfileBuilder poolSize(Integer poolSize) {
        if (poolSize != null) {
            this.profile.setPoolSize(poolSize);
        }
        return this;
    }

    public ThreadPoolProfileBuilder maxPoolSize(Integer maxPoolSize) {
        if (maxPoolSize != null) {
            this.profile.setMaxPoolSize(maxPoolSize);
        }
        return this;
    }

    public ThreadPoolProfileBuilder keepAliveTime(Long keepAliveTime, TimeUnit timeUnit) {
        if (keepAliveTime != null) {
            this.profile.setKeepAliveTime(keepAliveTime);
        }
        if (timeUnit != null) {
            this.profile.setTimeUnit(timeUnit);
        }
        return this;
    }

    public ThreadPoolProfileBuilder keepAliveTime(Long keepAliveTime) {
        if (keepAliveTime != null) {
            this.profile.setKeepAliveTime(keepAliveTime);
        }
        return this;
    }

    public ThreadPoolProfileBuilder maxQueueSize(Integer maxQueueSize) {
        if (maxQueueSize != null) {
            this.profile.setMaxQueueSize(maxQueueSize);
        }
        return this;
    }

    public ThreadPoolProfileBuilder allowCoreThreadTimeOut(Boolean allowCoreThreadTimeOut) {
        if (allowCoreThreadTimeOut != null) {
            this.profile.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
        }
        return this;
    }

    public ThreadPoolProfileBuilder rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        if (rejectedPolicy != null) {
            this.profile.setRejectedPolicy(rejectedPolicy);
        }
        return this;
    }

    public ThreadPoolProfile build() {
        return this.profile;
    }
}

