/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.URISupport;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaProducer.class);
    private org.apache.kafka.clients.producer.KafkaProducer kafkaProducer;
    private final KafkaEndpoint endpoint;
    private ExecutorService workerPool;
    private boolean shutdownWorkerPool;
    private volatile boolean closeKafkaProducer;

    public KafkaProducer(KafkaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createProducerProperties();
        this.endpoint.updateClassProperties(props);
        String brokers = this.endpoint.getComponent().getKafkaClientFactory().getBrokers(this.endpoint.getConfiguration());
        if (brokers != null) {
            props.put("bootstrap.servers", brokers);
        }
        return props;
    }

    public org.apache.kafka.clients.producer.KafkaProducer getKafkaProducer() {
        return this.kafkaProducer;
    }

    public void setKafkaProducer(org.apache.kafka.clients.producer.KafkaProducer kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }

    public ExecutorService getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(ExecutorService workerPool) {
        this.workerPool = workerPool;
    }

    protected void doStart() throws Exception {
        Properties props = this.getProps();
        if (this.kafkaProducer == null) {
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(org.apache.kafka.clients.producer.KafkaProducer.class.getClassLoader());
                LOG.trace("Creating KafkaProducer");
                this.kafkaProducer = this.endpoint.getComponent().getKafkaClientFactory().getProducer(props);
                this.closeKafkaProducer = true;
            }
            finally {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
            LOG.debug("Created KafkaProducer: {}", (Object)this.kafkaProducer);
        }
        if (!this.endpoint.getConfiguration().isSynchronous() && this.workerPool == null) {
            this.workerPool = this.endpoint.createProducerExecutor();
            this.shutdownWorkerPool = true;
        }
    }

    protected void doStop() throws Exception {
        if (this.kafkaProducer != null && this.closeKafkaProducer) {
            LOG.debug("Closing KafkaProducer: {}", (Object)this.kafkaProducer);
            this.kafkaProducer.close();
            this.kafkaProducer = null;
        }
        if (this.shutdownWorkerPool && this.workerPool != null) {
            int timeout = this.endpoint.getConfiguration().getShutdownTimeout();
            LOG.debug("Shutting down Kafka producer worker threads with timeout {} millis", (Object)timeout);
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdownGraceful(this.workerPool, (long)timeout);
            this.workerPool = null;
        }
    }

    protected Iterator<KeyValueHolder<Object, ProducerRecord>> createRecorder(final Exchange exchange) throws Exception {
        String topic = this.endpoint.getConfiguration().getTopic();
        Object overrideTopic = exchange.getIn().removeHeader("kafka.OVERRIDE_TOPIC");
        if (overrideTopic != null) {
            LOG.debug("Using override topic: {}", overrideTopic);
            topic = overrideTopic.toString();
        }
        if (topic == null) {
            topic = URISupport.extractRemainderPath((URI)new URI(this.endpoint.getEndpointUri()), (boolean)true);
        }
        final List<Header> propagatedHeaders = this.getPropagatedHeaders(exchange, this.endpoint.getConfiguration());
        Object msg = exchange.getIn().getBody();
        Iterator iterator = null;
        if (msg instanceof Iterable) {
            iterator = ((Iterable)msg).iterator();
        } else if (msg instanceof Iterator) {
            iterator = (Iterator)msg;
        }
        if (iterator != null) {
            final Iterator msgList = iterator;
            final String msgTopic = topic;
            return new Iterator<KeyValueHolder<Object, ProducerRecord>>(){

                @Override
                public boolean hasNext() {
                    return msgList.hasNext();
                }

                @Override
                public KeyValueHolder<Object, ProducerRecord> next() {
                    Object next = msgList.next();
                    String innerTopic = msgTopic;
                    Object innerKey = null;
                    Integer innerPartitionKey = null;
                    boolean hasPartitionKey = false;
                    boolean hasMessageKey = false;
                    Object value = next;
                    Exchange ex = null;
                    Object body = next;
                    if (next instanceof Exchange || next instanceof Message) {
                        Exchange innerExchange = null;
                        Message innerMmessage = null;
                        if (next instanceof Exchange) {
                            innerExchange = (Exchange)next;
                            innerMmessage = innerExchange.getIn();
                        } else {
                            innerMmessage = (Message)next;
                        }
                        if (innerMmessage.getHeader("kafka.OVERRIDE_TOPIC") != null) {
                            innerTopic = (String)innerMmessage.removeHeader("kafka.OVERRIDE_TOPIC");
                        }
                        if (innerMmessage.getHeader("kafka.PARTITION_KEY") != null) {
                            innerPartitionKey = KafkaProducer.this.endpoint.getConfiguration().getPartitionKey() != null ? KafkaProducer.this.endpoint.getConfiguration().getPartitionKey() : (Integer)innerMmessage.getHeader("kafka.PARTITION_KEY", Integer.class);
                            boolean bl = hasPartitionKey = innerPartitionKey != null;
                        }
                        if (innerMmessage.getHeader("kafka.KEY") != null) {
                            innerKey = KafkaProducer.this.endpoint.getConfiguration().getKey() != null ? KafkaProducer.this.endpoint.getConfiguration().getKey() : innerMmessage.getHeader("kafka.KEY");
                            Object messageKey = innerKey != null ? KafkaProducer.this.tryConvertToSerializedType(innerExchange, innerKey, KafkaProducer.this.endpoint.getConfiguration().getKeySerializer()) : null;
                            hasMessageKey = messageKey != null;
                        }
                        ex = innerExchange == null ? exchange : innerExchange;
                        value = KafkaProducer.this.tryConvertToSerializedType(ex, innerMmessage.getBody(), KafkaProducer.this.endpoint.getConfiguration().getValueSerializer());
                    }
                    if (hasPartitionKey && hasMessageKey) {
                        return new KeyValueHolder(body, (Object)new ProducerRecord(innerTopic, innerPartitionKey, null, innerKey, value, (Iterable)propagatedHeaders));
                    }
                    if (hasMessageKey) {
                        return new KeyValueHolder(body, (Object)new ProducerRecord(innerTopic, null, null, innerKey, value, (Iterable)propagatedHeaders));
                    }
                    return new KeyValueHolder(body, (Object)new ProducerRecord(innerTopic, null, null, null, value, (Iterable)propagatedHeaders));
                }

                @Override
                public void remove() {
                    msgList.remove();
                }
            };
        }
        Integer partitionKey = this.endpoint.getConfiguration().getPartitionKey() != null ? this.endpoint.getConfiguration().getPartitionKey() : (Integer)exchange.getIn().getHeader("kafka.PARTITION_KEY", Integer.class);
        boolean hasPartitionKey = partitionKey != null;
        Object key = this.endpoint.getConfiguration().getKey() != null ? this.endpoint.getConfiguration().getKey() : exchange.getIn().getHeader("kafka.KEY");
        Object messageKey = key != null ? this.tryConvertToSerializedType(exchange, key, this.endpoint.getConfiguration().getKeySerializer()) : null;
        boolean hasMessageKey = messageKey != null;
        Object value = this.tryConvertToSerializedType(exchange, msg, this.endpoint.getConfiguration().getValueSerializer());
        ProducerRecord record = hasPartitionKey && hasMessageKey ? new ProducerRecord(topic, partitionKey, null, key, value, propagatedHeaders) : (hasMessageKey ? new ProducerRecord(topic, null, null, key, value, propagatedHeaders) : new ProducerRecord(topic, null, null, null, value, propagatedHeaders));
        return Collections.singletonList(new KeyValueHolder((Object)exchange, (Object)record)).iterator();
    }

    private List<Header> getPropagatedHeaders(Exchange exchange, KafkaConfiguration getConfiguration) {
        HeaderFilterStrategy headerFilterStrategy = getConfiguration.getHeaderFilterStrategy();
        KafkaHeaderSerializer headerSerializer = getConfiguration.getHeaderSerializer();
        return exchange.getIn().getHeaders().entrySet().stream().filter(entry -> this.shouldBeFiltered((Map.Entry<String, Object>)entry, exchange, headerFilterStrategy)).map(entry -> this.getRecordHeader((Map.Entry<String, Object>)entry, headerSerializer)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean shouldBeFiltered(Map.Entry<String, Object> entry, Exchange exchange, HeaderFilterStrategy headerFilterStrategy) {
        return !headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange);
    }

    private RecordHeader getRecordHeader(Map.Entry<String, Object> entry, KafkaHeaderSerializer headerSerializer) {
        byte[] headerValue = headerSerializer.serialize(entry.getKey(), entry.getValue());
        if (headerValue == null) {
            return null;
        }
        return new RecordHeader(entry.getKey(), headerValue);
    }

    public void process(Exchange exchange) throws Exception {
        Iterator<KeyValueHolder<Object, ProducerRecord>> c = this.createRecorder(exchange);
        LinkedList<KeyValueHolder> futures = new LinkedList<KeyValueHolder>();
        ArrayList recordMetadatas = new ArrayList();
        if (this.endpoint.getConfiguration().isRecordMetadata()) {
            if (exchange.hasOut()) {
                exchange.getOut().setHeader("org.apache.kafka.clients.producer.RecordMetadata", recordMetadatas);
            } else {
                exchange.getIn().setHeader("org.apache.kafka.clients.producer.RecordMetadata", recordMetadatas);
            }
        }
        while (c.hasNext()) {
            KeyValueHolder<Object, ProducerRecord> exrec = c.next();
            ProducerRecord rec = (ProducerRecord)exrec.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending message to topic: {}, partition: {}, key: {}", new Object[]{rec.topic(), rec.partition(), rec.key()});
            }
            futures.add(new KeyValueHolder(exrec.getKey(), (Object)this.kafkaProducer.send(rec)));
        }
        for (KeyValueHolder f : futures) {
            List metadata = Collections.singletonList(((Future)f.getValue()).get());
            recordMetadatas.addAll(metadata);
            Exchange innerExchange = null;
            if (f.getKey() instanceof Exchange && (innerExchange = (Exchange)f.getKey()) != null && this.endpoint.getConfiguration().isRecordMetadata()) {
                if (innerExchange.hasOut()) {
                    innerExchange.getOut().setHeader("org.apache.kafka.clients.producer.RecordMetadata", metadata);
                } else {
                    innerExchange.getIn().setHeader("org.apache.kafka.clients.producer.RecordMetadata", metadata);
                }
            }
            Message innerMessage = null;
            if (!(f.getKey() instanceof Message) || (innerMessage = (Message)f.getKey()) == null || !this.endpoint.getConfiguration().isRecordMetadata()) continue;
            innerMessage.setHeader("org.apache.kafka.clients.producer.RecordMetadata", metadata);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Iterator<KeyValueHolder<Object, ProducerRecord>> c = this.createRecorder(exchange);
            KafkaProducerCallBack cb = new KafkaProducerCallBack(exchange, callback);
            while (c.hasNext()) {
                cb.increment();
                KeyValueHolder<Object, ProducerRecord> exrec = c.next();
                ProducerRecord rec = (ProducerRecord)exrec.getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending message to topic: {}, partition: {}, key: {}", new Object[]{rec.topic(), rec.partition(), rec.key()});
                }
                ArrayList<KafkaProducerCallBack> delegates = new ArrayList<KafkaProducerCallBack>(Arrays.asList(cb));
                if (exrec.getKey() != null) {
                    delegates.add(new KafkaProducerCallBack(exrec.getKey()));
                }
                this.kafkaProducer.send(rec, (Callback)new DelegatingCallback(delegates.toArray(new Callback[0])));
            }
            return cb.allSent();
        }
        catch (Exception ex) {
            exchange.setException((Throwable)ex);
            callback.done(true);
            return true;
        }
    }

    protected Object tryConvertToSerializedType(Exchange exchange, Object object, String valueSerializer) {
        byte[] array;
        Object answer = null;
        if (exchange == null) {
            return object;
        }
        if ("org.apache.kafka.common.serialization.StringSerializer".equals(valueSerializer)) {
            answer = exchange.getContext().getTypeConverter().tryConvertTo(String.class, exchange, object);
        } else if ("org.apache.kafka.common.serialization.ByteArraySerializer".equals(valueSerializer)) {
            answer = exchange.getContext().getTypeConverter().tryConvertTo(byte[].class, exchange, object);
        } else if ("org.apache.kafka.common.serialization.ByteBufferSerializer".equals(valueSerializer)) {
            answer = exchange.getContext().getTypeConverter().tryConvertTo(ByteBuffer.class, exchange, object);
        } else if ("org.apache.kafka.common.serialization.BytesSerializer".equals(valueSerializer) && (array = (byte[])exchange.getContext().getTypeConverter().tryConvertTo(byte[].class, exchange, object)) != null) {
            answer = new Bytes(array);
        }
        return answer != null ? answer : object;
    }

    private final class KafkaProducerCallBack
    implements Callback {
        private final Object body;
        private final AsyncCallback callback;
        private final AtomicInteger count = new AtomicInteger(1);
        private final List<RecordMetadata> recordMetadatas = new ArrayList<RecordMetadata>();

        KafkaProducerCallBack(Object body, AsyncCallback callback) {
            this.body = body;
            this.callback = callback;
            if (KafkaProducer.this.endpoint.getConfiguration().isRecordMetadata()) {
                if (body instanceof Exchange) {
                    Exchange ex = (Exchange)body;
                    if (ex.hasOut()) {
                        ex.getOut().setHeader("org.apache.kafka.clients.producer.RecordMetadata", this.recordMetadatas);
                    } else {
                        ex.getIn().setHeader("org.apache.kafka.clients.producer.RecordMetadata", this.recordMetadatas);
                    }
                }
                if (body instanceof Message) {
                    Message msg = (Message)body;
                    msg.setHeader("org.apache.kafka.clients.producer.RecordMetadata", this.recordMetadatas);
                }
            }
        }

        public KafkaProducerCallBack(Exchange exchange) {
            this(exchange, null);
        }

        public KafkaProducerCallBack(Message message) {
            this(message, null);
        }

        public KafkaProducerCallBack(Object body) {
            this(body, null);
        }

        void increment() {
            this.count.incrementAndGet();
        }

        boolean allSent() {
            if (this.count.decrementAndGet() == 0) {
                LOG.trace("All messages sent, continue routing.");
                if (this.callback != null) {
                    this.callback.done(true);
                }
                return true;
            }
            return false;
        }

        public void onCompletion(RecordMetadata recordMetadata, Exception e) {
            if (e != null) {
                if (this.body instanceof Exchange) {
                    ((Exchange)this.body).setException((Throwable)e);
                }
                if (this.body instanceof Message && ((Message)this.body).getExchange() != null) {
                    ((Message)this.body).getExchange().setException((Throwable)e);
                }
            }
            this.recordMetadatas.add(recordMetadata);
            if (this.count.decrementAndGet() == 0) {
                KafkaProducer.this.workerPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        LOG.trace("All messages sent, continue routing.");
                        if (KafkaProducerCallBack.this.callback != null) {
                            KafkaProducerCallBack.this.callback.done(false);
                        }
                    }
                });
            }
        }
    }

    private final class DelegatingCallback
    implements Callback {
        private final List<Callback> callbacks;

        public DelegatingCallback(Callback ... callbacks) {
            this.callbacks = Arrays.asList(callbacks);
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            this.callbacks.forEach(c -> c.onCompletion(metadata, exception));
        }
    }
}

