/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class NatsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":topic";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "nats".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "topic", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(29);
        props.add("replySubject");
        props.add("maxMessages");
        props.add("sslContextParameters");
        props.add("secure");
        props.add("flushTimeout");
        props.add("reconnect");
        props.add("servers");
        props.add("bridgeErrorHandler");
        props.add("pedantic");
        props.add("connection");
        props.add("traceConnection");
        props.add("connectionTimeout");
        props.add("reconnectTimeWait");
        props.add("requestTimeout");
        props.add("pingInterval");
        props.add("noRandomizeServers");
        props.add("poolSize");
        props.add("exchangePattern");
        props.add("flushConnection");
        props.add("verbose");
        props.add("lazyStartProducer");
        props.add("requestCleanupInterval");
        props.add("queueName");
        props.add("noEcho");
        props.add("maxReconnectAttempts");
        props.add("topic");
        props.add("replyToDisabled");
        props.add("maxPingsOut");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

