/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.CamelConverter;
import org.apache.camel.converter.CollectionConverter;
import org.apache.camel.converter.DateTimeConverter;
import org.apache.camel.converter.DurationConverter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.NIOConverter;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.converter.SQLConverter;
import org.apache.camel.converter.UriTypeConverter;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;

public final class CamelBaseBulkConverterLoader
implements TypeConverterLoader,
BulkTypeConverters {
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public int size() {
        return 104;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addBulkTypeConverters((BulkTypeConverters)this);
    }

    public <T> T convertTo(Class<?> from, Class<T> to, Exchange exchange, Object value) throws TypeConversionException {
        try {
            Object obj = this.doConvertTo(from, to, exchange, value);
            if (obj == Void.class) {
                return null;
            }
            return (T)obj;
        }
        catch (TypeConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeConversionException(value, to, (Throwable)e);
        }
    }

    private Object doConvertTo(Class<?> from, Class<?> to, Exchange exchange, Object value) throws Exception {
        if (to == byte[].class) {
            if (value instanceof ByteBuffer) {
                return NIOConverter.toByteArray((ByteBuffer)value);
            }
            if (value instanceof File) {
                return IOConverter.toByteArray((File)value);
            }
            if (value instanceof BufferedReader) {
                return IOConverter.toByteArray((BufferedReader)value, exchange);
            }
            if (value instanceof Reader) {
                return IOConverter.toByteArray((Reader)value, exchange);
            }
            if (value instanceof String) {
                return IOConverter.toByteArray((String)value, exchange);
            }
            if (value instanceof InputStream) {
                return IOConverter.toBytes((InputStream)value);
            }
            if (value instanceof ByteArrayOutputStream) {
                return IOConverter.toByteArray((ByteArrayOutputStream)value);
            }
        } else if (to == char[].class) {
            if (value instanceof String) {
                return ObjectConverter.toCharArray((String)value);
            }
        } else if (to == Object[].class) {
            if (value instanceof Collection) {
                return CollectionConverter.toArray((Collection)value);
            }
        } else if (to == Boolean.TYPE) {
            if (value instanceof Object) {
                return ObjectConverter.toBool(value);
            }
        } else if (to == Character.TYPE) {
            if (value instanceof String) {
                return Character.valueOf(ObjectConverter.toChar((String)value));
            }
        } else if (to == BufferedReader.class) {
            if (value instanceof File) {
                return IOConverter.toReader((File)value, exchange);
            }
        } else if (to == BufferedWriter.class) {
            if (value instanceof File) {
                return IOConverter.toWriter((File)value, exchange);
            }
        } else if (to == File.class) {
            if (value instanceof String) {
                return IOConverter.toFile((String)value);
            }
        } else if (to == InputStream.class) {
            if (value instanceof Stream) {
                return IOConverter.toInputStream((Stream)value, exchange);
            }
            if (value instanceof URL) {
                return IOConverter.toInputStream((URL)value);
            }
            if (value instanceof File) {
                return IOConverter.toInputStream((File)value);
            }
            if (value instanceof String) {
                return IOConverter.toInputStream((String)value, exchange);
            }
            if (value instanceof ByteBuffer) {
                return NIOConverter.toInputStream((ByteBuffer)value);
            }
            if (value instanceof StringBuffer) {
                return IOConverter.toInputStream((StringBuffer)value, exchange);
            }
            if (value instanceof StringBuilder) {
                return IOConverter.toInputStream((StringBuilder)value, exchange);
            }
            if (value instanceof BufferedReader) {
                return IOConverter.toInputStream((BufferedReader)value, exchange);
            }
            if (value instanceof byte[]) {
                return IOConverter.toInputStream((byte[])value);
            }
            if (value instanceof ByteArrayOutputStream) {
                return IOConverter.toInputStream((ByteArrayOutputStream)value);
            }
        } else if (to == ObjectInput.class) {
            if (value instanceof InputStream) {
                return IOConverter.toObjectInput((InputStream)value, exchange);
            }
        } else if (to == ObjectOutput.class) {
            if (value instanceof OutputStream) {
                return IOConverter.toObjectOutput((OutputStream)value);
            }
        } else if (to == OutputStream.class) {
            if (value instanceof File) {
                return IOConverter.toOutputStream((File)value);
            }
        } else if (to == Reader.class) {
            if (value instanceof InputStream) {
                return IOConverter.toReader((InputStream)value, exchange);
            }
            if (value instanceof byte[]) {
                return IOConverter.toReader((byte[])value, exchange);
            }
            if (value instanceof String) {
                return IOConverter.toReader((String)value);
            }
        } else if (to == Writer.class) {
            if (value instanceof OutputStream) {
                return IOConverter.toWriter((OutputStream)value, exchange);
            }
        } else if (to == Boolean.class || to == Boolean.TYPE) {
            if (value instanceof Object) {
                return ObjectConverter.toBoolean(value);
            }
            if (value instanceof String) {
                return ObjectConverter.toBoolean((String)value);
            }
        } else if (to == Byte.class) {
            if (value instanceof Number) {
                Byte obj = ObjectConverter.toByte((Number)value);
                if (obj == null) {
                    return Void.class;
                }
                return obj;
            }
            if (value instanceof String) {
                return ObjectConverter.toByte((String)value);
            }
        } else if (to == Character.class || to == Character.TYPE) {
            if (value instanceof String) {
                return ObjectConverter.toCharacter((String)value);
            }
        } else if (to == Class.class) {
            if (value instanceof String) {
                return ObjectConverter.toClass((String)value, exchange);
            }
        } else if (to == Double.class || to == Double.TYPE) {
            if (value instanceof Number) {
                return ObjectConverter.toDouble((Number)value);
            }
            if (value instanceof String) {
                return ObjectConverter.toDouble((String)value);
            }
        } else if (to == Float.class || to == Float.TYPE) {
            if (value instanceof Number) {
                return ObjectConverter.toFloat((Number)value);
            }
            if (value instanceof String) {
                return ObjectConverter.toFloat((String)value);
            }
        } else if (to == Integer.class || to == Integer.TYPE) {
            if (value instanceof Number) {
                Integer obj = ObjectConverter.toInteger((Number)value);
                if (obj == null) {
                    return Void.class;
                }
                return obj;
            }
            if (value instanceof String) {
                return ObjectConverter.toInteger((String)value);
            }
        } else if (to == Iterable.class) {
            if (value instanceof Object) {
                return ObjectConverter.iterable(value);
            }
        } else if (to == Long.class || to == Long.TYPE) {
            if (value instanceof Duration) {
                return DurationConverter.toMilliSeconds((Duration)value);
            }
            if (value instanceof Timestamp) {
                return SQLConverter.toLong((Timestamp)value);
            }
            if (value instanceof Date) {
                return DateTimeConverter.toLong((Date)value);
            }
            if (value instanceof Number) {
                Long obj = ObjectConverter.toLong((Number)value);
                if (obj == null) {
                    return Void.class;
                }
                return obj;
            }
            if (value instanceof String) {
                return ObjectConverter.toLong((String)value);
            }
        } else if (to == Number.class) {
            if (value instanceof String) {
                return ObjectConverter.toNumber((String)value);
            }
        } else if (to == Short.class) {
            if (value instanceof Number) {
                Short obj = ObjectConverter.toShort((Number)value);
                if (obj == null) {
                    return Void.class;
                }
                return obj;
            }
            if (value instanceof String) {
                return ObjectConverter.toShort((String)value);
            }
        } else if (to == String.class) {
            if (value instanceof URI) {
                return UriTypeConverter.toString((URI)value);
            }
            if (value instanceof ByteBuffer) {
                return NIOConverter.toString((ByteBuffer)value, exchange);
            }
            if (value instanceof Duration) {
                return DurationConverter.toString((Duration)value);
            }
            if (value instanceof char[]) {
                return ObjectConverter.fromCharArray((char[])value);
            }
            if (value instanceof byte[]) {
                return IOConverter.toString((byte[])value, exchange);
            }
            if (value instanceof File) {
                return IOConverter.toString((File)value, exchange);
            }
            if (value instanceof URL) {
                return IOConverter.toString((URL)value, exchange);
            }
            if (value instanceof BufferedReader) {
                return IOConverter.toString((BufferedReader)value);
            }
            if (value instanceof Reader) {
                return IOConverter.toString((Reader)value);
            }
            if (value instanceof Integer) {
                return ObjectConverter.toString((Integer)value);
            }
            if (value instanceof Long) {
                return ObjectConverter.toString((Long)value);
            }
            if (value instanceof InputStream) {
                return IOConverter.toString((InputStream)value, exchange);
            }
            if (value instanceof Boolean) {
                return ObjectConverter.toString((Boolean)value);
            }
            if (value instanceof StringBuffer) {
                return ObjectConverter.toString((StringBuffer)value);
            }
            if (value instanceof StringBuilder) {
                return ObjectConverter.toString((StringBuilder)value);
            }
            if (value instanceof ByteArrayOutputStream) {
                return IOConverter.toString((ByteArrayOutputStream)value, exchange);
            }
        } else if (to == BigInteger.class) {
            if (value instanceof Object) {
                BigInteger obj = ObjectConverter.toBigInteger(value);
                if (obj == null) {
                    return Void.class;
                }
                return obj;
            }
        } else if (to == URI.class) {
            if (value instanceof CharSequence) {
                return UriTypeConverter.toUri((CharSequence)value);
            }
        } else if (to == ByteBuffer.class) {
            if (value instanceof byte[]) {
                return NIOConverter.toByteBuffer((byte[])value);
            }
            if (value instanceof ByteArrayOutputStream) {
                return NIOConverter.toByteBuffer((ByteArrayOutputStream)value);
            }
            if (value instanceof File) {
                return NIOConverter.toByteBuffer((File)value);
            }
            if (value instanceof String) {
                return NIOConverter.toByteBuffer((String)value, exchange);
            }
            if (value instanceof Short) {
                return NIOConverter.toByteBuffer((Short)value);
            }
            if (value instanceof Integer) {
                return NIOConverter.toByteBuffer((Integer)value);
            }
            if (value instanceof Long) {
                return NIOConverter.toByteBuffer((Long)value);
            }
            if (value instanceof Float) {
                return NIOConverter.toByteBuffer((Float)value);
            }
            if (value instanceof Double) {
                return NIOConverter.toByteBuffer((Double)value);
            }
            if (value instanceof InputStream) {
                return IOConverter.covertToByteBuffer((InputStream)value);
            }
        } else if (to == Timestamp.class) {
            if (value instanceof Long) {
                return SQLConverter.toTimestamp((Long)value);
            }
        } else if (to == Duration.class) {
            if (value instanceof Long) {
                return DurationConverter.toDuration((Long)value);
            }
            if (value instanceof String) {
                return DurationConverter.toDuration((String)value);
            }
        } else if (to == ArrayList.class) {
            if (value instanceof Iterator) {
                return CollectionConverter.toArrayList((Iterator)value);
            }
            if (value instanceof Iterable) {
                return CollectionConverter.toArrayList((Iterable)value);
            }
        } else if (to == Collection.class) {
            if (value instanceof Map) {
                return CollectionConverter.toCollection((Map)value);
            }
        } else if (to == Date.class) {
            if (value instanceof Long) {
                return DateTimeConverter.toDate((Long)value);
            }
        } else if (to == HashMap.class) {
            if (value instanceof Map) {
                return CollectionConverter.toHashMap((Map)value);
            }
        } else if (to == Hashtable.class) {
            if (value instanceof Map) {
                return CollectionConverter.toHashtable((Map)value);
            }
        } else if (to == Iterator.class) {
            if (value instanceof Object) {
                return ObjectConverter.iterator(value);
            }
        } else if (to == List.class) {
            if (value instanceof Object[]) {
                return CollectionConverter.toList((Object[])value);
            }
            if (value instanceof Collection) {
                return CollectionConverter.toList((Collection)value);
            }
            if (value instanceof Iterable) {
                return CollectionConverter.toList((Iterable)value);
            }
            if (value instanceof Iterator) {
                return CollectionConverter.toList((Iterator)value);
            }
        } else if (to == Properties.class) {
            if (value instanceof Map) {
                return CollectionConverter.toProperties((Map)value);
            }
            if (value instanceof File) {
                return IOConverter.toProperties((File)value);
            }
            if (value instanceof InputStream) {
                return IOConverter.toProperties((InputStream)value);
            }
            if (value instanceof Reader) {
                return IOConverter.toProperties((Reader)value);
            }
        } else if (to == Set.class) {
            if (value instanceof Object[]) {
                return CollectionConverter.toSet((Object[])value);
            }
            if (value instanceof Collection) {
                return CollectionConverter.toSet((Collection)value);
            }
            if (value instanceof Map) {
                return CollectionConverter.toSet((Map)value);
            }
        } else if (to == TimeZone.class) {
            if (value instanceof String) {
                return DateTimeConverter.toTimeZone((String)value);
            }
        } else if (to == Processor.class) {
            if (value instanceof Expression) {
                return CamelConverter.toProcessor((Expression)value);
            }
            if (value instanceof Predicate) {
                return CamelConverter.toProcessor((Predicate)value);
            }
        }
        return null;
    }

    public TypeConverter lookup(Class<?> to, Class<?> from) {
        if (to == byte[].class) {
            if (from == ByteBuffer.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == BufferedReader.class) {
                return this;
            }
            if (from == Reader.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == ByteArrayOutputStream.class) {
                return this;
            }
        } else if (to == char[].class) {
            if (from == String.class) {
                return this;
            }
        } else if (to == Object[].class) {
            if (from == Collection.class) {
                return this;
            }
        } else if (to == Boolean.TYPE) {
            if (from == Object.class) {
                return this;
            }
        } else if (to == Character.TYPE) {
            if (from == String.class) {
                return this;
            }
        } else if (to == BufferedReader.class) {
            if (from == File.class) {
                return this;
            }
        } else if (to == BufferedWriter.class) {
            if (from == File.class) {
                return this;
            }
        } else if (to == File.class) {
            if (from == String.class) {
                return this;
            }
        } else if (to == InputStream.class) {
            if (from == Stream.class) {
                return this;
            }
            if (from == URL.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
            if (from == ByteBuffer.class) {
                return this;
            }
            if (from == StringBuffer.class) {
                return this;
            }
            if (from == StringBuilder.class) {
                return this;
            }
            if (from == BufferedReader.class) {
                return this;
            }
            if (from == byte[].class) {
                return this;
            }
            if (from == ByteArrayOutputStream.class) {
                return this;
            }
        } else if (to == ObjectInput.class) {
            if (from == InputStream.class) {
                return this;
            }
        } else if (to == ObjectOutput.class) {
            if (from == OutputStream.class) {
                return this;
            }
        } else if (to == OutputStream.class) {
            if (from == File.class) {
                return this;
            }
        } else if (to == Reader.class) {
            if (from == InputStream.class) {
                return this;
            }
            if (from == byte[].class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == Writer.class) {
            if (from == OutputStream.class) {
                return this;
            }
        } else if (to == Boolean.class || to == Boolean.TYPE) {
            if (from == Object.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == Byte.class) {
            if (from == Number.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == Character.class || to == Character.TYPE) {
            if (from == String.class) {
                return this;
            }
        } else if (to == Class.class) {
            if (from == String.class) {
                return this;
            }
        } else if (to == Double.class || to == Double.TYPE) {
            if (from == Number.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == Float.class || to == Float.TYPE) {
            if (from == Number.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == Integer.class || to == Integer.TYPE) {
            if (from == Number.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == Iterable.class) {
            if (from == Object.class) {
                return this;
            }
        } else if (to == Long.class || to == Long.TYPE) {
            if (from == Duration.class) {
                return this;
            }
            if (from == Timestamp.class) {
                return this;
            }
            if (from == Date.class) {
                return this;
            }
            if (from == Number.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == Number.class) {
            if (from == String.class) {
                return this;
            }
        } else if (to == Short.class) {
            if (from == Number.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == String.class) {
            if (from == URI.class) {
                return this;
            }
            if (from == ByteBuffer.class) {
                return this;
            }
            if (from == Duration.class) {
                return this;
            }
            if (from == char[].class) {
                return this;
            }
            if (from == byte[].class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == URL.class) {
                return this;
            }
            if (from == BufferedReader.class) {
                return this;
            }
            if (from == Reader.class) {
                return this;
            }
            if (from == Integer.class) {
                return this;
            }
            if (from == Long.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == Boolean.class) {
                return this;
            }
            if (from == StringBuffer.class) {
                return this;
            }
            if (from == StringBuilder.class) {
                return this;
            }
            if (from == ByteArrayOutputStream.class) {
                return this;
            }
        } else if (to == BigInteger.class) {
            if (from == Object.class) {
                return this;
            }
        } else if (to == URI.class) {
            if (from == CharSequence.class) {
                return this;
            }
        } else if (to == ByteBuffer.class) {
            if (from == byte[].class) {
                return this;
            }
            if (from == ByteArrayOutputStream.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
            if (from == Short.class) {
                return this;
            }
            if (from == Integer.class) {
                return this;
            }
            if (from == Long.class) {
                return this;
            }
            if (from == Float.class) {
                return this;
            }
            if (from == Double.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
        } else if (to == Timestamp.class) {
            if (from == Long.class) {
                return this;
            }
        } else if (to == Duration.class) {
            if (from == Long.class) {
                return this;
            }
            if (from == String.class) {
                return this;
            }
        } else if (to == ArrayList.class) {
            if (from == Iterator.class) {
                return this;
            }
            if (from == Iterable.class) {
                return this;
            }
        } else if (to == Collection.class) {
            if (from == Map.class) {
                return this;
            }
        } else if (to == Date.class) {
            if (from == Long.class) {
                return this;
            }
        } else if (to == HashMap.class) {
            if (from == Map.class) {
                return this;
            }
        } else if (to == Hashtable.class) {
            if (from == Map.class) {
                return this;
            }
        } else if (to == Iterator.class) {
            if (from == Object.class) {
                return this;
            }
        } else if (to == List.class) {
            if (from == Object[].class) {
                return this;
            }
            if (from == Collection.class) {
                return this;
            }
            if (from == Iterable.class) {
                return this;
            }
            if (from == Iterator.class) {
                return this;
            }
        } else if (to == Properties.class) {
            if (from == Map.class) {
                return this;
            }
            if (from == File.class) {
                return this;
            }
            if (from == InputStream.class) {
                return this;
            }
            if (from == Reader.class) {
                return this;
            }
        } else if (to == Set.class) {
            if (from == Object[].class) {
                return this;
            }
            if (from == Collection.class) {
                return this;
            }
            if (from == Map.class) {
                return this;
            }
        } else if (to == TimeZone.class) {
            if (from == String.class) {
                return this;
            }
        } else if (to == Processor.class) {
            if (from == Expression.class) {
                return this;
            }
            if (from == Predicate.class) {
                return this;
            }
        }
        return null;
    }
}

