/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.ContentTypeHeaderAware;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.2.0", label="dataformat,transformation", title="Protobuf")
@XmlRootElement(name="protobuf")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProtobufDataFormat
extends DataFormatDefinition
implements ContentTypeHeaderAware {
    @XmlAttribute
    private String instanceClass;
    @XmlAttribute
    @Metadata(enums="native,json", defaultValue="native")
    private String contentTypeFormat;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true", description="Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON")
    private String contentTypeHeader;
    @XmlTransient
    private Object defaultInstance;

    public ProtobufDataFormat() {
        super("protobuf");
    }

    public ProtobufDataFormat(String instanceClass) {
        this();
        this.setInstanceClass(instanceClass);
    }

    public ProtobufDataFormat(String instanceClass, String contentTypeFormat) {
        this();
        this.setInstanceClass(instanceClass);
        this.setContentTypeFormat(contentTypeFormat);
    }

    public String getInstanceClass() {
        return this.instanceClass;
    }

    public void setInstanceClass(String instanceClass) {
        this.instanceClass = instanceClass;
    }

    public void setContentTypeFormat(String contentTypeFormat) {
        this.contentTypeFormat = contentTypeFormat;
    }

    public String getContentTypeFormat() {
        return this.contentTypeFormat;
    }

    @Override
    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(String contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public Object getDefaultInstance() {
        return this.defaultInstance;
    }

    public void setDefaultInstance(Object defaultInstance) {
        this.defaultInstance = defaultInstance;
    }
}

