/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Navigate;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.TimeoutMap;
import org.apache.camel.Traceable;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.AggregateProcessorStatistics;
import org.apache.camel.processor.aggregate.ClosedCorrelationKeyException;
import org.apache.camel.processor.aggregate.DefaultAggregateController;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.OptimisticLockingAggregationRepository;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.DefaultTimeoutMap;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.NoLock;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateProcessor
extends AsyncProcessorSupport
implements Navigate<Processor>,
Traceable,
ShutdownPrepared,
ShutdownAware,
IdAware,
RouteIdAware {
    public static final String AGGREGATE_TIMEOUT_CHECKER = "AggregateTimeoutChecker";
    public static final String AGGREGATE_OPTIMISTIC_LOCKING_EXECUTOR = "AggregateOptimisticLockingExecutor";
    public static final String COMPLETED_BY_SIZE = "size";
    public static final String COMPLETED_BY_PREDICATE = "predicate";
    public static final String COMPLETED_BY_CONSUMER = "consumer";
    public static final String COMPLETED_BY_STRATEGY = "strategy";
    public static final String COMPLETED_BY_INTERVAL = "interval";
    public static final String COMPLETED_BY_TIMEOUT = "timeout";
    public static final String COMPLETED_BY_FORCE = "force";
    private static final Logger LOG = LoggerFactory.getLogger(AggregateProcessor.class);
    private volatile Lock lock;
    private final AtomicBoolean aggregateRepositoryWarned = new AtomicBoolean();
    private final CamelContext camelContext;
    private final ReactiveExecutor reactiveExecutor;
    private final AsyncProcessor processor;
    private String id;
    private String routeId;
    private AggregationStrategy aggregationStrategy;
    private boolean preCompletion;
    private Expression correlationExpression;
    private AggregateController aggregateController;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private OptimisticLockRetryPolicy optimisticLockRetryPolicy = new OptimisticLockRetryPolicy();
    private ScheduledExecutorService timeoutCheckerExecutorService;
    private boolean shutdownTimeoutCheckerExecutorService;
    private ScheduledExecutorService optimisticLockingExecutorService;
    private boolean shutdownOptimisticLockingExecutorService;
    private ScheduledExecutorService recoverService;
    private TimeoutMap<String, String> timeoutMap;
    private ExceptionHandler exceptionHandler;
    private AggregationRepository aggregationRepository;
    private Map<String, String> closedCorrelationKeys;
    private final Set<String> batchConsumerCorrelationKeys = new ConcurrentSkipListSet<String>();
    private final Set<String> inProgressCompleteExchanges = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, RedeliveryData> redeliveryState = new ConcurrentHashMap<String, RedeliveryData>();
    private final AggregateProcessorStatistics statistics = new Statistics();
    private final AtomicLong totalIn = new AtomicLong();
    private final AtomicLong totalCompleted = new AtomicLong();
    private final AtomicLong completedBySize = new AtomicLong();
    private final AtomicLong completedByStrategy = new AtomicLong();
    private final AtomicLong completedByInterval = new AtomicLong();
    private final AtomicLong completedByTimeout = new AtomicLong();
    private final AtomicLong completedByPredicate = new AtomicLong();
    private final AtomicLong completedByBatchConsumer = new AtomicLong();
    private final AtomicLong completedByForce = new AtomicLong();
    private final AtomicLong discarded = new AtomicLong();
    private boolean ignoreInvalidCorrelationKeys;
    private Integer closeCorrelationKeyOnCompletion;
    private boolean parallelProcessing;
    private boolean optimisticLocking;
    private boolean eagerCheckCompletion;
    private Predicate completionPredicate;
    private long completionTimeout;
    private Expression completionTimeoutExpression;
    private long completionInterval;
    private int completionSize;
    private Expression completionSizeExpression;
    private boolean completionFromBatchConsumer;
    private boolean completionOnNewCorrelationGroup;
    private AtomicInteger batchConsumerCounter = new AtomicInteger();
    private boolean discardOnCompletionTimeout;
    private boolean discardOnAggregationFailure;
    private boolean forceCompletionOnStop;
    private boolean completeAllOnStop;
    private long completionTimeoutCheckerInterval = 1000L;
    private ProducerTemplate deadLetterProducerTemplate;

    public AggregateProcessor(CamelContext camelContext, AsyncProcessor processor, Expression correlationExpression, AggregationStrategy aggregationStrategy, ExecutorService executorService, boolean shutdownExecutorService) {
        ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        ObjectHelper.notNull((Object)processor, (String)"processor");
        ObjectHelper.notNull((Object)correlationExpression, (String)"correlationExpression");
        ObjectHelper.notNull((Object)aggregationStrategy, (String)"aggregationStrategy");
        ObjectHelper.notNull((Object)executorService, (String)"executorService");
        this.camelContext = camelContext;
        this.reactiveExecutor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getReactiveExecutor();
        this.processor = processor;
        this.correlationExpression = correlationExpression;
        this.aggregationStrategy = aggregationStrategy;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.exceptionHandler = new LoggingExceptionHandler(camelContext, ((Object)((Object)this)).getClass());
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "aggregate[" + this.correlationExpression + "]";
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add((Processor)this.processor);
        return answer;
    }

    public boolean hasNext() {
        return this.processor != null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.doProcess(exchange, callback);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected boolean doProcess(Exchange exchange, AsyncCallback callback) throws Exception {
        if (this.getStatistics().isStatisticsEnabled()) {
            this.totalIn.incrementAndGet();
        }
        if (this.isCompleteAllGroups(exchange).booleanValue()) {
            this.removeFlagCompleteAllGroups(exchange);
            this.forceCompletionOfAllGroups();
            callback.done(true);
            return true;
        }
        String key = (String)this.correlationExpression.evaluate(exchange, String.class);
        if (ObjectHelper.isEmpty((Object)key)) {
            if (this.isIgnoreInvalidCorrelationKeys()) {
                LOG.debug("Invalid correlation key. This Exchange will be ignored: {}", (Object)exchange);
            } else {
                exchange.setException((Throwable)new CamelExchangeException("Invalid correlation key", exchange));
            }
            callback.done(true);
            return true;
        }
        if (this.closedCorrelationKeys != null && this.closedCorrelationKeys.containsKey(key)) {
            exchange.setException((Throwable)((Object)new ClosedCorrelationKeyException(key, exchange)));
            callback.done(true);
            return true;
        }
        if (this.optimisticLocking) {
            return this.doInOptimisticLock(exchange, key, callback, 0, true);
        }
        return this.doProcess(exchange, key, callback, true);
    }

    protected boolean doInOptimisticLock(Exchange exchange, String key, AsyncCallback callback, int attempt, boolean sync) {
        while (true) {
            ++attempt;
            try {
                return this.doProcess(exchange, key, callback, sync);
            }
            catch (OptimisticLockingAggregationRepository.OptimisticLockingException e) {
                LOG.trace("On attempt {} OptimisticLockingAggregationRepository: {} threw OptimisticLockingException while trying to aggregate exchange: {}", new Object[]{attempt, this.aggregationRepository, exchange, e});
                if (this.optimisticLockRetryPolicy.shouldRetry(attempt)) {
                    long delay;
                    if ((delay = this.optimisticLockRetryPolicy.getDelay(attempt)) <= 0L) continue;
                    int nextAttempt = attempt;
                    this.getOptimisticLockingExecutorService().schedule(() -> this.doInOptimisticLock(exchange, key, callback, nextAttempt, false), delay, TimeUnit.MILLISECONDS);
                    return false;
                }
                exchange.setException((Throwable)new CamelExchangeException("Exhausted optimistic locking retry attempts, tried " + attempt + " times", exchange, (Throwable)new OptimisticLockingAggregationRepository.OptimisticLockingException()));
                callback.done(sync);
                return sync;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doProcess(Exchange exchange, String key, AsyncCallback callback, boolean sync) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
        this.removeFlagCompleteCurrentGroup(copy);
        this.removeFlagCompleteAllGroups(copy);
        this.removeFlagCompleteAllGroupsInclusive(copy);
        List<Exchange> aggregated = null;
        this.lock.lock();
        try {
            aggregated = this.doAggregation(key, copy);
        }
        catch (CamelExchangeException e) {
            exchange.setException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
        if (aggregated != null) {
            aggregated.forEach(agg -> this.onSubmitCompletion(key, (Exchange)agg));
        }
        if (this.isCompleteAllGroupsInclusive(exchange).booleanValue()) {
            this.removeFlagCompleteAllGroupsInclusive(exchange);
            this.forceCompletionOfAllGroups();
        }
        callback.done(sync);
        return sync;
    }

    private Object removeFlagCompleteCurrentGroup(Exchange exchange) {
        return exchange.removeProperty("CamelAggregationCompleteCurrentGroup");
    }

    private Boolean isCompleteCurrentGroup(Exchange exchange) {
        return (Boolean)exchange.getProperty("CamelAggregationCompleteCurrentGroup", (Object)false, Boolean.TYPE);
    }

    private Object removeFlagCompleteAllGroups(Exchange exchange) {
        Object removedHeader = exchange.getIn().removeHeader("CamelAggregationCompleteAllGroups");
        Object removedProp = exchange.removeProperty("CamelAggregationCompleteAllGroups");
        return removedHeader == null ? removedProp : removedHeader;
    }

    private Boolean isCompleteAllGroups(Exchange exchange) {
        boolean retVal = (Boolean)exchange.getIn().getHeader("CamelAggregationCompleteAllGroups", (Object)false, Boolean.TYPE);
        if (!retVal) {
            retVal = (Boolean)exchange.getProperty("CamelAggregationCompleteAllGroups", (Object)false, Boolean.TYPE);
        }
        return retVal;
    }

    private Object removeFlagCompleteAllGroupsInclusive(Exchange exchange) {
        return exchange.getIn().removeHeader("CamelAggregationCompleteAllGroupsInclusive");
    }

    private Boolean isCompleteAllGroupsInclusive(Exchange exchange) {
        return (Boolean)exchange.getIn().getHeader("CamelAggregationCompleteAllGroupsInclusive", (Object)false, Boolean.TYPE);
    }

    private List<Exchange> doAggregation(String key, Exchange newExchange) throws CamelExchangeException {
        Exchange answer;
        Exchange originalExchange;
        LOG.trace("onAggregation +++ start +++ with correlation key: {}", (Object)key);
        ArrayList<Exchange> list = new ArrayList<Exchange>();
        String complete = null;
        Exchange oldExchange = originalExchange = this.aggregationRepository.get(newExchange.getContext(), key);
        Integer size = 1;
        if (oldExchange != null) {
            if (this.optimisticLocking && this.aggregationRepository instanceof MemoryAggregationRepository) {
                oldExchange = originalExchange.copy();
            }
            Integer n = size = (Integer)oldExchange.getProperty("CamelAggregatedSize", (Object)0, Integer.class);
            Integer n2 = size = Integer.valueOf(size + 1);
        }
        ExchangeHelper.prepareAggregation((Exchange)oldExchange, (Exchange)newExchange);
        if (this.preCompletion) {
            try {
                newExchange.setProperty("CamelAggregatedSize", (Object)size);
                complete = this.isPreCompleted(key, oldExchange, newExchange);
                if (complete == null) {
                    this.trackTimeout(key, newExchange);
                }
                newExchange.removeProperty("CamelAggregatedSize");
            }
            catch (Throwable e) {
                throw new CamelExchangeException("Error occurred during preComplete", newExchange, e);
            }
        } else if (this.isEagerCheckCompletion()) {
            newExchange.setProperty("CamelAggregatedSize", (Object)size);
            complete = this.isCompleted(key, newExchange);
            if (complete == null) {
                this.trackTimeout(key, newExchange);
            }
            newExchange.removeProperty("CamelAggregatedSize");
        }
        if (this.preCompletion && complete != null) {
            this.doAggregationComplete(complete, list, key, originalExchange, oldExchange, false);
            complete = null;
            oldExchange = null;
            originalExchange = null;
            size = 1;
            this.trackTimeout(key, newExchange);
        }
        boolean aggregateFailed = false;
        try {
            answer = this.onAggregation(oldExchange, newExchange);
        }
        catch (Throwable e) {
            aggregateFailed = true;
            if (this.isDiscardOnAggregationFailure()) {
                LOG.debug("Aggregation for correlation key {} discarding aggregated exchange: {} due to failure in AggregationStrategy caused by: {}", new Object[]{key, oldExchange, e.getMessage()});
                complete = COMPLETED_BY_STRATEGY;
                answer = oldExchange;
                if (answer == null) {
                    return null;
                }
            }
            throw new CamelExchangeException("Error occurred during aggregation", newExchange, e);
        }
        if (answer == null) {
            throw new CamelExchangeException("AggregationStrategy " + this.aggregationStrategy + " returned null which is not allowed", newExchange);
        }
        if (this.isCompleteAllGroups(answer).booleanValue()) {
            this.removeFlagCompleteAllGroups(answer);
            this.forceCompletionOfAllGroups();
        } else if (this.isCompletionOnNewCorrelationGroup() && originalExchange == null) {
            this.forceCompletionOfAllGroups();
        }
        if (this.aggregationRepository instanceof RecoverableAggregationRepository) {
            boolean valid;
            boolean bl = valid = oldExchange == null || answer.getExchangeId().equals(oldExchange.getExchangeId());
            if (!valid && this.aggregateRepositoryWarned.compareAndSet(false, true)) {
                LOG.warn("AggregationStrategy should return the oldExchange instance instead of the newExchange whenever possible as otherwise this can lead to unexpected behavior with some RecoverableAggregationRepository implementations");
            }
        }
        answer.setProperty("CamelAggregatedSize", (Object)size);
        if (!this.preCompletion && !this.isEagerCheckCompletion() && (complete = this.isCompleted(key, answer)) == null) {
            this.trackTimeout(key, newExchange);
        }
        if (!aggregateFailed && complete == null) {
            this.doAggregationRepositoryAdd(newExchange.getContext(), key, originalExchange, answer);
        } else {
            this.doAggregationComplete(complete, list, key, originalExchange, answer, aggregateFailed);
        }
        LOG.trace("onAggregation +++  end  +++ with correlation key: {}", (Object)key);
        return list;
    }

    protected void doAggregationComplete(String complete, List<Exchange> list, String key, Exchange originalExchange, Exchange answer, boolean aggregateFailed) {
        if (COMPLETED_BY_CONSUMER.equals(complete)) {
            for (String batchKey : this.batchConsumerCorrelationKeys) {
                Exchange batchAnswer = batchKey.equals(key) ? answer : this.aggregationRepository.get(this.camelContext, batchKey);
                if (batchAnswer == null) continue;
                batchAnswer.setProperty("CamelAggregatedCompletedBy", (Object)complete);
                this.onCompletion(batchKey, originalExchange, batchAnswer, false, aggregateFailed);
                list.add(batchAnswer);
            }
            this.batchConsumerCorrelationKeys.clear();
            answer = null;
        } else if (answer != null) {
            answer.setProperty("CamelAggregatedCompletedBy", (Object)complete);
            answer = this.onCompletion(key, originalExchange, answer, false, aggregateFailed);
        }
        if (answer != null) {
            list.add(answer);
        }
    }

    protected void doAggregationRepositoryAdd(CamelContext camelContext, String key, Exchange oldExchange, Exchange newExchange) {
        LOG.trace("In progress aggregated oldExchange: {}, newExchange: {} with correlation key: {}", new Object[]{oldExchange, newExchange, key});
        if (this.optimisticLocking) {
            try {
                ((OptimisticLockingAggregationRepository)this.aggregationRepository).add(camelContext, key, oldExchange, newExchange);
            }
            catch (OptimisticLockingAggregationRepository.OptimisticLockingException e) {
                this.onOptimisticLockingFailure(oldExchange, newExchange);
                throw e;
            }
        } else {
            this.aggregationRepository.add(camelContext, key, newExchange);
        }
    }

    protected void onOptimisticLockingFailure(Exchange oldExchange, Exchange newExchange) {
        this.aggregationStrategy.onOptimisticLockFailure(oldExchange, newExchange);
    }

    protected String isPreCompleted(String key, Exchange oldExchange, Exchange newExchange) {
        return this.aggregationStrategy.preComplete(oldExchange, newExchange) ? COMPLETED_BY_STRATEGY : null;
    }

    protected String isCompleted(String key, Exchange exchange) {
        int size;
        Integer value;
        boolean answer;
        if (this.isCompletionFromBatchConsumer()) {
            this.batchConsumerCorrelationKeys.add(key);
            this.batchConsumerCounter.incrementAndGet();
            int size2 = (Integer)exchange.getProperty("CamelBatchSize", (Object)0, Integer.class);
            if (size2 > 0 && this.batchConsumerCounter.intValue() >= size2) {
                this.batchConsumerCounter.set(0);
                return COMPLETED_BY_CONSUMER;
            }
        }
        if (this.isCompleteCurrentGroup(exchange).booleanValue()) {
            this.removeFlagCompleteCurrentGroup(exchange);
            return COMPLETED_BY_STRATEGY;
        }
        if (this.getCompletionPredicate() != null && (answer = this.getCompletionPredicate().matches(exchange))) {
            return COMPLETED_BY_PREDICATE;
        }
        boolean sizeChecked = false;
        if (this.getCompletionSizeExpression() != null && (value = (Integer)this.getCompletionSizeExpression().evaluate(exchange, Integer.class)) != null && value > 0) {
            sizeChecked = true;
            int size3 = (Integer)exchange.getProperty("CamelAggregatedSize", (Object)1, Integer.class);
            if (size3 >= value) {
                return COMPLETED_BY_SIZE;
            }
        }
        if (!sizeChecked && this.getCompletionSize() > 0 && (size = ((Integer)exchange.getProperty("CamelAggregatedSize", (Object)1, Integer.class)).intValue()) >= this.getCompletionSize()) {
            return COMPLETED_BY_SIZE;
        }
        return null;
    }

    protected void trackTimeout(String key, Exchange exchange) {
        Long value;
        boolean timeoutSet = false;
        if (this.getCompletionTimeoutExpression() != null && (value = (Long)this.getCompletionTimeoutExpression().evaluate(exchange, Long.class)) != null && value > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Updating correlation key {} to timeout after {} ms. as exchange received: {}", new Object[]{key, value, exchange});
            }
            this.addExchangeToTimeoutMap(key, exchange, value);
            timeoutSet = true;
        }
        if (!timeoutSet && this.getCompletionTimeout() > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Updating correlation key {} to timeout after {} ms. as exchange received: {}", new Object[]{key, this.getCompletionTimeout(), exchange});
            }
            this.addExchangeToTimeoutMap(key, exchange, this.getCompletionTimeout());
        }
    }

    protected Exchange onAggregation(Exchange oldExchange, Exchange newExchange) {
        return this.aggregationStrategy.aggregate(oldExchange, newExchange);
    }

    protected Exchange onCompletion(String key, Exchange original, Exchange aggregated, boolean fromTimeout, boolean aggregateFailed) {
        Exchange answer;
        if (original != null) {
            original.setProperty("CamelAggregatedCorrelationKey", (Object)key);
        }
        aggregated.setProperty("CamelAggregatedCorrelationKey", (Object)key);
        if (original != null) {
            this.aggregationRepository.remove(aggregated.getContext(), key, original);
        }
        if (!fromTimeout && this.timeoutMap != null) {
            LOG.trace("Removing correlation key {} from timeout", (Object)key);
            this.timeoutMap.remove((Object)key);
        }
        if (this.closedCorrelationKeys != null) {
            this.closedCorrelationKeys.put(key, key);
        }
        if (fromTimeout) {
            long timeout = this.getCompletionTimeout() > 0L ? this.getCompletionTimeout() : -1L;
            this.aggregationStrategy.timeout(aggregated, -1, -1, timeout);
        }
        if (fromTimeout && this.isDiscardOnCompletionTimeout()) {
            this.discarded.incrementAndGet();
            LOG.debug("Aggregation for correlation key {} discarding aggregated exchange: {}", (Object)key, (Object)aggregated);
            this.aggregationRepository.confirm(aggregated.getContext(), aggregated.getExchangeId());
            this.redeliveryState.remove(aggregated.getExchangeId());
            answer = null;
        } else if (aggregateFailed && this.isDiscardOnAggregationFailure()) {
            this.discarded.incrementAndGet();
            LOG.debug("Aggregation for correlation key {} discarding aggregated exchange: {}", (Object)key, (Object)aggregated);
            this.aggregationRepository.confirm(aggregated.getContext(), aggregated.getExchangeId());
            this.redeliveryState.remove(aggregated.getExchangeId());
            answer = null;
        } else {
            answer = aggregated;
        }
        return answer;
    }

    private void onSubmitCompletion(String key, Exchange exchange) {
        LOG.debug("Aggregation complete for correlation key {} sending aggregated exchange: {}", (Object)key, (Object)exchange);
        this.inProgressCompleteExchanges.add(exchange.getExchangeId());
        this.aggregationStrategy.onCompletion(exchange);
        if (this.getStatistics().isStatisticsEnabled()) {
            String completedBy;
            this.totalCompleted.incrementAndGet();
            switch (completedBy = (String)exchange.getProperty("CamelAggregatedCompletedBy", String.class)) {
                case "interval": {
                    this.completedByInterval.incrementAndGet();
                    break;
                }
                case "timeout": {
                    this.completedByTimeout.incrementAndGet();
                    break;
                }
                case "force": {
                    this.completedByForce.incrementAndGet();
                    break;
                }
                case "consumer": {
                    this.completedByBatchConsumer.incrementAndGet();
                    break;
                }
                case "predicate": {
                    this.completedByPredicate.incrementAndGet();
                    break;
                }
                case "size": {
                    this.completedBySize.incrementAndGet();
                    break;
                }
                case "strategy": {
                    this.completedByStrategy.incrementAndGet();
                    break;
                }
                default: {
                    LOG.error("Invalid value of {} property: {}", (Object)"CamelAggregatedCompletedBy", (Object)exchange);
                }
            }
        }
        LOG.debug("Processing aggregated exchange: {}", (Object)exchange);
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new AggregateOnCompletion(exchange.getExchangeId()));
        this.executorService.execute(() -> this.reactiveExecutor.schedule(() -> this.processor.process(exchange, done -> {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing aggregated exchange", exchange, (Throwable)exchange.getException());
            } else {
                LOG.trace("Processing aggregated exchange: {} complete.", (Object)exchange);
            }
        })));
    }

    protected void restoreTimeoutMapFromAggregationRepository() throws Exception {
        Set keys = this.aggregationRepository.getKeys();
        if (keys == null || keys.isEmpty()) {
            return;
        }
        StopWatch watch = new StopWatch();
        LOG.trace("Starting restoring CompletionTimeout for {} existing exchanges from the aggregation repository...", (Object)keys.size());
        for (String key : keys) {
            Exchange exchange = this.aggregationRepository.get(this.camelContext, key);
            long timeout = exchange.hasProperties() ? (Long)exchange.getProperty("CamelAggregatedTimeout", (Object)0L, Long.TYPE) : 0L;
            if (timeout <= 0L) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Restoring CompletionTimeout for exchangeId: {} with timeout: {} millis.", (Object)exchange.getExchangeId(), (Object)timeout);
            }
            this.addExchangeToTimeoutMap(key, exchange, timeout);
        }
        LOG.info("Restored {} CompletionTimeout conditions in the AggregationTimeoutChecker in {}", (Object)this.timeoutMap.size(), (Object)TimeUtils.printDuration((long)watch.taken()));
    }

    private void addExchangeToTimeoutMap(String key, Exchange exchange, long timeout) {
        exchange.setProperty("CamelAggregatedTimeout", (Object)timeout);
        this.timeoutMap.put((Object)key, (Object)exchange.getExchangeId(), timeout);
    }

    public int getClosedCorrelationKeysCacheSize() {
        if (this.closedCorrelationKeys != null) {
            return this.closedCorrelationKeys.size();
        }
        return 0;
    }

    public void clearClosedCorrelationKeysCache() {
        if (this.closedCorrelationKeys != null) {
            this.closedCorrelationKeys.clear();
        }
    }

    public AggregateProcessorStatistics getStatistics() {
        return this.statistics;
    }

    public int getInProgressCompleteExchanges() {
        return this.inProgressCompleteExchanges.size();
    }

    public Predicate getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(Predicate completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public boolean isEagerCheckCompletion() {
        return this.eagerCheckCompletion;
    }

    public void setEagerCheckCompletion(boolean eagerCheckCompletion) {
        this.eagerCheckCompletion = eagerCheckCompletion;
    }

    public long getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setCompletionTimeout(long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public Expression getCompletionTimeoutExpression() {
        return this.completionTimeoutExpression;
    }

    public void setCompletionTimeoutExpression(Expression completionTimeoutExpression) {
        this.completionTimeoutExpression = completionTimeoutExpression;
    }

    public long getCompletionInterval() {
        return this.completionInterval;
    }

    public void setCompletionInterval(long completionInterval) {
        this.completionInterval = completionInterval;
    }

    public int getCompletionSize() {
        return this.completionSize;
    }

    public void setCompletionSize(int completionSize) {
        this.completionSize = completionSize;
    }

    public Expression getCompletionSizeExpression() {
        return this.completionSizeExpression;
    }

    public void setCompletionSizeExpression(Expression completionSizeExpression) {
        this.completionSizeExpression = completionSizeExpression;
    }

    public boolean isIgnoreInvalidCorrelationKeys() {
        return this.ignoreInvalidCorrelationKeys;
    }

    public void setIgnoreInvalidCorrelationKeys(boolean ignoreInvalidCorrelationKeys) {
        this.ignoreInvalidCorrelationKeys = ignoreInvalidCorrelationKeys;
    }

    public Integer getCloseCorrelationKeyOnCompletion() {
        return this.closeCorrelationKeyOnCompletion;
    }

    public void setCloseCorrelationKeyOnCompletion(Integer closeCorrelationKeyOnCompletion) {
        this.closeCorrelationKeyOnCompletion = closeCorrelationKeyOnCompletion;
    }

    public boolean isCompletionFromBatchConsumer() {
        return this.completionFromBatchConsumer;
    }

    public void setCompletionFromBatchConsumer(boolean completionFromBatchConsumer) {
        this.completionFromBatchConsumer = completionFromBatchConsumer;
    }

    public boolean isCompletionOnNewCorrelationGroup() {
        return this.completionOnNewCorrelationGroup;
    }

    public void setCompletionOnNewCorrelationGroup(boolean completionOnNewCorrelationGroup) {
        this.completionOnNewCorrelationGroup = completionOnNewCorrelationGroup;
    }

    public boolean isCompleteAllOnStop() {
        return this.completeAllOnStop;
    }

    public long getCompletionTimeoutCheckerInterval() {
        return this.completionTimeoutCheckerInterval;
    }

    public void setCompletionTimeoutCheckerInterval(long completionTimeoutCheckerInterval) {
        this.completionTimeoutCheckerInterval = completionTimeoutCheckerInterval;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isOptimisticLocking() {
        return this.optimisticLocking;
    }

    public void setOptimisticLocking(boolean optimisticLocking) {
        this.optimisticLocking = optimisticLocking;
    }

    public AggregationRepository getAggregationRepository() {
        return this.aggregationRepository;
    }

    public void setAggregationRepository(AggregationRepository aggregationRepository) {
        this.aggregationRepository = aggregationRepository;
    }

    public boolean isDiscardOnCompletionTimeout() {
        return this.discardOnCompletionTimeout;
    }

    public void setDiscardOnCompletionTimeout(boolean discardOnCompletionTimeout) {
        this.discardOnCompletionTimeout = discardOnCompletionTimeout;
    }

    public boolean isDiscardOnAggregationFailure() {
        return this.discardOnAggregationFailure;
    }

    public void setDiscardOnAggregationFailure(boolean discardOnAggregationFailure) {
        this.discardOnAggregationFailure = discardOnAggregationFailure;
    }

    public void setForceCompletionOnStop(boolean forceCompletionOnStop) {
        this.forceCompletionOnStop = forceCompletionOnStop;
    }

    public void setCompleteAllOnStop(boolean completeAllOnStop) {
        this.completeAllOnStop = completeAllOnStop;
    }

    public void setTimeoutCheckerExecutorService(ScheduledExecutorService timeoutCheckerExecutorService) {
        this.timeoutCheckerExecutorService = timeoutCheckerExecutorService;
    }

    public ScheduledExecutorService getTimeoutCheckerExecutorService() {
        return this.timeoutCheckerExecutorService;
    }

    public boolean isShutdownTimeoutCheckerExecutorService() {
        return this.shutdownTimeoutCheckerExecutorService;
    }

    public void setShutdownTimeoutCheckerExecutorService(boolean shutdownTimeoutCheckerExecutorService) {
        this.shutdownTimeoutCheckerExecutorService = shutdownTimeoutCheckerExecutorService;
    }

    public void setOptimisticLockingExecutorService(ScheduledExecutorService optimisticLockingExecutorService) {
        this.optimisticLockingExecutorService = optimisticLockingExecutorService;
    }

    public ScheduledExecutorService getOptimisticLockingExecutorService() {
        return this.optimisticLockingExecutorService;
    }

    public boolean isShutdownOptimisticLockingExecutorService() {
        return this.shutdownOptimisticLockingExecutorService;
    }

    public void setShutdownOptimisticLockingExecutorService(boolean shutdownOptimisticLockingExecutorService) {
        this.shutdownOptimisticLockingExecutorService = shutdownOptimisticLockingExecutorService;
    }

    public void setOptimisticLockRetryPolicy(OptimisticLockRetryPolicy optimisticLockRetryPolicy) {
        this.optimisticLockRetryPolicy = optimisticLockRetryPolicy;
    }

    public OptimisticLockRetryPolicy getOptimisticLockRetryPolicy() {
        return this.optimisticLockRetryPolicy;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public Expression getCorrelationExpression() {
        return this.correlationExpression;
    }

    public void setCorrelationExpression(Expression correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public AggregateController getAggregateController() {
        return this.aggregateController;
    }

    public void setAggregateController(AggregateController aggregateController) {
        this.aggregateController = aggregateController;
    }

    protected void doStart() throws Exception {
        RecoverableAggregationRepository recoverable;
        if (this.aggregationStrategy instanceof CamelContextAware) {
            ((CamelContextAware)this.aggregationStrategy).setCamelContext(this.camelContext);
        }
        if (this.aggregationStrategy.canPreComplete()) {
            this.preCompletion = true;
            LOG.info("PreCompletionAwareAggregationStrategy detected. Aggregator {} is in pre-completion mode.", (Object)this.getId());
        }
        if (!this.preCompletion && this.getCompletionTimeout() <= 0L && this.getCompletionInterval() <= 0L && this.getCompletionSize() <= 0 && this.getCompletionPredicate() == null && !this.isCompletionFromBatchConsumer() && this.getCompletionTimeoutExpression() == null && this.getCompletionSizeExpression() == null) {
            throw new IllegalStateException("At least one of the completions options [completionTimeout, completionInterval, completionSize, completionPredicate, completionFromBatchConsumer] must be set");
        }
        if (this.getCloseCorrelationKeyOnCompletion() != null) {
            if (this.getCloseCorrelationKeyOnCompletion() > 0) {
                LOG.info("Using ClosedCorrelationKeys with a LRUCache with a capacity of {}", (Object)this.getCloseCorrelationKeyOnCompletion());
                this.closedCorrelationKeys = LRUCacheFactory.newLRUCache((int)this.getCloseCorrelationKeyOnCompletion());
            } else {
                LOG.info("Using ClosedCorrelationKeys with unbounded capacity");
                this.closedCorrelationKeys = new ConcurrentHashMap<String, String>();
            }
        }
        if (this.aggregationRepository == null) {
            this.aggregationRepository = new MemoryAggregationRepository(this.optimisticLocking);
            LOG.info("Defaulting to MemoryAggregationRepository");
        }
        if (this.optimisticLocking) {
            if (!(this.aggregationRepository instanceof OptimisticLockingAggregationRepository)) {
                throw new IllegalArgumentException("Optimistic locking cannot be enabled without using an AggregationRepository that implements OptimisticLockingAggregationRepository");
            }
            LOG.info("Optimistic locking is enabled");
        }
        ServiceHelper.startService((Object[])new Object[]{this.aggregationStrategy, this.processor, this.aggregationRepository});
        if (this.aggregationRepository instanceof RecoverableAggregationRepository && (recoverable = (RecoverableAggregationRepository)this.aggregationRepository).isUseRecovery()) {
            long interval = recoverable.getRecoveryIntervalInMillis();
            if (interval <= 0L) {
                throw new IllegalArgumentException("AggregationRepository has recovery enabled and the RecoveryInterval option must be a positive number, was: " + interval);
            }
            this.recoverService = this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, "AggregateRecoverChecker", 1);
            RecoverTask recoverTask = new RecoverTask(recoverable);
            LOG.info("Using RecoverableAggregationRepository by scheduling recover checker to run every {} millis.", (Object)interval);
            this.recoverService.scheduleWithFixedDelay(recoverTask, 1000L, interval, TimeUnit.MILLISECONDS);
            if (recoverable.getDeadLetterUri() != null) {
                int max = recoverable.getMaximumRedeliveries();
                if (max <= 0) {
                    throw new IllegalArgumentException("Option maximumRedeliveries must be a positive number, was: " + max);
                }
                LOG.info("After {} failed redelivery attempts Exchanges will be moved to deadLetterUri: {}", (Object)max, (Object)recoverable.getDeadLetterUri());
                Endpoint endpoint = this.camelContext.getEndpoint(recoverable.getDeadLetterUri());
                if (endpoint == null) {
                    throw new NoSuchEndpointException(recoverable.getDeadLetterUri());
                }
                this.deadLetterProducerTemplate = this.camelContext.createProducerTemplate();
            }
        }
        if (this.getCompletionInterval() > 0L && this.getCompletionTimeout() > 0L) {
            throw new IllegalArgumentException("Only one of completionInterval or completionTimeout can be used, not both.");
        }
        if (this.getCompletionInterval() > 0L) {
            LOG.info("Using CompletionInterval to run every {} millis.", (Object)this.getCompletionInterval());
            if (this.getTimeoutCheckerExecutorService() == null) {
                this.setTimeoutCheckerExecutorService(this.camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, AGGREGATE_TIMEOUT_CHECKER));
                this.shutdownTimeoutCheckerExecutorService = true;
            }
            this.getTimeoutCheckerExecutorService().scheduleAtFixedRate(new AggregationIntervalTask(), this.getCompletionInterval(), this.getCompletionInterval(), TimeUnit.MILLISECONDS);
        }
        if (this.getCompletionTimeout() > 0L || this.getCompletionTimeoutExpression() != null) {
            LOG.info("Using CompletionTimeout to trigger after {} millis of inactivity.", (Object)this.getCompletionTimeout());
            if (this.getTimeoutCheckerExecutorService() == null) {
                this.setTimeoutCheckerExecutorService(this.camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, AGGREGATE_TIMEOUT_CHECKER));
                this.shutdownTimeoutCheckerExecutorService = true;
            }
            this.timeoutMap = new AggregationTimeoutMap(this.getTimeoutCheckerExecutorService(), this.getCompletionTimeoutCheckerInterval());
            this.restoreTimeoutMapFromAggregationRepository();
            ServiceHelper.startService(this.timeoutMap);
        }
        if (this.aggregateController == null) {
            this.aggregateController = new DefaultAggregateController();
        }
        this.aggregateController.onStart(this);
        if (this.optimisticLocking) {
            this.lock = NoLock.INSTANCE;
            if (this.getOptimisticLockingExecutorService() == null) {
                this.setOptimisticLockingExecutorService(this.camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, AGGREGATE_OPTIMISTIC_LOCKING_EXECUTOR));
                this.shutdownOptimisticLockingExecutorService = true;
            }
        } else {
            this.lock = new ReentrantLock();
        }
    }

    protected void doStop() throws Exception {
        if (this.aggregateController != null) {
            this.aggregateController.onStop(this);
        }
        if (this.recoverService != null) {
            this.camelContext.getExecutorServiceManager().shutdown((ExecutorService)this.recoverService);
        }
        if (this.shutdownTimeoutCheckerExecutorService && this.timeoutCheckerExecutorService != null) {
            this.camelContext.getExecutorServiceManager().shutdown((ExecutorService)this.timeoutCheckerExecutorService);
            this.timeoutCheckerExecutorService = null;
            this.shutdownTimeoutCheckerExecutorService = false;
        }
        ServiceHelper.stopService((Object[])new Object[]{this.timeoutMap, this.processor, this.deadLetterProducerTemplate});
        if (this.closedCorrelationKeys != null) {
            ServiceHelper.stopService(this.closedCorrelationKeys);
            this.closedCorrelationKeys.clear();
        }
        this.batchConsumerCorrelationKeys.clear();
        this.redeliveryState.clear();
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        if (!forced && this.forceCompletionOnStop) {
            this.doForceCompletionOnStop();
        }
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    public int getPendingExchangesSize() {
        if (this.completeAllOnStop) {
            Set keys = this.getAggregationRepository().getKeys();
            return keys != null ? keys.size() : 0;
        }
        return 0;
    }

    private void doForceCompletionOnStop() {
        int expected = this.forceCompletionOfAllGroups();
        StopWatch watch = new StopWatch();
        while (this.inProgressCompleteExchanges.size() > 0) {
            LOG.trace("Waiting for {} inflight exchanges to complete", (Object)this.getInProgressCompleteExchanges());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for {} inflight exchanges to complete.", (Object)this.getInProgressCompleteExchanges());
                break;
            }
        }
        if (expected > 0) {
            LOG.info("Forcing completion of all groups with {} exchanges completed in {}", (Object)expected, (Object)TimeUtils.printDuration((long)watch.taken()));
        }
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.aggregationRepository, this.aggregationStrategy});
        this.inProgressCompleteExchanges.clear();
        if (this.shutdownExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
        }
        if (this.shutdownTimeoutCheckerExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdownNow((ExecutorService)this.timeoutCheckerExecutorService);
            this.timeoutCheckerExecutorService = null;
        }
        if (this.shutdownOptimisticLockingExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdownNow((ExecutorService)this.optimisticLockingExecutorService);
            this.optimisticLockingExecutorService = null;
        }
        super.doShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forceCompletionOfGroup(String key) {
        int total = 0;
        this.lock.lock();
        try {
            Exchange exchange = this.aggregationRepository.get(this.camelContext, key);
            if (exchange != null) {
                total = 1;
                LOG.trace("Force completion triggered for correlation key: {}", (Object)key);
                exchange.setProperty("CamelAggregatedCompletedBy", (Object)COMPLETED_BY_FORCE);
                Exchange answer = this.onCompletion(key, exchange, exchange, false, false);
                if (answer != null) {
                    this.onSubmitCompletion(key, answer);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        LOG.trace("Completed force completion of group {}", (Object)key);
        if (total > 0) {
            LOG.debug("Forcing completion of group {} with {} exchanges", (Object)key, (Object)total);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forceCompletionOfAllGroups() {
        boolean allow;
        boolean bl = allow = this.camelContext.getStatus().isStarted() || this.camelContext.getStatus().isStopping();
        if (!allow) {
            LOG.warn("Cannot start force completion of all groups because CamelContext({}) has not been started", (Object)this.camelContext.getName());
            return 0;
        }
        LOG.trace("Starting force completion of all groups task");
        Set keys = this.aggregationRepository.getKeys();
        int total = 0;
        if (keys != null && !keys.isEmpty()) {
            this.lock.lock();
            total = keys.size();
            try {
                for (String key : keys) {
                    Exchange exchange = this.aggregationRepository.get(this.camelContext, key);
                    if (exchange == null) continue;
                    LOG.trace("Force completion triggered for correlation key: {}", (Object)key);
                    exchange.setProperty("CamelAggregatedCompletedBy", (Object)COMPLETED_BY_FORCE);
                    Exchange answer = this.onCompletion(key, exchange, exchange, false, false);
                    if (answer == null) continue;
                    this.onSubmitCompletion(key, answer);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        LOG.trace("Completed force completion of all groups task");
        if (total > 0) {
            LOG.debug("Forcing completion of all groups with {} exchanges", (Object)total);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forceDiscardingOfGroup(String key) {
        int total = 0;
        this.lock.lock();
        try {
            Exchange exchange = this.aggregationRepository.get(this.camelContext, key);
            if (exchange != null) {
                total = 1;
                LOG.trace("Force discarded triggered for correlation key: {}", (Object)key);
                this.onCompletion(key, exchange, exchange, false, true);
            }
        }
        finally {
            this.lock.unlock();
        }
        LOG.trace("Completed force discarded of group {}", (Object)key);
        if (total > 0) {
            LOG.debug("Forcing discarding of group {} with {} exchanges", (Object)key, (Object)total);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forceDiscardingOfAllGroups() {
        boolean allow;
        boolean bl = allow = this.camelContext.getStatus().isStarted() || this.camelContext.getStatus().isStopping();
        if (!allow) {
            LOG.warn("Cannot start force discarding of all groups because CamelContext({}) has not been started", (Object)this.camelContext.getName());
            return 0;
        }
        LOG.trace("Starting force discarding of all groups task");
        Set keys = this.aggregationRepository.getKeys();
        int total = 0;
        if (keys != null && !keys.isEmpty()) {
            this.lock.lock();
            total = keys.size();
            try {
                for (String key : keys) {
                    Exchange exchange = this.aggregationRepository.get(this.camelContext, key);
                    if (exchange == null) continue;
                    LOG.trace("Force discarded triggered for correlation key: {}", (Object)key);
                    this.onCompletion(key, exchange, exchange, false, true);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        LOG.trace("Completed force discarding of all groups task");
        if (total > 0) {
            LOG.debug("Forcing discarding of all groups with {} exchanges", (Object)total);
        }
        return total;
    }

    private final class RecoverTask
    implements Runnable {
        private final RecoverableAggregationRepository recoverable;

        private RecoverTask(RecoverableAggregationRepository recoverable) {
            this.recoverable = recoverable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!AggregateProcessor.this.camelContext.getStatus().isStarted()) {
                LOG.trace("Recover check cannot start due CamelContext({}) has not been started yet", (Object)AggregateProcessor.this.camelContext.getName());
                return;
            }
            LOG.trace("Starting recover check");
            LinkedHashSet copyOfInProgress = new LinkedHashSet(AggregateProcessor.this.inProgressCompleteExchanges);
            Set exchangeIds = this.recoverable.scan(AggregateProcessor.this.camelContext);
            for (String exchangeId : exchangeIds) {
                if (!AggregateProcessor.this.isRunAllowed()) {
                    LOG.info("We are shutting down so stop recovering");
                    return;
                }
                AggregateProcessor.this.lock.lock();
                try {
                    boolean inProgress;
                    boolean bl = inProgress = copyOfInProgress.contains(exchangeId) || AggregateProcessor.this.inProgressCompleteExchanges.contains(exchangeId);
                    if (inProgress) {
                        LOG.trace("Aggregated exchange with id: {} is already in progress.", (Object)exchangeId);
                        continue;
                    }
                    LOG.debug("Loading aggregated exchange with id: {} to be recovered.", (Object)exchangeId);
                    Exchange exchange = this.recoverable.recover(AggregateProcessor.this.camelContext, exchangeId);
                    if (exchange == null) continue;
                    String key = (String)exchange.getProperty("CamelAggregatedCorrelationKey", String.class);
                    exchange.getIn().setHeader("CamelRedelivered", (Object)Boolean.TRUE);
                    RedeliveryData data = (RedeliveryData)AggregateProcessor.this.redeliveryState.get(exchange.getExchangeId());
                    if (data != null && this.recoverable.getMaximumRedeliveries() > 0 && data.redeliveryCounter >= this.recoverable.getMaximumRedeliveries()) {
                        LOG.warn("The recovered exchange is exhausted after " + this.recoverable.getMaximumRedeliveries() + " attempts, will now be moved to dead letter channel: " + this.recoverable.getDeadLetterUri());
                        try {
                            exchange.getIn().setHeader("CamelRedeliveryCounter", (Object)data.redeliveryCounter);
                            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setRedeliveryExhausted(false);
                            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setRollbackOnly(false);
                            AggregateProcessor.this.deadLetterProducerTemplate.send(this.recoverable.getDeadLetterUri(), exchange);
                        }
                        catch (Throwable e) {
                            exchange.setException(e);
                        }
                        if (exchange.getException() != null) {
                            AggregateProcessor.this.getExceptionHandler().handleException("Failed to move recovered Exchange to dead letter channel: " + this.recoverable.getDeadLetterUri(), (Throwable)exchange.getException());
                            continue;
                        }
                        this.recoverable.confirm(AggregateProcessor.this.camelContext, exchangeId);
                        continue;
                    }
                    if (data == null) {
                        data = new RedeliveryData();
                        AggregateProcessor.this.redeliveryState.put(exchange.getExchangeId(), data);
                    }
                    ++data.redeliveryCounter;
                    exchange.getIn().setHeader("CamelRedeliveryCounter", (Object)data.redeliveryCounter);
                    if (this.recoverable.getMaximumRedeliveries() > 0) {
                        exchange.getIn().setHeader("CamelRedeliveryMaxCounter", (Object)this.recoverable.getMaximumRedeliveries());
                    }
                    LOG.debug("Delivery attempt: {} to recover aggregated exchange with id: {}", (Object)data.redeliveryCounter, (Object)exchangeId);
                    AggregateProcessor.this.onSubmitCompletion(key, exchange);
                }
                finally {
                    AggregateProcessor.this.lock.unlock();
                }
            }
            LOG.trace("Recover check complete");
        }
    }

    private final class AggregationIntervalTask
    implements Runnable {
        private AggregationIntervalTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!AggregateProcessor.this.camelContext.getStatus().isStarted()) {
                LOG.trace("Completion interval task cannot start due CamelContext({}) has not been started yet", (Object)AggregateProcessor.this.camelContext.getName());
                return;
            }
            LOG.trace("Starting completion interval task");
            Set keys = AggregateProcessor.this.aggregationRepository.getKeys();
            if (keys != null && !keys.isEmpty()) {
                AggregateProcessor.this.lock.lock();
                try {
                    for (String key : keys) {
                        boolean stolenInterval = false;
                        Exchange exchange = AggregateProcessor.this.aggregationRepository.get(AggregateProcessor.this.camelContext, key);
                        if (exchange == null) {
                            stolenInterval = true;
                        } else {
                            LOG.trace("Completion interval triggered for correlation key: {}", (Object)key);
                            exchange.setProperty("CamelAggregatedCompletedBy", (Object)AggregateProcessor.COMPLETED_BY_INTERVAL);
                            try {
                                Exchange answer = AggregateProcessor.this.onCompletion(key, exchange, exchange, false, false);
                                if (answer != null) {
                                    AggregateProcessor.this.onSubmitCompletion(key, answer);
                                }
                            }
                            catch (OptimisticLockingAggregationRepository.OptimisticLockingException e) {
                                stolenInterval = true;
                            }
                        }
                        if (!AggregateProcessor.this.optimisticLocking || !stolenInterval) continue;
                        LOG.debug("Another Camel instance has already processed this interval aggregation for exchange with correlation id: {}", (Object)key);
                    }
                }
                finally {
                    AggregateProcessor.this.lock.unlock();
                }
            }
            LOG.trace("Completion interval task complete");
        }
    }

    private final class AggregationTimeoutMap
    extends DefaultTimeoutMap<String, String> {
        private AggregationTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
            super(executor, requestMapPollTimeMillis, AggregateProcessor.this.optimisticLocking);
            this.addListener(this::onEviction);
        }

        protected void purge() {
            if (AggregateProcessor.this.lock != null) {
                AggregateProcessor.this.lock.lock();
                try {
                    super.purge();
                }
                finally {
                    AggregateProcessor.this.lock.unlock();
                }
            }
        }

        private void onEviction(TimeoutMap.Listener.Type type, String key, String exchangeId) {
            if (type != TimeoutMap.Listener.Type.Evict) {
                return;
            }
            this.log.debug("Completion timeout triggered for correlation key: {}", (Object)key);
            boolean inProgress = AggregateProcessor.this.inProgressCompleteExchanges.contains(exchangeId);
            if (inProgress) {
                this.log.trace("Aggregated exchange with id: {} is already in progress.", (Object)exchangeId);
                return;
            }
            boolean evictionStolen = false;
            Exchange answer = AggregateProcessor.this.aggregationRepository.get(AggregateProcessor.this.camelContext, key);
            if (answer == null) {
                evictionStolen = true;
            } else {
                answer.setProperty("CamelAggregatedCompletedBy", (Object)AggregateProcessor.COMPLETED_BY_TIMEOUT);
                try {
                    answer = AggregateProcessor.this.onCompletion(key, answer, answer, true, false);
                    if (answer != null) {
                        AggregateProcessor.this.onSubmitCompletion(key, answer);
                    }
                }
                catch (OptimisticLockingAggregationRepository.OptimisticLockingException e) {
                    evictionStolen = true;
                }
            }
            if (AggregateProcessor.this.optimisticLocking && evictionStolen) {
                this.log.debug("Another Camel instance has already successfully correlated or processed this timeout eviction for exchange with id: {} and correlation id: {}", (Object)exchangeId, (Object)key);
            }
        }
    }

    private final class AggregateOnCompletion
    implements Synchronization {
        private final String exchangeId;

        private AggregateOnCompletion(String exchangeId) {
            this.exchangeId = exchangeId;
        }

        public void onFailure(Exchange exchange) {
            LOG.trace("Aggregated exchange onFailure: {}", (Object)exchange);
            AggregateProcessor.this.inProgressCompleteExchanges.remove(this.exchangeId);
        }

        public void onComplete(Exchange exchange) {
            LOG.trace("Aggregated exchange onComplete: {}", (Object)exchange);
            try {
                AggregateProcessor.this.aggregationRepository.confirm(exchange.getContext(), this.exchangeId);
                AggregateProcessor.this.redeliveryState.remove(this.exchangeId);
            }
            finally {
                AggregateProcessor.this.inProgressCompleteExchanges.remove(this.exchangeId);
            }
        }

        public String toString() {
            return "AggregateOnCompletion";
        }
    }

    private class Statistics
    implements AggregateProcessorStatistics {
        private boolean statisticsEnabled = true;

        private Statistics() {
        }

        @Override
        public long getTotalIn() {
            return AggregateProcessor.this.totalIn.get();
        }

        @Override
        public long getTotalCompleted() {
            return AggregateProcessor.this.totalCompleted.get();
        }

        @Override
        public long getCompletedBySize() {
            return AggregateProcessor.this.completedBySize.get();
        }

        @Override
        public long getCompletedByStrategy() {
            return AggregateProcessor.this.completedByStrategy.get();
        }

        @Override
        public long getCompletedByInterval() {
            return AggregateProcessor.this.completedByInterval.get();
        }

        @Override
        public long getCompletedByTimeout() {
            return AggregateProcessor.this.completedByTimeout.get();
        }

        @Override
        public long getCompletedByPredicate() {
            return AggregateProcessor.this.completedByPredicate.get();
        }

        @Override
        public long getCompletedByBatchConsumer() {
            return AggregateProcessor.this.completedByBatchConsumer.get();
        }

        @Override
        public long getCompletedByForce() {
            return AggregateProcessor.this.completedByForce.get();
        }

        @Override
        public long getDiscarded() {
            return AggregateProcessor.this.discarded.get();
        }

        @Override
        public void reset() {
            AggregateProcessor.this.totalIn.set(0L);
            AggregateProcessor.this.totalCompleted.set(0L);
            AggregateProcessor.this.completedBySize.set(0L);
            AggregateProcessor.this.completedByStrategy.set(0L);
            AggregateProcessor.this.completedByTimeout.set(0L);
            AggregateProcessor.this.completedByPredicate.set(0L);
            AggregateProcessor.this.completedByBatchConsumer.set(0L);
            AggregateProcessor.this.completedByForce.set(0L);
            AggregateProcessor.this.discarded.set(0L);
        }

        @Override
        public boolean isStatisticsEnabled() {
            return this.statisticsEnabled;
        }

        @Override
        public void setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
        }
    }

    private class RedeliveryData {
        int redeliveryCounter;

        private RedeliveryData() {
        }
    }
}

