/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.IfExistsType;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rest.beans.UpdateState;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/artifacts")
public interface ArtifactsResource {
    @GET
    @Produces(value={"application/json"})
    public List<String> listArtifacts();

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public CompletionStage<ArtifactMetaData> createArtifact(@HeaderParam(value="X-Registry-ArtifactType") ArtifactType var1, @HeaderParam(value="X-Registry-ArtifactId") String var2, @DefaultValue(value="FAIL") @QueryParam(value="ifExists") IfExistsType var3, InputStream var4);

    @Path(value="/{artifactId}")
    @GET
    @Produces(value={"application/json", "application/x-protobuf", "application/x-protobuffer", "application/xml", "application/graphql"})
    public Response getLatestArtifact(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public CompletionStage<ArtifactMetaData> updateArtifact(@PathParam(value="artifactId") String var1, @HeaderParam(value="X-Registry-ArtifactType") ArtifactType var2, InputStream var3);

    @Path(value="/{artifactId}")
    @DELETE
    public void deleteArtifact(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}/state")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactState(@PathParam(value="artifactId") String var1, UpdateState var2);

    @Path(value="/{artifactId}/meta")
    @GET
    @Produces(value={"application/json"})
    public ArtifactMetaData getArtifactMetaData(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}/meta")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactMetaData(@PathParam(value="artifactId") String var1, EditableMetaData var2);

    @Path(value="/{artifactId}/meta")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public ArtifactMetaData getArtifactMetaDataByContent(@PathParam(value="artifactId") String var1, InputStream var2);

    @Path(value="/{artifactId}/versions")
    @GET
    @Produces(value={"application/json"})
    public List<Long> listArtifactVersions(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}/versions")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public CompletionStage<VersionMetaData> createArtifactVersion(@PathParam(value="artifactId") String var1, @HeaderParam(value="X-Registry-ArtifactType") ArtifactType var2, InputStream var3);

    @Path(value="/{artifactId}/versions/{version}")
    @GET
    @Produces(value={"application/json", "application/x-protobuf", "application/x-protobuffer", "application/xml", "application/graphql"})
    public Response getArtifactVersion(@PathParam(value="version") Integer var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{artifactId}/versions/{version}/state")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionState(@PathParam(value="version") Integer var1, @PathParam(value="artifactId") String var2, UpdateState var3);

    @Path(value="/{artifactId}/versions/{version}/meta")
    @GET
    @Produces(value={"application/json"})
    public VersionMetaData getArtifactVersionMetaData(@PathParam(value="version") Integer var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{artifactId}/versions/{version}/meta")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionMetaData(@PathParam(value="version") Integer var1, @PathParam(value="artifactId") String var2, EditableMetaData var3);

    @Path(value="/{artifactId}/versions/{version}/meta")
    @DELETE
    public void deleteArtifactVersionMetaData(@PathParam(value="version") Integer var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{artifactId}/rules")
    @GET
    @Produces(value={"application/json"})
    public List<RuleType> listArtifactRules(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}/rules")
    @POST
    @Consumes(value={"application/json"})
    public void createArtifactRule(@PathParam(value="artifactId") String var1, Rule var2);

    @Path(value="/{artifactId}/rules")
    @DELETE
    public void deleteArtifactRules(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}/rules/{rule}")
    @GET
    @Produces(value={"application/json"})
    public Rule getArtifactRuleConfig(@PathParam(value="rule") RuleType var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{artifactId}/rules/{rule}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Rule updateArtifactRuleConfig(@PathParam(value="rule") RuleType var1, @PathParam(value="artifactId") String var2, Rule var3);

    @Path(value="/{artifactId}/rules/{rule}")
    @DELETE
    public void deleteArtifactRule(@PathParam(value="rule") RuleType var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{artifactId}/test")
    @PUT
    @Consumes(value={"*/*"})
    public void testUpdateArtifact(@PathParam(value="artifactId") String var1, @HeaderParam(value="X-Registry-ArtifactType") ArtifactType var2, InputStream var3);
}

