/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeAclsRequestData
implements ApiMessage {
    private byte resourceTypeFilter;
    private String resourceNameFilter;
    private byte patternTypeFilter;
    private String principalFilter;
    private String hostFilter;
    private byte operation;
    private byte permissionType;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("resource_type_filter", Type.INT8, "The resource type."), new Field("resource_name_filter", Type.NULLABLE_STRING, "The resource name, or null to match any resource name."), new Field("principal_filter", Type.NULLABLE_STRING, "The principal to match, or null to match any principal."), new Field("host_filter", Type.NULLABLE_STRING, "The host to match, or null to match any host."), new Field("operation", Type.INT8, "The operation to match."), new Field("permission_type", Type.INT8, "The permission type to match."));
    public static final Schema SCHEMA_1 = new Schema(new Field("resource_type_filter", Type.INT8, "The resource type."), new Field("resource_name_filter", Type.NULLABLE_STRING, "The resource name, or null to match any resource name."), new Field("pattern_type_filter", Type.INT8, "The resource pattern to match."), new Field("principal_filter", Type.NULLABLE_STRING, "The principal to match, or null to match any principal."), new Field("host_filter", Type.NULLABLE_STRING, "The host to match, or null to match any host."), new Field("operation", Type.INT8, "The operation to match."), new Field("permission_type", Type.INT8, "The permission type to match."));
    public static final Schema SCHEMA_2 = new Schema(new Field("resource_type_filter", Type.INT8, "The resource type."), new Field("resource_name_filter", Type.COMPACT_NULLABLE_STRING, "The resource name, or null to match any resource name."), new Field("pattern_type_filter", Type.INT8, "The resource pattern to match."), new Field("principal_filter", Type.COMPACT_NULLABLE_STRING, "The principal to match, or null to match any principal."), new Field("host_filter", Type.COMPACT_NULLABLE_STRING, "The host to match, or null to match any host."), new Field("operation", Type.INT8, "The operation to match."), new Field("permission_type", Type.INT8, "The permission type to match."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

    public DescribeAclsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeAclsRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeAclsRequestData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public DescribeAclsRequestData() {
        this.resourceTypeFilter = 0;
        this.resourceNameFilter = "";
        this.patternTypeFilter = (byte)3;
        this.principalFilter = "";
        this.hostFilter = "";
        this.operation = 0;
        this.permissionType = 0;
    }

    @Override
    public short apiKey() {
        return 29;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.resourceTypeFilter = _readable.readByte();
        int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            this.resourceNameFilter = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceNameFilter had invalid length " + length);
            }
            this.resourceNameFilter = _readable.readString(length);
        }
        this.patternTypeFilter = _version >= 1 ? _readable.readByte() : (byte)3;
        length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            this.principalFilter = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principalFilter had invalid length " + length);
            }
            this.principalFilter = _readable.readString(length);
        }
        length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            this.hostFilter = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field hostFilter had invalid length " + length);
            }
            this.hostFilter = _readable.readString(length);
        }
        this.operation = _readable.readByte();
        this.permissionType = _readable.readByte();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeByte(this.resourceTypeFilter);
        if (this.resourceNameFilter == null) {
            if (_version >= 2) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeShort((short)-1);
            }
        } else {
            _stringBytes = _cache.getSerializedValue(this.resourceNameFilter);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
        }
        if (_version >= 1) {
            _writable.writeByte(this.patternTypeFilter);
        } else if (this.patternTypeFilter != 3) {
            throw new UnsupportedVersionException("Attempted to write a non-default patternTypeFilter at version " + _version);
        }
        if (this.principalFilter == null) {
            if (_version >= 2) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeShort((short)-1);
            }
        } else {
            _stringBytes = _cache.getSerializedValue(this.principalFilter);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
        }
        if (this.hostFilter == null) {
            if (_version >= 2) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeShort((short)-1);
            }
        } else {
            _stringBytes = _cache.getSerializedValue(this.hostFilter);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeByte(this.operation);
        _writable.writeByte(this.permissionType);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.resourceTypeFilter = struct.getByte("resource_type_filter");
        this.resourceNameFilter = struct.getString("resource_name_filter");
        this.patternTypeFilter = _version >= 1 ? struct.getByte("pattern_type_filter") : (byte)3;
        this.principalFilter = struct.getString("principal_filter");
        this.hostFilter = struct.getString("host_filter");
        this.operation = struct.getByte("operation");
        this.permissionType = struct.getByte("permission_type");
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("resource_type_filter", (Object)this.resourceTypeFilter);
        struct.set("resource_name_filter", (Object)this.resourceNameFilter);
        if (_version >= 1) {
            struct.set("pattern_type_filter", (Object)this.patternTypeFilter);
        } else if (this.patternTypeFilter != 3) {
            throw new UnsupportedVersionException("Attempted to write a non-default patternTypeFilter at version " + _version);
        }
        struct.set("principal_filter", (Object)this.principalFilter);
        struct.set("host_filter", (Object)this.hostFilter);
        struct.set("operation", (Object)this.operation);
        struct.set("permission_type", (Object)this.permissionType);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public void fromJson(JsonNode _node, short _version) {
        JsonNode _resourceTypeFilterNode = _node.get("resourceTypeFilter");
        if (_resourceTypeFilterNode == null) {
            throw new RuntimeException("DescribeAclsRequestData: unable to locate field 'resourceTypeFilter', which is mandatory in version " + _version);
        }
        this.resourceTypeFilter = MessageUtil.jsonNodeToByte(_resourceTypeFilterNode, "DescribeAclsRequestData");
        JsonNode _resourceNameFilterNode = _node.get("resourceNameFilter");
        if (_resourceNameFilterNode == null) {
            throw new RuntimeException("DescribeAclsRequestData: unable to locate field 'resourceNameFilter', which is mandatory in version " + _version);
        }
        if (_resourceNameFilterNode.isNull()) {
            this.resourceNameFilter = null;
        } else {
            if (!_resourceNameFilterNode.isTextual()) {
                throw new RuntimeException("DescribeAclsRequestData expected a string type, but got " + _node.getNodeType());
            }
            this.resourceNameFilter = _resourceNameFilterNode.asText();
        }
        JsonNode _patternTypeFilterNode = _node.get("patternTypeFilter");
        if (_patternTypeFilterNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("DescribeAclsRequestData: unable to locate field 'patternTypeFilter', which is mandatory in version " + _version);
            }
            this.patternTypeFilter = (byte)3;
        } else {
            this.patternTypeFilter = MessageUtil.jsonNodeToByte(_patternTypeFilterNode, "DescribeAclsRequestData");
        }
        JsonNode _principalFilterNode = _node.get("principalFilter");
        if (_principalFilterNode == null) {
            throw new RuntimeException("DescribeAclsRequestData: unable to locate field 'principalFilter', which is mandatory in version " + _version);
        }
        if (_principalFilterNode.isNull()) {
            this.principalFilter = null;
        } else {
            if (!_principalFilterNode.isTextual()) {
                throw new RuntimeException("DescribeAclsRequestData expected a string type, but got " + _node.getNodeType());
            }
            this.principalFilter = _principalFilterNode.asText();
        }
        JsonNode _hostFilterNode = _node.get("hostFilter");
        if (_hostFilterNode == null) {
            throw new RuntimeException("DescribeAclsRequestData: unable to locate field 'hostFilter', which is mandatory in version " + _version);
        }
        if (_hostFilterNode.isNull()) {
            this.hostFilter = null;
        } else {
            if (!_hostFilterNode.isTextual()) {
                throw new RuntimeException("DescribeAclsRequestData expected a string type, but got " + _node.getNodeType());
            }
            this.hostFilter = _hostFilterNode.asText();
        }
        JsonNode _operationNode = _node.get("operation");
        if (_operationNode == null) {
            throw new RuntimeException("DescribeAclsRequestData: unable to locate field 'operation', which is mandatory in version " + _version);
        }
        this.operation = MessageUtil.jsonNodeToByte(_operationNode, "DescribeAclsRequestData");
        JsonNode _permissionTypeNode = _node.get("permissionType");
        if (_permissionTypeNode == null) {
            throw new RuntimeException("DescribeAclsRequestData: unable to locate field 'permissionType', which is mandatory in version " + _version);
        }
        this.permissionType = MessageUtil.jsonNodeToByte(_permissionTypeNode, "DescribeAclsRequestData");
    }

    @Override
    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("resourceTypeFilter", (JsonNode)new ShortNode((short)this.resourceTypeFilter));
        if (this.resourceNameFilter == null) {
            _node.set("resourceNameFilter", (JsonNode)NullNode.instance);
        } else {
            _node.set("resourceNameFilter", (JsonNode)new TextNode(this.resourceNameFilter));
        }
        if (_version >= 1) {
            _node.set("patternTypeFilter", (JsonNode)new ShortNode((short)this.patternTypeFilter));
        } else if (this.patternTypeFilter != 3) {
            throw new UnsupportedVersionException("Attempted to write a non-default patternTypeFilter at version " + _version);
        }
        if (this.principalFilter == null) {
            _node.set("principalFilter", (JsonNode)NullNode.instance);
        } else {
            _node.set("principalFilter", (JsonNode)new TextNode(this.principalFilter));
        }
        if (this.hostFilter == null) {
            _node.set("hostFilter", (JsonNode)NullNode.instance);
        } else {
            _node.set("hostFilter", (JsonNode)new TextNode(this.hostFilter));
        }
        _node.set("operation", (JsonNode)new ShortNode((short)this.operation));
        _node.set("permissionType", (JsonNode)new ShortNode((short)this.permissionType));
        return _node;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _size = 0;
        int _numTaggedFields = 0;
        ++_size;
        if (this.resourceNameFilter == null) {
            _size = _version >= 2 ? ++_size : (_size += 2);
        } else {
            _stringBytes = this.resourceNameFilter.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceNameFilter' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceNameFilter, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        }
        if (_version >= 1) {
            ++_size;
        }
        if (this.principalFilter == null) {
            _size = _version >= 2 ? ++_size : (_size += 2);
        } else {
            _stringBytes = this.principalFilter.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principalFilter' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principalFilter, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        }
        if (this.hostFilter == null) {
            _size = _version >= 2 ? ++_size : (_size += 2);
        } else {
            _stringBytes = this.hostFilter.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'hostFilter' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.hostFilter, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        }
        ++_size;
        ++_size;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeAclsRequestData)) {
            return false;
        }
        DescribeAclsRequestData other = (DescribeAclsRequestData)obj;
        if (this.resourceTypeFilter != other.resourceTypeFilter) {
            return false;
        }
        if (this.resourceNameFilter == null ? other.resourceNameFilter != null : !this.resourceNameFilter.equals(other.resourceNameFilter)) {
            return false;
        }
        if (this.patternTypeFilter != other.patternTypeFilter) {
            return false;
        }
        if (this.principalFilter == null ? other.principalFilter != null : !this.principalFilter.equals(other.principalFilter)) {
            return false;
        }
        if (this.hostFilter == null ? other.hostFilter != null : !this.hostFilter.equals(other.hostFilter)) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        return this.permissionType == other.permissionType;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.resourceTypeFilter;
        hashCode = 31 * hashCode + (this.resourceNameFilter == null ? 0 : this.resourceNameFilter.hashCode());
        hashCode = 31 * hashCode + this.patternTypeFilter;
        hashCode = 31 * hashCode + (this.principalFilter == null ? 0 : this.principalFilter.hashCode());
        hashCode = 31 * hashCode + (this.hostFilter == null ? 0 : this.hostFilter.hashCode());
        hashCode = 31 * hashCode + this.operation;
        hashCode = 31 * hashCode + this.permissionType;
        return hashCode;
    }

    @Override
    public DescribeAclsRequestData duplicate() {
        DescribeAclsRequestData _duplicate = new DescribeAclsRequestData();
        _duplicate.resourceTypeFilter = this.resourceTypeFilter;
        _duplicate.resourceNameFilter = this.resourceNameFilter == null ? null : this.resourceNameFilter;
        _duplicate.patternTypeFilter = this.patternTypeFilter;
        _duplicate.principalFilter = this.principalFilter == null ? null : this.principalFilter;
        _duplicate.hostFilter = this.hostFilter == null ? null : this.hostFilter;
        _duplicate.operation = this.operation;
        _duplicate.permissionType = this.permissionType;
        return _duplicate;
    }

    public String toString() {
        return "DescribeAclsRequestData(resourceTypeFilter=" + this.resourceTypeFilter + ", resourceNameFilter=" + (this.resourceNameFilter == null ? "null" : "'" + this.resourceNameFilter.toString() + "'") + ", patternTypeFilter=" + this.patternTypeFilter + ", principalFilter=" + (this.principalFilter == null ? "null" : "'" + this.principalFilter.toString() + "'") + ", hostFilter=" + (this.hostFilter == null ? "null" : "'" + this.hostFilter.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
    }

    public byte resourceTypeFilter() {
        return this.resourceTypeFilter;
    }

    public String resourceNameFilter() {
        return this.resourceNameFilter;
    }

    public byte patternTypeFilter() {
        return this.patternTypeFilter;
    }

    public String principalFilter() {
        return this.principalFilter;
    }

    public String hostFilter() {
        return this.hostFilter;
    }

    public byte operation() {
        return this.operation;
    }

    public byte permissionType() {
        return this.permissionType;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeAclsRequestData setResourceTypeFilter(byte v) {
        this.resourceTypeFilter = v;
        return this;
    }

    public DescribeAclsRequestData setResourceNameFilter(String v) {
        this.resourceNameFilter = v;
        return this;
    }

    public DescribeAclsRequestData setPatternTypeFilter(byte v) {
        this.patternTypeFilter = v;
        return this;
    }

    public DescribeAclsRequestData setPrincipalFilter(String v) {
        this.principalFilter = v;
        return this;
    }

    public DescribeAclsRequestData setHostFilter(String v) {
        this.hostFilter = v;
        return this;
    }

    public DescribeAclsRequestData setOperation(byte v) {
        this.operation = v;
        return this;
    }

    public DescribeAclsRequestData setPermissionType(byte v) {
        this.permissionType = v;
        return this;
    }
}

