/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NoDefaultAndVarargsCheck
implements Check {
    @NotNull
    private static final String description = "should not have varargs or parameters with default values";
    public static final NoDefaultAndVarargsCheck INSTANCE;

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @Override
    public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
            List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"functionDescriptor.valueParameters");
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor it;
                    ValueParameterDescriptor valueParameterDescriptor = it = (ValueParameterDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
                    if (!DescriptorUtilsKt.declaresOrInheritsDefaultValue(valueParameterDescriptor) && it.getVarargElementType() == null) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private NoDefaultAndVarargsCheck() {
    }

    static {
        NoDefaultAndVarargsCheck noDefaultAndVarargsCheck;
        INSTANCE = noDefaultAndVarargsCheck = new NoDefaultAndVarargsCheck();
        description = description;
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }
}

