/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.builders;

import com.googlecode.jsendnsca.Level;
import com.googlecode.jsendnsca.MessagePayload;

public class MessagePayloadBuilder {
    private final MessagePayload payload = this.createMessagePayload();

    public MessagePayload create() {
        return this.payload;
    }

    public MessagePayloadBuilder withLocalHostname() {
        this.payload.useLocalHostname();
        return this;
    }

    public MessagePayloadBuilder withCanonicalHostname() {
        this.payload.setHostname(true);
        return this;
    }

    public MessagePayloadBuilder withHostname(String hostname) {
        this.payload.setHostname(hostname);
        return this;
    }

    public MessagePayloadBuilder withLevel(int level) {
        this.payload.setLevel(Level.toLevel(level));
        return this;
    }

    public MessagePayloadBuilder withLevel(Level level) {
        this.payload.setLevel(level);
        return this;
    }

    public MessagePayloadBuilder withServiceName(String serviceName) {
        this.payload.setServiceName(serviceName);
        return this;
    }

    public MessagePayloadBuilder withMessage(String message) {
        this.payload.setMessage(message);
        return this;
    }

    MessagePayload createMessagePayload() {
        return new MessagePayload(false);
    }
}

