/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.encryption;

import com.googlecode.jsendnsca.encryption.Encryptor;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RijndaelEngine;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESEncryptor
implements Encryptor {
    private final int _keyByteLength;

    public AESEncryptor(int keyByteLength) {
        this._keyByteLength = keyByteLength;
    }

    @Override
    public void encrypt(byte[] passiveCheckBytes, byte[] initVector, String password) {
        RijndaelEngine engine = new RijndaelEngine(this._keyByteLength * 8);
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)engine, 8), (BlockCipherPadding)new ZeroBytePadding());
        try {
            byte[] sessionKey = new byte[this._keyByteLength];
            byte[] passwordBytes = password.getBytes("US-ASCII");
            System.arraycopy(passwordBytes, 0, sessionKey, 0, Math.min(this._keyByteLength, passwordBytes.length));
            byte[] iv = new byte[this._keyByteLength];
            System.arraycopy(initVector, 0, iv, 0, Math.min(this._keyByteLength, initVector.length));
            cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(sessionKey), iv));
            byte[] cipherText = new byte[cipher.getOutputSize(passiveCheckBytes.length)];
            int cipherLength = cipher.processBytes(passiveCheckBytes, 0, passiveCheckBytes.length, cipherText, 0);
            cipherLength += cipher.doFinal(cipherText, cipherLength);
            int bytesToCopy = Math.min(passiveCheckBytes.length, cipherLength);
            System.arraycopy(cipherText, 0, passiveCheckBytes, 0, bytesToCopy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

