/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.utils;

import org.apache.commons.lang.StringUtils;

public class ByteArrayUtils {
    private ByteArrayUtils() {
    }

    public static void writeFixedString(byte[] dest, String value, int offset, int fixedSize) {
        System.arraycopy(ByteArrayUtils.getFixedSizeBytes(fixedSize, value), 0, dest, offset, fixedSize);
    }

    public static void writeShort(byte[] dest, short value, int offset) {
        System.arraycopy(ByteArrayUtils.shortToByteArray(value), 0, dest, offset, 2);
    }

    public static void writeInteger(byte[] dest, int value, int offset) {
        System.arraycopy(ByteArrayUtils.intToByteArray(value), 0, dest, offset, 4);
    }

    public static byte[] getFixedSizeBytes(int fixedSize, String value) {
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank((String)value)) {
            return new byte[fixedSize];
        }
        byte[] myBytes = new byte[fixedSize];
        if (value.length() > fixedSize) {
            value = value.substring(0, fixedSize);
        }
        System.arraycopy(value.getBytes(), 0, myBytes, 0, value.getBytes().length);
        return myBytes;
    }

    private static byte[] intToByteArray(int value) {
        byte[] data = new byte[4];
        for (int i = 0; i < data.length; ++i) {
            int offset = (data.length - 1 - i) * 8;
            data[i] = (byte)(value >>> offset & 0xFF);
        }
        return data;
    }

    private static byte[] shortToByteArray(short value) {
        byte[] data = new byte[2];
        for (int i = 0; i < data.length; ++i) {
            int offset = (data.length - 1 - i) * 8;
            data[i] = (byte)(value >>> offset & 0xFF);
        }
        return data;
    }
}

