/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.encryption;

import com.googlecode.jsendnsca.encryption.Encryptor;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class BlowfishEncryptor
implements Encryptor {
    private static final int KEY_BYTES_LENGTH = 56;

    @Override
    public void encrypt(byte[] passiveCheckBytes, byte[] initVector, String password) {
        BlowfishEngine engine = new BlowfishEngine();
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)engine, 8), (BlockCipherPadding)new ZeroBytePadding());
        try {
            byte[] passwordBytes = password.getBytes("US-ASCII");
            this.assertValidPasswordBytesLength(passwordBytes);
            byte[] sessionKey = new byte[56];
            System.arraycopy(passwordBytes, 0, sessionKey, 0, Math.min(56, passwordBytes.length));
            byte[] iv = new byte[56];
            System.arraycopy(initVector, 0, iv, 0, Math.min(56, initVector.length));
            cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(sessionKey), iv));
            byte[] cipherText = new byte[cipher.getOutputSize(passiveCheckBytes.length)];
            int cipherLength = cipher.processBytes(passiveCheckBytes, 0, passiveCheckBytes.length, cipherText, 0);
            cipherLength += cipher.doFinal(cipherText, cipherLength);
            int bytesToCopy = Math.min(passiveCheckBytes.length, cipherLength);
            System.arraycopy(cipherText, 0, passiveCheckBytes, 0, bytesToCopy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assertValidPasswordBytesLength(byte[] passwordBytes) {
        int passwordBytesLength = passwordBytes.length;
        if (passwordBytesLength > 56) {
            throw new IllegalArgumentException("Key size " + passwordBytesLength + " bytes is longer than the specified key size " + 56 + " bytes");
        }
    }
}

