/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca;

import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosException;
import com.googlecode.jsendnsca.NagiosPassiveCheckSender;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.PassiveCheckSender;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NonBlockingNagiosPassiveCheckSender
implements PassiveCheckSender {
    private final PassiveCheckSender sender;
    private final ExceptionHandler handler;
    private ExecutorService executor;

    public NonBlockingNagiosPassiveCheckSender(NagiosSettings settings) {
        this(new NagiosPassiveCheckSender(settings), (ExceptionHandler)new StandardErrorExceptionHandler());
    }

    public NonBlockingNagiosPassiveCheckSender(NagiosSettings settings, ExceptionHandler handler) {
        this(new NagiosPassiveCheckSender(settings), handler);
    }

    NonBlockingNagiosPassiveCheckSender(PassiveCheckSender sender, ExceptionHandler handler) {
        this.sender = sender;
        this.handler = handler;
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void send(MessagePayload payload) throws NagiosException, IOException {
        this.executor.execute(new NonBlockingSender(payload));
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    private static class StandardErrorExceptionHandler
    implements ExceptionHandler {
        private StandardErrorExceptionHandler() {
        }

        @Override
        public void handleException(Exception e) {
            e.printStackTrace();
        }
    }

    private class NonBlockingSender
    implements Runnable {
        private final MessagePayload payload;

        public NonBlockingSender(MessagePayload payload) {
            this.payload = payload;
        }

        @Override
        public void run() {
            try {
                NonBlockingNagiosPassiveCheckSender.this.sender.send(this.payload);
            }
            catch (Exception e) {
                NonBlockingNagiosPassiveCheckSender.this.handler.handleException(e);
            }
        }
    }

    public static interface ExceptionHandler {
        public void handleException(Exception var1);
    }
}

