/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.rest;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.model.rest.RestBindingDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.processor.RestBindingAdvice;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;

public class RestBindingReifier
extends AbstractReifier {
    private final RestBindingDefinition definition;

    public RestBindingReifier(Route route, RestBindingDefinition definition) {
        super(route);
        this.definition = definition;
    }

    public RestBindingAdvice createRestBindingAdvice() throws Exception {
        RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.camelContext, (String)this.definition.getComponent());
        String mode = config.getBindingMode().name();
        if (this.definition.getBindingMode() != null) {
            mode = this.parse(RestBindingMode.class, this.definition.getBindingMode()).name();
        }
        boolean cors = config.isEnableCORS();
        if (this.definition.getEnableCORS() != null) {
            cors = this.parseBoolean(this.definition.getEnableCORS(), false);
        }
        boolean skip = config.isSkipBindingOnErrorCode();
        if (this.definition.getSkipBindingOnErrorCode() != null) {
            skip = this.parseBoolean(this.definition.getSkipBindingOnErrorCode(), false);
        }
        boolean validation = config.isClientRequestValidation();
        if (this.definition.getClientRequestValidation() != null) {
            validation = this.parseBoolean(this.definition.getClientRequestValidation(), false);
        }
        Map corsHeaders = config.getCorsHeaders();
        if ("off".equals(mode)) {
            return new RestBindingAdvice(this.camelContext, null, null, null, null, this.parseString(this.definition.getConsumes()), this.parseString(this.definition.getProduces()), mode, skip, validation, cors, corsHeaders, this.definition.getDefaultValues(), this.definition.getRequiredBody() != null ? this.definition.getRequiredBody() : false, this.definition.getRequiredQueryParameters(), this.definition.getRequiredHeaders());
        }
        DataFormat json = null;
        DataFormat outJson = null;
        if (mode.contains("json") || "auto".equals(mode)) {
            String name = config.getJsonDataFormat();
            if (name != null) {
                Object instance = this.lookupByName(name);
                if (instance != null) {
                    throw new IllegalArgumentException("JsonDataFormat name: " + name + " must not be an existing bean instance from the registry");
                }
            } else {
                name = "jackson";
            }
            json = this.camelContext.createDataFormat(name);
            outJson = this.camelContext.createDataFormat(name);
            if (json != null) {
                this.setupJson(config, this.parseString(this.definition.getType()), this.definition.getTypeClass(), this.parseString(this.definition.getOutType()), this.definition.getOutTypeClass(), json, outJson);
            }
        }
        DataFormat jaxb = null;
        DataFormat outJaxb = null;
        if (mode.contains("xml") || "auto".equals(mode)) {
            String name = config.getXmlDataFormat();
            if (name != null) {
                Object instance = this.lookupByName(name);
                if (instance != null) {
                    throw new IllegalArgumentException("XmlDataFormat name: " + name + " must not be an existing bean instance from the registry");
                }
            } else {
                name = "jaxb";
            }
            jaxb = this.camelContext.createDataFormat(name);
            outJaxb = this.camelContext.createDataFormat(name);
            if (mode.contains("xml") && jaxb == null) {
                throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
            }
            if (jaxb != null) {
                PluginHelper.getRestBindingJaxbDataFormatFactory((CamelContext)this.camelContext).setupJaxb(this.camelContext, config, this.parseString(this.definition.getType()), this.definition.getTypeClass(), this.parseString(this.definition.getOutType()), this.definition.getOutTypeClass(), jaxb, outJaxb);
            }
        }
        return new RestBindingAdvice(this.camelContext, json, jaxb, outJson, outJaxb, this.parseString(this.definition.getConsumes()), this.parseString(this.definition.getProduces()), mode, skip, validation, cors, corsHeaders, this.definition.getDefaultValues(), this.definition.getRequiredBody() != null ? this.definition.getRequiredBody() : false, this.definition.getRequiredQueryParameters(), this.definition.getRequiredHeaders());
    }

    protected void setupJson(RestConfiguration config, String type, Class<?> typeClass, String outType, Class<?> outTypeClass, DataFormat json, DataFormat outJson) throws Exception {
        Class<Object> clazz = null;
        boolean useList = false;
        if (typeClass != null) {
            useList = typeClass.isArray();
            clazz = useList ? typeClass.getComponentType() : typeClass;
        } else if (type != null) {
            useList = type.endsWith("[]");
            String typeName = useList ? type.substring(0, type.length() - 2) : type;
            clazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
        }
        BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection((CamelContext)this.camelContext);
        if (clazz != null) {
            beanIntrospection.setProperty(this.camelContext, (Object)json, "unmarshalType", clazz);
            beanIntrospection.setProperty(this.camelContext, (Object)json, "useList", (Object)useList);
        }
        this.setAdditionalConfiguration(config, json, "json.in.");
        Class<Object> outClazz = null;
        boolean outUseList = false;
        if (outTypeClass != null) {
            outUseList = outTypeClass.isArray();
            outClazz = outUseList ? outTypeClass.getComponentType() : outTypeClass;
        } else if (outType != null) {
            outUseList = outType.endsWith("[]");
            String typeName = outUseList ? outType.substring(0, outType.length() - 2) : outType;
            outClazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
        }
        if (outClazz != null) {
            beanIntrospection.setProperty(this.camelContext, (Object)outJson, "unmarshalType", outClazz);
            beanIntrospection.setProperty(this.camelContext, (Object)outJson, "useList", (Object)outUseList);
        }
        this.setAdditionalConfiguration(config, outJson, "json.out.");
    }

    private void setAdditionalConfiguration(RestConfiguration config, DataFormat dataFormat, String prefix) throws Exception {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap copy = new HashMap();
            for (Map.Entry entry : config.getDataFormatProperties().entrySet()) {
                String key = (String)entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            PropertyBindingSupport.build().bind(this.camelContext, (Object)dataFormat, copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }
}

