/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.SingleInputLanguageSupport;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.ObjectHelper;

@Language(value="tokenize")
public class TokenizeLanguage
extends SingleInputLanguageSupport
implements PropertyConfigurer {
    private String token;
    private String endToken;
    private String inheritNamespaceTagName;
    private boolean regex;
    private boolean xml;
    private boolean includeTokens;
    private String group;
    private String groupDelimiter;
    private boolean skipFirst;

    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "token": {
                this.setToken((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "endtoken": 
            case "endToken": {
                this.setEndToken((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "inheritnamespacetagname": 
            case "inheritNamespaceTagName": {
                this.setInheritNamespaceTagName((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "headername": 
            case "headerName": {
                this.setHeaderName((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "propertyname": 
            case "propertyName": {
                this.setPropertyName((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "regex": {
                this.setRegex((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "xml": {
                this.setXml((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "includetokens": 
            case "includeTokens": {
                this.setIncludeTokens((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "group": {
                this.setGroup((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "groupdelimiter": 
            case "groupDelimiter": {
                this.setGroupDelimiter((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "skipfirst": 
            case "skipFirst": {
                this.setSkipFirst((Boolean)PropertyConfigurerSupport.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression() {
        ObjectHelper.notNull((Object)this.token, (String)"token");
        if (this.endToken != null && this.inheritNamespaceTagName != null) {
            throw new IllegalArgumentException("Cannot have both xml and pair tokenizer enabled.");
        }
        if (this.isXml() && (this.endToken != null || this.includeTokens)) {
            throw new IllegalArgumentException("Cannot have both xml and pair tokenizer enabled.");
        }
        if (this.endToken == null && this.includeTokens) {
            throw new IllegalArgumentException("The option includeTokens requires endToken to be specified.");
        }
        Expression answer = null;
        if (this.isXml()) {
            answer = ExpressionBuilder.tokenizeXMLExpression((String)this.token, (String)this.inheritNamespaceTagName);
        } else if (this.endToken != null) {
            answer = ExpressionBuilder.tokenizePairExpression((String)this.token, (String)this.endToken, (boolean)this.includeTokens);
        }
        if (answer == null) {
            Expression exp = ExpressionBuilder.singleInputExpression((String)this.getHeaderName(), (String)this.getPropertyName());
            answer = this.regex ? ExpressionBuilder.regexTokenizeExpression((Expression)exp, (String)this.token) : ExpressionBuilder.tokenizeExpression((Expression)exp, (String)this.token);
            if (this.group == null && this.skipFirst) {
                answer = ExpressionBuilder.skipFirstExpression((Expression)answer);
            }
        }
        if (this.group != null) {
            if (this.isXml()) {
                answer = ExpressionBuilder.groupXmlIteratorExpression((Expression)answer, (String)this.group);
            } else {
                String delim = this.groupDelimiter != null ? this.groupDelimiter : this.token;
                answer = ExpressionBuilder.groupIteratorExpression((Expression)answer, (String)delim, (String)this.group, (boolean)this.skipFirst);
            }
        }
        if (this.getCamelContext() != null) {
            answer.init(this.getCamelContext());
        }
        return answer;
    }

    public Expression createExpression(String expression) {
        if (ObjectHelper.isNotEmpty((String)expression)) {
            this.token = expression;
        }
        return this.createExpression();
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression, properties));
    }

    public Expression createExpression(String expression, Object[] properties) {
        TokenizeLanguage answer = new TokenizeLanguage();
        answer.setToken((String)this.property(String.class, properties, 0, this.token));
        answer.setEndToken((String)this.property(String.class, properties, 1, this.endToken));
        answer.setInheritNamespaceTagName((String)this.property(String.class, properties, 2, this.inheritNamespaceTagName));
        answer.setHeaderName((String)this.property(String.class, properties, 3, this.getHeaderName()));
        answer.setGroupDelimiter((String)this.property(String.class, properties, 4, this.groupDelimiter));
        answer.setRegex((Boolean)this.property(Boolean.TYPE, properties, 5, this.regex));
        answer.setXml((Boolean)this.property(Boolean.TYPE, properties, 6, this.xml));
        answer.setIncludeTokens((Boolean)this.property(Boolean.TYPE, properties, 7, this.includeTokens));
        answer.setGroup((String)this.property(String.class, properties, 8, this.group));
        answer.setSkipFirst((Boolean)this.property(Boolean.TYPE, properties, 9, this.skipFirst));
        answer.setPropertyName((String)this.property(String.class, properties, 10, this.getPropertyName()));
        return answer.createExpression(expression);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public String getInheritNamespaceTagName() {
        return this.inheritNamespaceTagName;
    }

    public void setInheritNamespaceTagName(String inheritNamespaceTagName) {
        this.inheritNamespaceTagName = inheritNamespaceTagName;
    }

    public boolean isXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public boolean isIncludeTokens() {
        return this.includeTokens;
    }

    public void setIncludeTokens(boolean includeTokens) {
        this.includeTokens = includeTokens;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = "0".equals(group) ? null : group;
    }

    public String getGroupDelimiter() {
        return this.groupDelimiter;
    }

    public void setGroupDelimiter(String groupDelimiter) {
        this.groupDelimiter = groupDelimiter;
    }

    public boolean isSkipFirst() {
        return this.skipFirst;
    }

    public void setSkipFirst(boolean skipFirst) {
        this.skipFirst = skipFirst;
    }
}

