/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.converter.json.FormatStrategy;
import io.apicurio.registry.utils.converter.json.PrettyFormatStrategy;
import io.apicurio.registry.utils.serde.AbstractKafkaStrategyAwareSerDe;
import io.apicurio.registry.utils.serde.SchemaCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.storage.Converter;

public class ExtJsonConverter
extends AbstractKafkaStrategyAwareSerDe<String, ExtJsonConverter>
implements Converter {
    private final JsonConverter jsonConverter = new JsonConverter();
    private final ObjectMapper mapper = new ObjectMapper();
    private FormatStrategy formatStrategy = new PrettyFormatStrategy();
    private SchemaCache<JsonNode> cache;

    public ExtJsonConverter() {
        this(null);
    }

    public ExtJsonConverter(RegistryService client) {
        super(client);
    }

    public ExtJsonConverter setFormatStrategy(FormatStrategy formatStrategy) {
        this.formatStrategy = Objects.requireNonNull(formatStrategy);
        return (ExtJsonConverter)this.self();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
        HashMap wrapper = new HashMap(configs);
        wrapper.put("schemas.enable", false);
        this.jsonConverter.configure(wrapper, isKey);
    }

    private synchronized SchemaCache<JsonNode> getCache() {
        if (this.cache == null) {
            this.cache = new SchemaCache<JsonNode>(this.getClient()){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected JsonNode toSchema(Response response) {
                    try {
                        Object responseEntity = response.getEntity();
                        if (responseEntity instanceof InputStream) {
                            return ExtJsonConverter.this.mapper.readTree((InputStream)responseEntity);
                        }
                        try (InputStream stream = (InputStream)response.readEntity(InputStream.class);){
                            JsonNode jsonNode = ExtJsonConverter.this.mapper.readTree(stream);
                            return jsonNode;
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }
        return this.cache;
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        String schemaString = this.jsonConverter.asJsonSchema(schema).toString();
        String artifactId = this.getArtifactIdStrategy().artifactId(topic, this.isKey(), (Object)schemaString);
        long globalId = this.getGlobalIdStrategy().findId(this.getClient(), artifactId, ArtifactType.KCONNECT, (Object)schemaString);
        byte[] payload = this.jsonConverter.fromConnectData(topic, schema, value);
        return this.formatStrategy.fromConnectData(globalId, payload);
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        FormatStrategy.IdPayload ip = this.formatStrategy.toConnectData(value);
        long globalId = ip.getGlobalId();
        JsonNode schemaNode = (JsonNode)this.getCache().getSchema(globalId);
        Schema schema = this.jsonConverter.asConnectSchema(schemaNode);
        byte[] payload = ip.getPayload();
        SchemaAndValue sav = this.jsonConverter.toConnectData(topic, payload);
        return new SchemaAndValue(schema, sav.value());
    }
}

