/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.apache.camel.kafkaconnector.mqtt5source;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelMqtt5sourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_TOPIC_CONF = "camel.kamelet.mqtt5-source.topic";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_TOPIC_DOC = "The topic to subscribe to Example: mytopic";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_BROKER_URL_CONF = "camel.kamelet.mqtt5-source.brokerUrl";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_BROKER_URL_DOC = "The URL of the broker where to establish the connection Example: tcp://mosquitto:1883";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_BROKER_URL_DEFAULT = null;
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_CLIENT_ID_CONF = "camel.kamelet.mqtt5-source.clientId";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_CLIENT_ID_DOC = "The client ID to use when connecting to the resource";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_CLIENT_ID_DEFAULT = "mqtt-source";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_USERNAME_CONF = "camel.kamelet.mqtt5-source.username";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_USERNAME_DOC = "Username to use when connecting to the MQTT v5 compliant broker";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_PASSWORD_CONF = "camel.kamelet.mqtt5-source.password";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_PASSWORD_DOC = "Password to use when connecting to the MQTT v5 compliant broker";
    public static final String CAMEL_SOURCE_MQTT5SOURCE_KAMELET_PASSWORD_DEFAULT = null;

    public CamelMqtt5sourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelMqtt5sourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_MQTT5SOURCE_KAMELET_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MQTT5SOURCE_KAMELET_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MQTT5SOURCE_KAMELET_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_MQTT5SOURCE_KAMELET_BROKER_URL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MQTT5SOURCE_KAMELET_BROKER_URL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MQTT5SOURCE_KAMELET_BROKER_URL_DOC);
        conf.define(CAMEL_SOURCE_MQTT5SOURCE_KAMELET_CLIENT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MQTT5SOURCE_KAMELET_CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MQTT5SOURCE_KAMELET_CLIENT_ID_DOC);
        conf.define(CAMEL_SOURCE_MQTT5SOURCE_KAMELET_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MQTT5SOURCE_KAMELET_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MQTT5SOURCE_KAMELET_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_MQTT5SOURCE_KAMELET_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_MQTT5SOURCE_KAMELET_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MQTT5SOURCE_KAMELET_PASSWORD_DOC);
        return conf;
    }
}