/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(firstVersion="1.3.0", label="language,core,java", title="Bean method")
@XmlRootElement(name="method")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MethodCallExpression
extends ExpressionDefinition {
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String method;
    @XmlAttribute(name="beanType")
    private String beanTypeName;
    @XmlAttribute
    @Metadata(defaultValue="Singleton", enums="Singleton,Request,Prototype")
    private String scope;
    @XmlTransient
    private Class<?> beanType;
    @XmlTransient
    private Object instance;

    public MethodCallExpression() {
    }

    public MethodCallExpression(String beanName) {
        this(beanName, null);
    }

    public MethodCallExpression(String beanName, String method) {
        super("");
        if (beanName != null && beanName.startsWith("ref:")) {
            beanName = beanName.substring(4);
        } else if (beanName != null && beanName.startsWith("bean:")) {
            beanName = beanName.substring(5);
        }
        this.setRef(beanName);
        this.setMethod(method);
    }

    public MethodCallExpression(Object instance) {
        this(instance, null);
    }

    public MethodCallExpression(Object instance, String method) {
        super("");
        this.setInstance(instance);
        this.setMethod(method);
    }

    public MethodCallExpression(Class<?> type) {
        this(type, null);
    }

    public MethodCallExpression(Class<?> type, String method) {
        super("");
        this.setBeanType(type);
        this.setBeanTypeName(type.getName());
        this.setMethod(method);
    }

    @Override
    public String getLanguage() {
        return "bean";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanType = beanType;
        this.instance = null;
    }

    public String getBeanTypeName() {
        return this.beanTypeName;
    }

    public void setBeanTypeName(String beanTypeName) {
        this.beanTypeName = beanTypeName;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        if (instance instanceof Class) {
            this.beanType = (Class)instance;
            this.instance = null;
        } else {
            this.beanType = null;
            this.instance = instance;
        }
    }

    private String beanName() {
        if (this.ref != null) {
            return this.ref;
        }
        if (this.instance != null) {
            return ObjectHelper.className((Object)this.instance);
        }
        return this.getExpression();
    }

    @Override
    public String toString() {
        boolean isRef = this.ref != null;
        return "bean[" + (isRef ? "ref:" : "") + this.beanName() + (this.method != null ? " method:" + this.method : "") + "]";
    }
}

