/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.api;

import com.worldturner.medeia.api.InputPreference;
import com.worldturner.medeia.api.InputSource;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/worldturner/medeia/api/PathInputSource;", "Lcom/worldturner/medeia/api/InputSource;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "name", "", "getName", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "preference", "Lcom/worldturner/medeia/api/InputPreference;", "getPreference", "()Lcom/worldturner/medeia/api/InputPreference;", "stream", "Ljava/io/InputStream;", "getStream", "()Ljava/io/InputStream;", "toString", "medeia-validator-core"})
public final class PathInputSource
implements InputSource {
    @NotNull
    private final String name;
    @NotNull
    private final Path path;

    @Override
    @NotNull
    public InputPreference getPreference() {
        return InputPreference.STREAM;
    }

    @Override
    @NotNull
    public InputStream getStream() {
        InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(path)");
        return inputStream;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String toString() {
        return "PathInputSource(" + this.path + ')';
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public PathInputSource(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.path = path;
        this.name = ((Object)this.path).toString();
    }

    @Override
    @NotNull
    public Reader getReader() {
        return InputSource.DefaultImpls.getReader(this);
    }
}

