/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client;

import io.apicurio.registry.client.RegistryRestClient;
import io.apicurio.registry.client.RegistryRestClientFactory;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.beans.EditableMetaData;
import io.apicurio.registry.rest.beans.IfExistsType;
import io.apicurio.registry.rest.beans.Rule;
import io.apicurio.registry.rest.beans.SearchOver;
import io.apicurio.registry.rest.beans.SortOrder;
import io.apicurio.registry.rest.beans.UpdateState;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.rest.beans.VersionSearchResults;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.inject.Vetoed;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Vetoed
@Path(value="__dummy_hack_apicurio")
public class CompatibleClient
implements RegistryService {
    private final RegistryRestClient delegate;

    public CompatibleClient() {
        this.delegate = null;
    }

    private CompatibleClient(String baseUrl) {
        this.delegate = RegistryRestClientFactory.create(baseUrl);
    }

    private CompatibleClient(String baseUrl, Map<String, Object> configs) {
        this.delegate = RegistryRestClientFactory.create(baseUrl, configs);
    }

    public static RegistryService createCompatible(String baseUrl) {
        return new CompatibleClient(baseUrl);
    }

    public static RegistryService createCompatible(String baseUrl, Map<String, Object> configs) {
        return new CompatibleClient(baseUrl, configs);
    }

    public List<String> listArtifacts() {
        return this.delegate.listArtifacts();
    }

    public CompletionStage<ArtifactMetaData> createArtifact(ArtifactType xRegistryArtifactType, String xRegistryArtifactId, IfExistsType ifExists, InputStream data) {
        return CompletableFuture.completedFuture(this.delegate.createArtifact(xRegistryArtifactId, xRegistryArtifactType, ifExists, data));
    }

    public Response getLatestArtifact(String artifactId) {
        return this.parseResponse(this.delegate.getLatestArtifact(artifactId));
    }

    public CompletionStage<ArtifactMetaData> updateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        return CompletableFuture.completedFuture(this.delegate.updateArtifact(artifactId, xRegistryArtifactType, data));
    }

    public void deleteArtifact(String artifactId) {
        this.delegate.deleteArtifact(artifactId);
    }

    public void updateArtifactState(String artifactId, UpdateState data) {
        this.delegate.updateArtifactState(artifactId, data);
    }

    public ArtifactMetaData getArtifactMetaData(String artifactId) {
        return this.delegate.getArtifactMetaData(artifactId);
    }

    public void updateArtifactMetaData(String artifactId, EditableMetaData data) {
        this.delegate.updateArtifactMetaData(artifactId, data);
    }

    public ArtifactMetaData getArtifactMetaDataByContent(String artifactId, InputStream data) {
        return this.delegate.getArtifactMetaDataByContent(artifactId, data);
    }

    public List<Long> listArtifactVersions(String artifactId) {
        return this.delegate.listArtifactVersions(artifactId);
    }

    public CompletionStage<VersionMetaData> createArtifactVersion(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        return CompletableFuture.completedFuture(this.delegate.createArtifactVersion(artifactId, xRegistryArtifactType, data));
    }

    public Response getArtifactVersion(Integer version, String artifactId) {
        return this.parseResponse(this.delegate.getArtifactVersion(artifactId, version));
    }

    public void updateArtifactVersionState(Integer version, String artifactId, UpdateState data) {
        this.delegate.updateArtifactVersionState(artifactId, version, data);
    }

    public VersionMetaData getArtifactVersionMetaData(Integer version, String artifactId) {
        return this.delegate.getArtifactVersionMetaData(artifactId, version);
    }

    public void updateArtifactVersionMetaData(Integer version, String artifactId, EditableMetaData data) {
        this.delegate.updateArtifactVersionMetaData(artifactId, version, data);
    }

    public void deleteArtifactVersionMetaData(Integer version, String artifactId) {
        this.delegate.deleteArtifactVersionMetaData(artifactId, version);
    }

    public List<RuleType> listArtifactRules(String artifactId) {
        return this.delegate.listArtifactRules(artifactId);
    }

    public void createArtifactRule(String artifactId, Rule data) {
        this.delegate.createArtifactRule(artifactId, data);
    }

    public void deleteArtifactRules(String artifactId) {
        this.delegate.deleteArtifactRules(artifactId);
    }

    public Rule getArtifactRuleConfig(RuleType rule, String artifactId) {
        return this.delegate.getArtifactRuleConfig(artifactId, rule);
    }

    public Rule updateArtifactRuleConfig(RuleType rule, String artifactId, Rule data) {
        return this.delegate.updateArtifactRuleConfig(artifactId, rule, data);
    }

    public void deleteArtifactRule(RuleType rule, String artifactId) {
        this.delegate.deleteArtifactRule(artifactId, rule);
    }

    public void testUpdateArtifact(String artifactId, ArtifactType xRegistryArtifactType, InputStream data) {
        this.delegate.testUpdateArtifact(artifactId, xRegistryArtifactType, data);
    }

    public Response getArtifactByGlobalId(long globalId) {
        return this.parseResponse(this.delegate.getArtifactByGlobalId(globalId));
    }

    public ArtifactMetaData getArtifactMetaDataByGlobalId(long globalId) {
        return this.delegate.getArtifactMetaDataByGlobalId(globalId);
    }

    public Rule getGlobalRuleConfig(RuleType rule) {
        return this.delegate.getGlobalRuleConfig(rule);
    }

    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        return this.delegate.updateGlobalRuleConfig(rule, data);
    }

    public void deleteGlobalRule(RuleType rule) {
        this.delegate.deleteGlobalRule(rule);
    }

    public List<RuleType> listGlobalRules() {
        return this.delegate.listGlobalRules();
    }

    public void createGlobalRule(Rule data) {
        this.delegate.createGlobalRule(data);
    }

    public void deleteAllGlobalRules() {
        this.delegate.deleteAllGlobalRules();
    }

    public ArtifactSearchResults searchArtifacts(String search, Integer offset, Integer limit, SearchOver over, SortOrder order) {
        return this.delegate.searchArtifacts(search, over, order, offset, limit);
    }

    public VersionSearchResults searchVersions(String artifactId, Integer offset, Integer limit) {
        return this.delegate.searchVersions(artifactId, offset, limit);
    }

    public void close() throws Exception {
    }

    public void reset() {
    }

    private Response parseResponse(InputStream resultStream) {
        return Response.ok((Object)resultStream).build();
    }
}

