/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class MllpProtocolConstants {
    public static final char START_OF_BLOCK = '\u000b';
    public static final char END_OF_BLOCK = '\u001c';
    public static final char END_OF_DATA = '\r';
    public static final int END_OF_STREAM = -1;
    public static final char SEGMENT_DELIMITER = '\r';
    public static final char MESSAGE_TERMINATOR = '\n';
    public static final byte[] PAYLOAD_TERMINATOR = new byte[2];
    public static final Map<String, Charset> MSH18_VALUES;

    private MllpProtocolConstants() {
    }

    static {
        MllpProtocolConstants.PAYLOAD_TERMINATOR[0] = 28;
        MllpProtocolConstants.PAYLOAD_TERMINATOR[1] = 13;
        MSH18_VALUES = new HashMap<String, Charset>(15);
        MSH18_VALUES.put("ASCII", StandardCharsets.US_ASCII);
        MSH18_VALUES.put("8859/1", StandardCharsets.ISO_8859_1);
        MSH18_VALUES.put("8859/2", Charset.forName("ISO-8859-2"));
        MSH18_VALUES.put("8859/3", Charset.forName("ISO-8859-3"));
        MSH18_VALUES.put("8859/4", Charset.forName("ISO-8859-4"));
        MSH18_VALUES.put("8859/5", Charset.forName("ISO-8859-5"));
        MSH18_VALUES.put("8859/6", Charset.forName("ISO-8859-6"));
        MSH18_VALUES.put("8859/7", Charset.forName("ISO-8859-7"));
        MSH18_VALUES.put("8859/8", Charset.forName("ISO-8859-8"));
        MSH18_VALUES.put("8859/9", Charset.forName("ISO-8859-9"));
    }
}

