/*
 * Decompiled with CFR 0.152.
 */
package io.minio.http;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.minio.org.apache.commons.validator.routines.InetAddressValidator;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

public class HttpUtils {
    public static final byte[] EMPTY_BODY = new byte[0];

    public static void validateNotNull(Object arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException(argName + " must not be null.");
        }
    }

    public static void validateNotEmptyString(String arg, String argName) {
        HttpUtils.validateNotNull(arg, argName);
        if (arg.isEmpty()) {
            throw new IllegalArgumentException(argName + " must be a non-empty string.");
        }
    }

    public static void validateNullOrNotEmptyString(String arg, String argName) {
        if (arg != null && arg.isEmpty()) {
            throw new IllegalArgumentException(argName + " must be a non-empty string.");
        }
    }

    public static void validateHostnameOrIPAddress(String endpoint) {
        if (InetAddressValidator.getInstance().isValid(endpoint)) {
            return;
        }
        if (endpoint.length() < 1 || endpoint.length() > 253) {
            throw new IllegalArgumentException("invalid hostname");
        }
        for (String label : endpoint.split("\\.")) {
            if (label.length() < 1 || label.length() > 63) {
                throw new IllegalArgumentException("invalid hostname");
            }
            if (label.matches("^[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?$")) continue;
            throw new IllegalArgumentException("invalid hostname");
        }
    }

    public static void validateUrl(HttpUrl url) {
        if (!url.encodedPath().equals("/")) {
            throw new IllegalArgumentException("no path allowed in endpoint " + url);
        }
    }

    public static HttpUrl getBaseUrl(String endpoint) {
        HttpUtils.validateNotEmptyString(endpoint, "endpoint");
        HttpUrl url = HttpUrl.parse((String)endpoint);
        if (url == null) {
            HttpUtils.validateHostnameOrIPAddress(endpoint);
            url = new HttpUrl.Builder().scheme("https").host(endpoint).build();
        } else {
            HttpUtils.validateUrl(url);
        }
        return url;
    }

    public static String getHostHeader(HttpUrl url) {
        String host = url.host();
        if (InetAddressValidator.getInstance().isValidInet6Address(host)) {
            host = "[" + host + "]";
        }
        if (url.scheme().equals("http") && url.port() == 80 || url.scheme().equals("https") && url.port() == 443) {
            return host;
        }
        return host + ":" + url.port();
    }

    private static OkHttpClient enableJKSPKCS12Certificates(OkHttpClient httpClient, String trustStorePath, String trustStorePassword, String keyStorePath, String keyStorePassword, String keyStoreType) throws GeneralSecurityException, IOException {
        if (trustStorePath == null || trustStorePath.isEmpty()) {
            throw new IllegalArgumentException("trust store path must be provided");
        }
        if (trustStorePassword == null) {
            throw new IllegalArgumentException("trust store password must be provided");
        }
        if (keyStorePath == null || keyStorePath.isEmpty()) {
            throw new IllegalArgumentException("key store path must be provided");
        }
        if (keyStorePassword == null) {
            throw new IllegalArgumentException("key store password must be provided");
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyStore trustStore = KeyStore.getInstance("JKS");
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        try (FileInputStream trustInput = new FileInputStream(trustStorePath);
             FileInputStream keyInput = new FileInputStream(keyStorePath);){
            trustStore.load(trustInput, trustStorePassword.toCharArray());
            keyStore.load(keyInput, keyStorePassword.toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return httpClient.newBuilder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagerFactory.getTrustManagers()[0]).build();
    }

    public static OkHttpClient enableJKSCertificates(OkHttpClient httpClient, String trustStorePath, String trustStorePassword, String keyStorePath, String keyStorePassword) throws GeneralSecurityException, IOException {
        return HttpUtils.enableJKSPKCS12Certificates(httpClient, trustStorePath, trustStorePassword, keyStorePath, keyStorePassword, "JKS");
    }

    public static OkHttpClient enablePKCS12Certificates(OkHttpClient httpClient, String trustStorePath, String trustStorePassword, String keyStorePath, String keyStorePassword) throws GeneralSecurityException, IOException {
        return HttpUtils.enableJKSPKCS12Certificates(httpClient, trustStorePath, trustStorePassword, keyStorePath, keyStorePassword, "PKCS12");
    }

    public static OkHttpClient enableExternalCertificates(OkHttpClient httpClient, String filename) throws GeneralSecurityException, IOException {
        Collection<? extends Certificate> certificates = null;
        try (FileInputStream fis = new FileInputStream(filename);){
            certificates = CertificateFactory.getInstance("X.509").generateCertificates(fis);
        }
        if (certificates == null || certificates.isEmpty()) {
            throw new IllegalArgumentException("expected non-empty set of trusted certificates");
        }
        char[] password = "password".toCharArray();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, password);
        int index = 0;
        for (Certificate certificate : certificates) {
            String certificateAlias = Integer.toString(index++);
            keyStore.setCertificateEntry(certificateAlias, certificate);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        return httpClient.newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManagers[0]).build();
    }

    public static OkHttpClient newDefaultHttpClient(long connectTimeout, long writeTimeout, long readTimeout) {
        OkHttpClient httpClient = new OkHttpClient().newBuilder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).writeTimeout(writeTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).protocols(Arrays.asList(Protocol.HTTP_1_1)).build();
        String filename = System.getenv("SSL_CERT_FILE");
        if (filename != null && !filename.isEmpty()) {
            try {
                httpClient = HttpUtils.enableExternalCertificates(httpClient, filename);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return httpClient;
    }

    @SuppressFBWarnings(value={"SIC"}, justification="Should not be used in production anyways.")
    public static OkHttpClient disableCertCheck(OkHttpClient client) throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        return client.newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
    }

    public static OkHttpClient setTimeout(OkHttpClient client, long connectTimeout, long writeTimeout, long readTimeout) {
        return client.newBuilder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).writeTimeout(writeTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).build();
    }
}

