/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.errorhandler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.Navigate;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.PooledExchangeTask;
import org.apache.camel.processor.PooledExchangeTaskFactory;
import org.apache.camel.processor.PooledTaskFactory;
import org.apache.camel.processor.PrototypeTaskFactory;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.processor.errorhandler.ExceptionPolicy;
import org.apache.camel.processor.errorhandler.ExceptionPolicyStrategy;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ErrorHandlerRedeliveryCustomizer;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedeliveryErrorHandler
extends ErrorHandlerSupport
implements ErrorHandlerRedeliveryCustomizer,
AsyncProcessor,
ShutdownPrepared,
Navigate<Processor> {
    private static final Logger LOG = LoggerFactory.getLogger(RedeliveryErrorHandler.class);
    protected PooledExchangeTaskFactory taskFactory;
    protected final AtomicInteger redeliverySleepCounter = new AtomicInteger();
    protected ScheduledExecutorService executorService;
    protected volatile boolean preparingShutdown;
    protected Processor output;
    protected AsyncProcessor outputAsync;
    protected final ExtendedCamelContext camelContext;
    protected final ReactiveExecutor reactiveExecutor;
    protected final AsyncProcessorAwaitManager awaitManager;
    protected final ShutdownStrategy shutdownStrategy;
    protected final Processor deadLetter;
    protected final String deadLetterUri;
    protected final boolean deadLetterHandleNewException;
    protected final Processor redeliveryProcessor;
    protected final RedeliveryPolicy redeliveryPolicy;
    protected final Predicate retryWhilePolicy;
    protected final CamelLogger logger;
    protected final boolean useOriginalMessagePolicy;
    protected final boolean useOriginalBodyPolicy;
    protected boolean redeliveryEnabled;
    protected boolean simpleTask;
    protected final ExchangeFormatter exchangeFormatter;
    protected final boolean customExchangeFormatter;
    protected final Processor onPrepareProcessor;
    protected final Processor onExceptionProcessor;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RedeliveryErrorHandler(CamelContext camelContext, Processor output, CamelLogger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, Processor deadLetter, String deadLetterUri, boolean deadLetterHandleNewException, boolean useOriginalMessagePolicy, boolean useOriginalBodyPolicy, Predicate retryWhile, ScheduledExecutorService executorService, Processor onPrepareProcessor, Processor onExceptionProcessor) {
        ObjectHelper.notNull((Object)camelContext, (String)"CamelContext", (Object)((Object)this));
        ObjectHelper.notNull((Object)redeliveryPolicy, (String)"RedeliveryPolicy", (Object)((Object)this));
        this.camelContext = (ExtendedCamelContext)camelContext;
        this.reactiveExecutor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getReactiveExecutor();
        this.awaitManager = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getAsyncProcessorAwaitManager();
        this.shutdownStrategy = camelContext.getShutdownStrategy();
        this.redeliveryProcessor = redeliveryProcessor;
        this.deadLetter = deadLetter;
        this.output = output;
        this.outputAsync = AsyncProcessorConverterHelper.convert((Processor)output);
        this.redeliveryPolicy = redeliveryPolicy;
        this.logger = logger;
        this.deadLetterUri = deadLetterUri;
        this.deadLetterHandleNewException = deadLetterHandleNewException;
        this.useOriginalMessagePolicy = useOriginalMessagePolicy;
        this.useOriginalBodyPolicy = useOriginalBodyPolicy;
        this.retryWhilePolicy = retryWhile;
        this.executorService = executorService;
        this.onPrepareProcessor = onPrepareProcessor;
        this.onExceptionProcessor = onExceptionProcessor;
        if (ObjectHelper.isNotEmpty((String)redeliveryPolicy.getExchangeFormatterRef())) {
            ExchangeFormatter formatter = (ExchangeFormatter)camelContext.getRegistry().lookupByNameAndType(redeliveryPolicy.getExchangeFormatterRef(), ExchangeFormatter.class);
            if (formatter == null) throw new IllegalArgumentException("Cannot find the exchangeFormatter by using reference id " + redeliveryPolicy.getExchangeFormatterRef());
            this.exchangeFormatter = formatter;
            this.customExchangeFormatter = true;
        } else {
            this.customExchangeFormatter = false;
            this.exchangeFormatter = DEFAULT_EXCHANGE_FORMATTER;
            try {
                Integer maxChars = CamelContextHelper.parseInteger((CamelContext)camelContext, (String)camelContext.getGlobalOption("CamelLogDebugBodyMaxChars"));
                if (maxChars != null) {
                    DEFAULT_EXCHANGE_FORMATTER.setMaxChars(maxChars.intValue());
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        ExceptionPolicyStrategy customExceptionPolicy = (ExceptionPolicyStrategy)CamelContextHelper.findSingleByType((CamelContext)camelContext, ExceptionPolicyStrategy.class);
        if (customExceptionPolicy == null) return;
        this.exceptionPolicy = customExceptionPolicy;
    }

    RedeliveryErrorHandler(Logger log) {
        this.camelContext = null;
        this.reactiveExecutor = null;
        this.awaitManager = null;
        this.shutdownStrategy = null;
        this.deadLetter = null;
        this.deadLetterUri = null;
        this.deadLetterHandleNewException = false;
        this.redeliveryProcessor = null;
        this.redeliveryPolicy = null;
        this.retryWhilePolicy = null;
        this.logger = null;
        this.useOriginalMessagePolicy = false;
        this.useOriginalBodyPolicy = false;
        this.redeliveryEnabled = false;
        this.simpleTask = false;
        this.exchangeFormatter = null;
        this.customExchangeFormatter = false;
        this.onPrepareProcessor = null;
        this.onExceptionProcessor = null;
        log.trace("Loaded {}", (Object)RedeliveryErrorHandler.class.getName());
    }

    public void process(Exchange exchange) {
        if (this.output == null) {
            return;
        }
        this.awaitManager.process((AsyncProcessor)this, exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            PooledExchangeTask task = this.taskFactory.acquire(exchange, callback);
            if (exchange.isTransacted()) {
                this.reactiveExecutor.scheduleQueue((Runnable)task);
            } else {
                this.reactiveExecutor.scheduleMain((Runnable)task);
            }
            return false;
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter callback = new AsyncCallbackToCompletableFutureAdapter((Object)exchange);
        this.process(exchange, (AsyncCallback)callback);
        return callback.getFuture();
    }

    public void changeOutput(Processor output) {
        this.output = output;
        this.outputAsync = AsyncProcessorConverterHelper.convert((Processor)output);
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    public boolean hasNext() {
        return this.output != null;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.output);
        return answer;
    }

    protected boolean isRunAllowedOnPreparingShutdown() {
        return false;
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        LOG.trace("Prepare shutdown on error handler: {}", (Object)this);
        this.preparingShutdown = true;
    }

    protected long determineRedeliveryDelay(Exchange exchange, RedeliveryPolicy redeliveryPolicy, long redeliveryDelay, int redeliveryCounter) {
        Message message = exchange.getIn();
        Long delay = (Long)message.getHeader("CamelRedeliveryDelay", Long.class);
        if (delay == null) {
            delay = redeliveryPolicy.calculateRedeliveryDelay(redeliveryDelay, redeliveryCounter);
            LOG.debug("Redelivery delay calculated as {}", (Object)delay);
        } else {
            LOG.debug("Redelivery delay is {} from Message Header [{}]", (Object)delay, (Object)"CamelRedeliveryDelay");
        }
        return delay;
    }

    protected Exchange defensiveCopyExchangeIfNeeded(Exchange exchange) {
        if (this.redeliveryEnabled) {
            return ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
        }
        return null;
    }

    protected boolean isDone(Exchange exchange) {
        boolean answer;
        ExtendedExchange ee = (ExtendedExchange)exchange;
        if (ee.isInterrupted()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Is exchangeId: {} interrupted? true", (Object)exchange.getExchangeId());
            }
            exchange.setRouteStop(true);
            return true;
        }
        boolean bl = answer = exchange.getException() == null || ExchangeHelper.isFailureHandled((Exchange)exchange) || ee.isRedeliveryExhausted();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Is exchangeId: {} done? {}", (Object)exchange.getExchangeId(), (Object)answer);
        }
        return answer;
    }

    @Override
    public Processor getOutput() {
        return this.output;
    }

    public Processor getDeadLetter() {
        return this.deadLetter;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public boolean isUseOriginalMessagePolicy() {
        return this.useOriginalMessagePolicy;
    }

    public boolean isUseOriginalBodyPolicy() {
        return this.useOriginalBodyPolicy;
    }

    public boolean isDeadLetterHandleNewException() {
        return this.deadLetterHandleNewException;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    protected Predicate getDefaultHandledPredicate() {
        return null;
    }

    private void decrementRedeliveryCounter(Exchange exchange) {
        Message in = exchange.getIn();
        Integer counter = (Integer)in.getHeader("CamelRedeliveryCounter", Integer.class);
        if (counter != null) {
            int prev = counter - 1;
            in.setHeader("CamelRedeliveryCounter", (Object)prev);
            in.setHeader("CamelRedelivered", (Object)(prev > 0 ? Boolean.TRUE : Boolean.FALSE));
        } else {
            in.setHeader("CamelRedeliveryCounter", (Object)0);
            in.setHeader("CamelRedelivered", (Object)Boolean.FALSE);
        }
    }

    public boolean determineIfRedeliveryIsEnabled() throws Exception {
        if (this.getRedeliveryPolicy().getMaximumRedeliveries() != 0) {
            return true;
        }
        if (this.retryWhilePolicy != null) {
            return true;
        }
        if (this.exceptionPolicies != null && !this.exceptionPolicies.isEmpty()) {
            for (ExceptionPolicy def : this.exceptionPolicies.values()) {
                if (!def.determineIfRedeliveryIsEnabled((CamelContext)this.camelContext)) continue;
                return true;
            }
        }
        return false;
    }

    protected void doStart() throws Exception {
        this.redeliveryEnabled = this.determineIfRedeliveryIsEnabled();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Redelivery enabled: {} on error handler: {}", (Object)this.redeliveryEnabled, (Object)this);
        }
        if (this.redeliveryEnabled) {
            if (this.executorService == null) {
                this.executorService = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getErrorHandlerExecutorService();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using ExecutorService: {} for redeliveries on error handler: {}", (Object)this.executorService, (Object)this);
            }
        }
        this.preparingShutdown = false;
        this.redeliverySleepCounter.set(0);
        this.simpleTask = this.deadLetter == null && !this.redeliveryEnabled && (this.exceptionPolicies == null || this.exceptionPolicies.isEmpty()) && this.onPrepareProcessor == null;
        boolean pooled = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getExchangeFactory().isPooled();
        if (pooled) {
            String id = this.output instanceof IdAware ? ((IdAware)this.output).getId() : this.output.toString();
            this.taskFactory = new PooledTaskFactory(id){

                @Override
                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return RedeliveryErrorHandler.this.simpleTask ? new SimpleTask() : new RedeliveryTask();
                }
            };
            int capacity = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getExchangeFactory().getCapacity();
            this.taskFactory.setCapacity(capacity);
        } else {
            this.taskFactory = new PrototypeTaskFactory(){

                @Override
                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return RedeliveryErrorHandler.this.simpleTask ? new SimpleTask() : new RedeliveryTask();
                }
            };
        }
        LOG.trace("Using TaskFactory: {}", (Object)this.taskFactory);
        ServiceHelper.startService((Object[])new Object[]{this.taskFactory, this.output, this.outputAsync, this.deadLetter});
    }

    protected void doStop() throws Exception {
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.deadLetter, this.output, this.outputAsync, this.taskFactory});
    }

    protected class RedeliveryTask
    implements PooledExchangeTask,
    Runnable {
        private Exchange original;
        private ExtendedExchange exchange;
        private AsyncCallback callback;
        private int redeliveryCounter;
        private long redeliveryDelay;
        private Predicate retryWhilePredicate;
        private RedeliveryPolicy currentRedeliveryPolicy;
        private Processor failureProcessor;
        private Processor onRedeliveryProcessor;
        private Processor onExceptionProcessor;
        private Predicate handledPredicate;
        private Predicate continuedPredicate;
        private boolean useOriginalInMessage;
        private boolean useOriginalInBody;

        public String toString() {
            return "RedeliveryTask";
        }

        @Override
        public void prepare(Exchange exchange, AsyncCallback callback) {
            this.retryWhilePredicate = RedeliveryErrorHandler.this.retryWhilePolicy;
            this.currentRedeliveryPolicy = RedeliveryErrorHandler.this.redeliveryPolicy;
            this.handledPredicate = RedeliveryErrorHandler.this.getDefaultHandledPredicate();
            this.useOriginalInMessage = RedeliveryErrorHandler.this.useOriginalMessagePolicy;
            this.useOriginalInBody = RedeliveryErrorHandler.this.useOriginalBodyPolicy;
            this.onRedeliveryProcessor = RedeliveryErrorHandler.this.redeliveryProcessor;
            this.onExceptionProcessor = RedeliveryErrorHandler.this.onExceptionProcessor;
            this.original = RedeliveryErrorHandler.this.redeliveryEnabled ? RedeliveryErrorHandler.this.defensiveCopyExchangeIfNeeded(exchange) : null;
            this.exchange = (ExtendedExchange)exchange;
            this.callback = callback;
        }

        @Override
        public void reset() {
            this.retryWhilePredicate = null;
            this.currentRedeliveryPolicy = null;
            this.handledPredicate = null;
            this.continuedPredicate = null;
            this.useOriginalInMessage = false;
            this.useOriginalInBody = false;
            this.onRedeliveryProcessor = null;
            this.onExceptionProcessor = null;
            this.original = null;
            this.exchange = null;
            this.callback = null;
            this.redeliveryCounter = 0;
            this.redeliveryDelay = 0L;
        }

        @Override
        public void run() {
            if (!this.isRunAllowed()) {
                LOG.trace("Run not allowed, will reject executing exchange: {}", (Object)this.exchange);
                if (this.exchange.getException() == null) {
                    this.exchange.setException((Throwable)new RejectedExecutionException());
                }
                AsyncCallback cb = this.callback;
                RedeliveryErrorHandler.this.taskFactory.release(this);
                cb.done(false);
                return;
            }
            try {
                this.doRun();
            }
            catch (Throwable e) {
                this.exchange.setException(e);
                this.callback.done(false);
            }
        }

        private void doRun() throws Exception {
            block15: {
                if (this.exchange.getException() != null) {
                    this.handleException();
                    this.onExceptionOccurred();
                }
                boolean redeliverAllowed = this.redeliveryCounter == 0 || this.isRedeliveryAllowed();
                boolean exhausted = false;
                if (redeliverAllowed) {
                    boolean bl = exhausted = this.exchange.isRedeliveryExhausted() || this.exchange.isRollbackOnly();
                    if (!exhausted && this.redeliveryCounter > 0) {
                        redeliverAllowed = this.currentRedeliveryPolicy.shouldRedeliver((Exchange)this.exchange, this.redeliveryCounter, this.retryWhilePredicate);
                    }
                }
                if (!redeliverAllowed || exhausted) {
                    Processor target = this.failureProcessor != null ? this.failureProcessor : RedeliveryErrorHandler.this.deadLetter;
                    boolean isDeadLetterChannel = RedeliveryErrorHandler.this.isDeadLetterChannel() && target == RedeliveryErrorHandler.this.deadLetter;
                    this.deliverToFailureProcessor(target, isDeadLetterChannel, (Exchange)this.exchange);
                } else if (this.redeliveryCounter > 0) {
                    this.redeliveryDelay = RedeliveryErrorHandler.this.determineRedeliveryDelay((Exchange)this.exchange, this.currentRedeliveryPolicy, this.redeliveryDelay, this.redeliveryCounter);
                    if (this.redeliveryDelay > 0L) {
                        if (this.currentRedeliveryPolicy.isAsyncDelayedRedelivery() && !this.exchange.isTransacted()) {
                            ObjectHelper.notNull((Object)RedeliveryErrorHandler.this.executorService, (String)"Redelivery is enabled but ExecutorService has not been configured.", (Object)this);
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Scheduling redelivery task to run in {} millis for exchangeId: {}", (Object)this.redeliveryDelay, (Object)this.exchange.getExchangeId());
                            }
                            RedeliveryErrorHandler.this.executorService.schedule(() -> RedeliveryErrorHandler.this.reactiveExecutor.schedule(this::redeliver), this.redeliveryDelay, TimeUnit.MILLISECONDS);
                        } else {
                            try {
                                RedeliveryErrorHandler.this.redeliverySleepCounter.incrementAndGet();
                                boolean complete = this.sleep();
                                RedeliveryErrorHandler.this.redeliverySleepCounter.decrementAndGet();
                                if (!complete) {
                                    this.exchange.setException((Throwable)new RejectedExecutionException("Redelivery not allowed while stopping"));
                                    ((ExtendedExchange)this.exchange.adapt(ExtendedExchange.class)).setRedeliveryExhausted(true);
                                    RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)this);
                                    break block15;
                                }
                                RedeliveryErrorHandler.this.reactiveExecutor.schedule(this::redeliver);
                            }
                            catch (InterruptedException e) {
                                RedeliveryErrorHandler.this.redeliverySleepCounter.decrementAndGet();
                                this.exchange.setException((Throwable)e);
                                this.exchange.setRouteStop(true);
                                RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)this.callback);
                            }
                        }
                    } else {
                        RedeliveryErrorHandler.this.reactiveExecutor.schedule(this::redeliver);
                    }
                } else {
                    RedeliveryErrorHandler.this.outputAsync.process((Exchange)this.exchange, doneSync -> {
                        if (RedeliveryErrorHandler.this.isDone((Exchange)this.exchange)) {
                            AsyncCallback cb = this.callback;
                            RedeliveryErrorHandler.this.taskFactory.release(this);
                            RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)cb);
                        } else {
                            RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)this);
                        }
                    });
                }
            }
        }

        protected boolean isRunAllowed() {
            if (RedeliveryErrorHandler.this.shutdownStrategy.isForceShutdown()) {
                return false;
            }
            if (this.redeliveryCounter > 0) {
                if (this.currentRedeliveryPolicy.allowRedeliveryWhileStopping) {
                    return true;
                }
                if (RedeliveryErrorHandler.this.preparingShutdown) {
                    return RedeliveryErrorHandler.this.isRunAllowedOnPreparingShutdown();
                }
            }
            return !RedeliveryErrorHandler.this.isStoppingOrStopped();
        }

        protected boolean isRedeliveryAllowed() {
            boolean stopping = RedeliveryErrorHandler.this.isStoppingOrStopped();
            if (!RedeliveryErrorHandler.this.preparingShutdown && !stopping) {
                return true;
            }
            return this.currentRedeliveryPolicy.allowRedeliveryWhileStopping;
        }

        protected void redeliver() {
            this.prepareExchangeForRedelivery();
            this.deliverToOnRedeliveryProcessor();
            if (this.exchange.isRouteStop()) {
                AsyncCallback cb = this.callback;
                RedeliveryErrorHandler.this.taskFactory.release(this);
                RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)cb);
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Redelivering exchangeId: {} -> {} for Exchange: {}", new Object[]{this.exchange.getExchangeId(), RedeliveryErrorHandler.this.outputAsync, this.exchange});
            }
            if (RedeliveryErrorHandler.this.camelContext.isEventNotificationApplicable()) {
                EventHelper.notifyExchangeRedelivery((CamelContext)this.exchange.getContext(), (Exchange)this.exchange, (int)this.redeliveryCounter);
            }
            RedeliveryErrorHandler.this.outputAsync.process((Exchange)this.exchange, doneSync -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Redelivering exchangeId: {}", (Object)this.exchange.getExchangeId());
                }
                if (RedeliveryErrorHandler.this.isDone((Exchange)this.exchange)) {
                    AsyncCallback cb = this.callback;
                    RedeliveryErrorHandler.this.taskFactory.release(this);
                    RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)cb);
                } else {
                    RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)this);
                }
            });
        }

        protected void prepareExchangeForContinue(Exchange exchange, boolean isDeadLetterChannel) {
            Exception caught = exchange.getException();
            if (caught != null) {
                exchange.setException(null);
            }
            exchange.setRollbackOnly(false);
            MessageHelper.resetStreamCache((Message)exchange.getIn());
            exchange.getIn().removeHeader("CamelRedelivered");
            exchange.getIn().removeHeader("CamelRedeliveryCounter");
            exchange.getIn().removeHeader("CamelRedeliveryMaxCounter");
            exchange.removeProperty(ExchangePropertyKey.FAILURE_HANDLED);
            String msg = "Failed delivery for " + ExchangeHelper.logIds((Exchange)exchange);
            msg = msg + ". Exhausted after delivery attempt: " + this.redeliveryCounter + " caught: " + caught;
            msg = msg + ". Handled and continue routing.";
            this.logFailedDelivery(false, false, false, true, isDeadLetterChannel, exchange, msg, null);
        }

        protected void prepareExchangeForRedelivery() {
            if (!RedeliveryErrorHandler.this.redeliveryEnabled) {
                throw new IllegalStateException("Redelivery is not enabled on " + RedeliveryErrorHandler.this + ". Make sure you have configured the error handler properly.");
            }
            ObjectHelper.notNull((Object)this.original, (String)"Defensive copy of Exchange is null", (Object)((Object)RedeliveryErrorHandler.this));
            this.exchange.setException(null);
            this.exchange.setRollbackOnly(false);
            Integer redeliveryCounter = (Integer)this.exchange.getIn().getHeader("CamelRedeliveryCounter", Integer.class);
            Integer redeliveryMaxCounter = (Integer)this.exchange.getIn().getHeader("CamelRedeliveryMaxCounter", Integer.class);
            Boolean redelivered = (Boolean)this.exchange.getIn().getHeader("CamelRedelivered", Boolean.class);
            this.exchange.getIn().copyFrom(this.original.getIn());
            this.exchange.setOut(null);
            MessageHelper.resetStreamCache((Message)this.exchange.getIn());
            if (redeliveryCounter != null) {
                this.exchange.getIn().setHeader("CamelRedeliveryCounter", (Object)redeliveryCounter);
            }
            if (redeliveryMaxCounter != null) {
                this.exchange.getIn().setHeader("CamelRedeliveryMaxCounter", (Object)redeliveryMaxCounter);
            }
            if (redelivered != null) {
                this.exchange.getIn().setHeader("CamelRedelivered", (Object)redelivered);
            }
        }

        protected void handleException() {
            Exception e = this.exchange.getException();
            Throwable previous = (Throwable)this.exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
            if (previous != null && previous != e) {
                Throwable[] suppressed = e.getSuppressed();
                boolean found = false;
                for (Throwable t : suppressed) {
                    if (t != previous) continue;
                    found = true;
                }
                if (!found) {
                    StackTraceElement[] ste1 = e.getStackTrace();
                    StackTraceElement[] ste2 = previous.getStackTrace();
                    boolean same = false;
                    if (ste1 != null && ste2 != null && ste1.length > 0 && ste2.length > 0) {
                        boolean bl = same = ste1[0].getClassName().equals(ste2[0].getClassName()) && ste1[0].getLineNumber() == ste2[0].getLineNumber();
                    }
                    if (!same) {
                        e.addSuppressed(previous);
                    }
                }
            }
            this.exchange.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)e);
            ExceptionPolicy exceptionPolicy = RedeliveryErrorHandler.this.getExceptionPolicy((Exchange)this.exchange, e);
            if (exceptionPolicy != null) {
                this.currentRedeliveryPolicy = exceptionPolicy.createRedeliveryPolicy(this.exchange.getContext(), this.currentRedeliveryPolicy);
                this.handledPredicate = exceptionPolicy.getHandledPolicy();
                this.continuedPredicate = exceptionPolicy.getContinuedPolicy();
                this.retryWhilePredicate = exceptionPolicy.getRetryWhilePolicy();
                this.useOriginalInMessage = exceptionPolicy.isUseOriginalInMessage();
                this.useOriginalInBody = exceptionPolicy.isUseOriginalInBody();
                Processor processor = null;
                Route rc = ExchangeHelper.getRoute((Exchange)this.exchange);
                if (rc != null) {
                    processor = rc.getOnException(exceptionPolicy.getId());
                } else {
                    LOG.warn("Cannot determine current route from Exchange with id: {}, will fallback and use first error handler.", (Object)this.exchange.getExchangeId());
                }
                if (processor != null) {
                    this.failureProcessor = processor;
                }
                if ((processor = exceptionPolicy.getOnRedelivery()) != null) {
                    this.onRedeliveryProcessor = processor;
                }
                if ((processor = exceptionPolicy.getOnExceptionOccurred()) != null) {
                    this.onExceptionProcessor = processor;
                }
            }
            if (!ExchangeHelper.isFailureHandled((Exchange)this.exchange) && !ExchangeHelper.isUnitOfWorkExhausted((Exchange)this.exchange)) {
                String msg = "Failed delivery for " + ExchangeHelper.logIds((Exchange)this.exchange) + ". On delivery attempt: " + this.redeliveryCounter + " caught: " + e;
                this.logFailedDelivery(true, false, false, false, RedeliveryErrorHandler.this.isDeadLetterChannel(), (Exchange)this.exchange, msg, e);
            }
            this.redeliveryCounter = this.incrementRedeliveryCounter((Exchange)this.exchange);
        }

        protected void onExceptionOccurred() {
            if (this.onExceptionProcessor == null) {
                return;
            }
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("OnExceptionOccurred processor {} is processing Exchange: {} due exception occurred", (Object)this.onExceptionProcessor, (Object)this.exchange);
                }
                this.onExceptionProcessor.process((Exchange)this.exchange);
            }
            catch (Throwable e) {
                LOG.warn("Error during processing OnExceptionOccurred. This exception is ignored.", e);
            }
            LOG.trace("OnExceptionOccurred processor done");
        }

        protected void deliverToOnRedeliveryProcessor() {
            if (this.onRedeliveryProcessor == null) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Redelivery processor {} is processing Exchange: {} before its redelivered", (Object)this.onRedeliveryProcessor, (Object)this.exchange);
            }
            try {
                this.onRedeliveryProcessor.process((Exchange)this.exchange);
            }
            catch (Throwable e) {
                this.exchange.setException(e);
            }
            LOG.trace("Redelivery processor done");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deliverToFailureProcessor(Processor processor, boolean isDeadLetterChannel, Exchange exchange) {
            boolean handleOrContinue;
            Exception caught = exchange.getException();
            if (caught != null) {
                exchange.setException(null);
            }
            boolean shouldHandle = this.shouldHandle(exchange);
            boolean shouldContinue = this.shouldContinue(exchange);
            boolean handled = false;
            boolean bl = handleOrContinue = isDeadLetterChannel || shouldHandle || shouldContinue;
            if (handleOrContinue) {
                exchange.getIn().removeHeader("CamelRedelivered");
                exchange.getIn().removeHeader("CamelRedeliveryCounter");
                exchange.getIn().removeHeader("CamelRedeliveryMaxCounter");
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setRedeliveryExhausted(false);
                exchange.setRollbackOnly(false);
                exchange.removeProperty(ExchangePropertyKey.UNIT_OF_WORK_EXHAUSTED);
                handled = true;
            } else {
                RedeliveryErrorHandler.this.decrementRedeliveryCounter(exchange);
            }
            boolean allowFailureProcessor = !shouldContinue || !isDeadLetterChannel;
            boolean fHandled = handled;
            if (allowFailureProcessor && processor != null) {
                boolean deadLetterChannel;
                if (this.useOriginalInMessage || this.useOriginalInBody) {
                    Message original = ExchangeHelper.getOriginalInMessage((Exchange)exchange);
                    if (this.useOriginalInMessage) {
                        LOG.trace("Using the original IN message instead of current");
                        exchange.setIn(original);
                    } else {
                        LOG.trace("Using the original IN message body instead of current");
                        exchange.getIn().setBody(original.getBody());
                    }
                    if (exchange.hasOut()) {
                        LOG.trace("Removing the out message to avoid some uncertain behavior");
                        exchange.setOut(null);
                    }
                }
                MessageHelper.resetStreamCache((Message)exchange.getIn());
                exchange.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, exchange.getProperty(ExchangePropertyKey.TO_ENDPOINT));
                Route rc = ExchangeHelper.getRoute((Exchange)exchange);
                if (rc != null) {
                    exchange.setProperty(ExchangePropertyKey.FAILURE_ROUTE_ID, (Object)rc.getRouteId());
                }
                if (RedeliveryErrorHandler.this.onPrepareProcessor != null) {
                    try {
                        LOG.trace("OnPrepare processor {} is processing Exchange: {}", (Object)RedeliveryErrorHandler.this.onPrepareProcessor, (Object)exchange);
                        RedeliveryErrorHandler.this.onPrepareProcessor.process(exchange);
                    }
                    catch (Exception e) {
                        exchange.setException((Throwable)e);
                    }
                }
                LOG.trace("Failure processor {} is processing Exchange: {}", (Object)processor, (Object)exchange);
                boolean bl2 = deadLetterChannel = processor == RedeliveryErrorHandler.this.deadLetter;
                if (RedeliveryErrorHandler.this.camelContext.isEventNotificationApplicable()) {
                    EventHelper.notifyExchangeFailureHandling((CamelContext)exchange.getContext(), (Exchange)exchange, (Processor)processor, (boolean)deadLetterChannel, (String)RedeliveryErrorHandler.this.deadLetterUri);
                }
                AsyncProcessor afp = AsyncProcessorConverterHelper.convert((Processor)processor);
                afp.process(exchange, sync -> {
                    LOG.trace("Failure processor done: {} processing Exchange: {}", (Object)processor, (Object)exchange);
                    try {
                        this.prepareExchangeAfterFailure(exchange, isDeadLetterChannel, shouldHandle, shouldContinue);
                        if (RedeliveryErrorHandler.this.camelContext.isEventNotificationApplicable()) {
                            EventHelper.notifyExchangeFailureHandled((CamelContext)exchange.getContext(), (Exchange)exchange, (Processor)processor, (boolean)deadLetterChannel, (String)RedeliveryErrorHandler.this.deadLetterUri);
                        }
                    }
                    finally {
                        RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)this.callback);
                        String msg = "Failed delivery for " + ExchangeHelper.logIds((Exchange)exchange);
                        msg = msg + ". Exhausted after delivery attempt: " + this.redeliveryCounter + " caught: " + caught;
                        if (processor != null) {
                            msg = isDeadLetterChannel && RedeliveryErrorHandler.this.deadLetterUri != null ? msg + ". Handled by DeadLetterChannel: [" + URISupport.sanitizeUri((String)RedeliveryErrorHandler.this.deadLetterUri) + "]" : msg + ". Processed by failure processor: " + processor;
                        }
                        this.logFailedDelivery(false, false, fHandled, false, isDeadLetterChannel, exchange, msg, null);
                        RedeliveryErrorHandler.this.taskFactory.release(this);
                    }
                });
            } else {
                try {
                    exchange.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, exchange.getProperty(ExchangePropertyKey.TO_ENDPOINT));
                    Route rc = ExchangeHelper.getRoute((Exchange)exchange);
                    if (rc != null) {
                        exchange.setProperty(ExchangePropertyKey.FAILURE_ROUTE_ID, (Object)rc.getRouteId());
                    }
                    if (RedeliveryErrorHandler.this.onPrepareProcessor != null) {
                        try {
                            LOG.trace("OnPrepare processor {} is processing Exchange: {}", (Object)RedeliveryErrorHandler.this.onPrepareProcessor, (Object)exchange);
                            RedeliveryErrorHandler.this.onPrepareProcessor.process(exchange);
                        }
                        catch (Exception e) {
                            exchange.setException((Throwable)e);
                        }
                    }
                    this.prepareExchangeAfterFailure(exchange, isDeadLetterChannel, shouldHandle, shouldContinue);
                }
                finally {
                    RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)this.callback);
                    String msg = "Failed delivery for " + ExchangeHelper.logIds((Exchange)exchange);
                    msg = msg + ". Exhausted after delivery attempt: " + this.redeliveryCounter + " caught: " + caught;
                    if (processor != null) {
                        msg = isDeadLetterChannel && RedeliveryErrorHandler.this.deadLetterUri != null ? msg + ". Handled by DeadLetterChannel: [" + URISupport.sanitizeUri((String)RedeliveryErrorHandler.this.deadLetterUri) + "]" : msg + ". Processed by failure processor: " + processor;
                    }
                    this.logFailedDelivery(false, false, fHandled, false, isDeadLetterChannel, exchange, msg, null);
                    RedeliveryErrorHandler.this.taskFactory.release(this);
                }
            }
        }

        protected void prepareExchangeAfterFailure(Exchange exchange, boolean isDeadLetterChannel, boolean shouldHandle, boolean shouldContinue) {
            ExtendedExchange ee = (ExtendedExchange)exchange;
            Exception newException = exchange.getException();
            ExchangeHelper.setFailureHandled((Exchange)exchange);
            boolean alreadySet = ee.isErrorHandlerHandledSet();
            if (alreadySet) {
                boolean handled = ee.isErrorHandlerHandled();
                LOG.trace("This exchange has already been marked for handling: {}", (Object)handled);
                if (!handled) {
                    exchange.setException((Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class));
                    exchange.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, exchange.getProperty(ExchangePropertyKey.TO_ENDPOINT));
                }
                return;
            }
            if (shouldContinue) {
                LOG.trace("This exchange is continued: {}", (Object)exchange);
                this.prepareExchangeForContinue(exchange, isDeadLetterChannel);
            } else if (shouldHandle) {
                LOG.trace("This exchange is handled so its marked as not failed: {}", (Object)exchange);
                ee.setErrorHandlerHandled(Boolean.valueOf(true));
            } else {
                if (isDeadLetterChannel) {
                    boolean handled;
                    boolean bl = handled = newException == null || RedeliveryErrorHandler.this.deadLetterHandleNewException;
                    if (newException != null && this.currentRedeliveryPolicy.isLogNewException()) {
                        String uri = URISupport.sanitizeUri((String)RedeliveryErrorHandler.this.deadLetterUri);
                        String msg = "New exception occurred during processing by the DeadLetterChannel[" + uri + "] due " + newException.getMessage();
                        msg = handled ? msg + ". The new exception is being handled as deadLetterHandleNewException=true." : msg + ". The new exception is not handled as deadLetterHandleNewException=false.";
                        this.logFailedDelivery(false, true, handled, false, true, exchange, msg, newException);
                    }
                    if (handled) {
                        LOG.trace("This exchange is handled so its marked as not failed: {}", (Object)exchange);
                        ee.setErrorHandlerHandled(Boolean.valueOf(true));
                        return;
                    }
                }
                this.prepareExchangeAfterFailureNotHandled(exchange);
            }
        }

        private void prepareExchangeAfterFailureNotHandled(Exchange exchange) {
            ExtendedExchange ee = (ExtendedExchange)exchange;
            LOG.trace("This exchange is not handled or continued so its marked as failed: {}", (Object)ee);
            ee.setErrorHandlerHandled(Boolean.valueOf(false));
            ee.setException((Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class));
            ee.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, ee.getProperty(ExchangePropertyKey.TO_ENDPOINT));
            String routeId = ExchangeHelper.getAtRouteId((Exchange)ee);
            if (routeId != null) {
                ee.setProperty(ExchangePropertyKey.FAILURE_ROUTE_ID, (Object)routeId);
            }
        }

        private void logFailedDelivery(boolean shouldRedeliver, boolean newException, boolean handled, boolean continued, boolean isDeadLetterChannel, Exchange exchange, String message, Throwable e) {
            boolean logStackTrace;
            LoggingLevel newLogLevel;
            if (RedeliveryErrorHandler.this.logger == null) {
                return;
            }
            if (!exchange.isRollbackOnly() && !exchange.isRollbackOnlyLast()) {
                if (newException && !this.currentRedeliveryPolicy.isLogNewException()) {
                    return;
                }
                if (!newException && handled && !this.currentRedeliveryPolicy.isLogHandled()) {
                    return;
                }
                if (!newException && continued && !this.currentRedeliveryPolicy.isLogContinued()) {
                    return;
                }
                if (!newException && shouldRedeliver && !this.currentRedeliveryPolicy.isLogRetryAttempted()) {
                    return;
                }
                if (!newException && shouldRedeliver) {
                    if (this.currentRedeliveryPolicy.isLogRetryAttempted()) {
                        if (this.currentRedeliveryPolicy.getRetryAttemptedLogInterval() > 1 && this.redeliveryCounter % this.currentRedeliveryPolicy.getRetryAttemptedLogInterval() != 0) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (!(newException || shouldRedeliver || this.currentRedeliveryPolicy.isLogExhausted())) {
                    return;
                }
            }
            if (exchange.isRollbackOnly() || exchange.isRollbackOnlyLast()) {
                newLogLevel = this.currentRedeliveryPolicy.getRetriesExhaustedLogLevel();
                logStackTrace = this.currentRedeliveryPolicy.isLogStackTrace();
            } else if (shouldRedeliver) {
                newLogLevel = this.currentRedeliveryPolicy.getRetryAttemptedLogLevel();
                logStackTrace = this.currentRedeliveryPolicy.isLogRetryStackTrace();
            } else {
                newLogLevel = this.currentRedeliveryPolicy.getRetriesExhaustedLogLevel();
                logStackTrace = this.currentRedeliveryPolicy.isLogStackTrace();
            }
            if (e == null) {
                e = (Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
            }
            if (newException) {
                Object msg;
                if (newLogLevel == LoggingLevel.ERROR) {
                    newLogLevel = LoggingLevel.WARN;
                }
                if ((msg = message) == null) {
                    msg = "New exception " + ExchangeHelper.logIds((Exchange)exchange);
                    Throwable cause = e;
                    if (cause != null) {
                        msg = (String)msg + " due: " + cause.getMessage();
                    }
                }
                if (e != null && logStackTrace) {
                    RedeliveryErrorHandler.this.logger.log((String)msg, e, newLogLevel);
                } else {
                    RedeliveryErrorHandler.this.logger.log((String)msg, newLogLevel);
                }
            } else if (exchange.isRollbackOnly() || exchange.isRollbackOnlyLast()) {
                ExchangeFormatter formatter;
                String routeStackTrace;
                Exception cause;
                String msg = "Rollback " + ExchangeHelper.logIds((Exchange)exchange);
                Throwable throwable = cause = exchange.getException() != null ? exchange.getException() : (Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
                if (cause != null) {
                    msg = msg + " due: " + cause.getMessage();
                }
                if (!shouldRedeliver && this.currentRedeliveryPolicy.isLogExhaustedMessageHistory() && (routeStackTrace = MessageHelper.dumpMessageHistoryStacktrace((Exchange)exchange, (ExchangeFormatter)(formatter = RedeliveryErrorHandler.this.customExchangeFormatter ? RedeliveryErrorHandler.this.exchangeFormatter : (this.currentRedeliveryPolicy.isLogExhaustedMessageBody() || RedeliveryErrorHandler.this.camelContext.isLogExhaustedMessageBody() != false ? RedeliveryErrorHandler.this.exchangeFormatter : null)), (boolean)false)) != null) {
                    msg = msg + "\n" + routeStackTrace;
                }
                if (newLogLevel == LoggingLevel.ERROR) {
                    RedeliveryErrorHandler.this.logger.log(msg, LoggingLevel.WARN);
                } else {
                    RedeliveryErrorHandler.this.logger.log(msg, newLogLevel);
                }
            } else {
                ExchangeFormatter formatter;
                String routeStackTrace;
                Object msg = message;
                if (!shouldRedeliver && this.currentRedeliveryPolicy.isLogExhaustedMessageHistory() && (routeStackTrace = MessageHelper.dumpMessageHistoryStacktrace((Exchange)exchange, (ExchangeFormatter)(formatter = RedeliveryErrorHandler.this.customExchangeFormatter ? RedeliveryErrorHandler.this.exchangeFormatter : (this.currentRedeliveryPolicy.isLogExhaustedMessageBody() || RedeliveryErrorHandler.this.camelContext.isLogExhaustedMessageBody() != false ? RedeliveryErrorHandler.this.exchangeFormatter : null)), (e != null && logStackTrace ? 1 : 0) != 0)) != null) {
                    msg = (String)msg + "\n" + routeStackTrace;
                }
                if (e != null && logStackTrace) {
                    RedeliveryErrorHandler.this.logger.log((String)msg, e, newLogLevel);
                } else {
                    RedeliveryErrorHandler.this.logger.log((String)msg, newLogLevel);
                }
            }
        }

        private boolean shouldContinue(Exchange exchange) {
            if (this.continuedPredicate != null) {
                return this.continuedPredicate.matches(exchange);
            }
            return false;
        }

        private boolean shouldHandle(Exchange exchange) {
            if (this.handledPredicate != null) {
                return this.handledPredicate.matches(exchange);
            }
            return false;
        }

        private int incrementRedeliveryCounter(Exchange exchange) {
            Message in = exchange.getIn();
            Integer counter = (Integer)in.getHeader("CamelRedeliveryCounter", Integer.class);
            int next = counter != null ? counter + 1 : 1;
            in.setHeader("CamelRedeliveryCounter", (Object)next);
            in.setHeader("CamelRedelivered", (Object)Boolean.TRUE);
            if (this.currentRedeliveryPolicy.getMaximumRedeliveries() > 0) {
                in.setHeader("CamelRedeliveryMaxCounter", (Object)this.currentRedeliveryPolicy.getMaximumRedeliveries());
            }
            return next;
        }

        public boolean sleep() throws InterruptedException {
            if (this.redeliveryDelay < 1000L) {
                this.currentRedeliveryPolicy.sleep(this.redeliveryDelay);
                return true;
            }
            StopWatch watch = new StopWatch();
            LOG.debug("Sleeping for: {} millis until attempting redelivery", (Object)this.redeliveryDelay);
            while (watch.taken() < this.redeliveryDelay) {
                long delta = this.redeliveryDelay - watch.taken();
                long max = Math.min(1000L, delta);
                if (max > 0L) {
                    LOG.trace("Sleeping for: {} millis until waking up for re-check", (Object)max);
                    Thread.sleep(max);
                }
                if (!RedeliveryErrorHandler.this.preparingShutdown || this.currentRedeliveryPolicy.isAllowRedeliveryWhileStopping()) continue;
                LOG.debug("Rejected redelivery while stopping");
                return false;
            }
            return true;
        }
    }

    protected class SimpleTask
    implements PooledExchangeTask,
    Runnable,
    AsyncCallback {
        private ExtendedExchange exchange;
        private AsyncCallback callback;
        private boolean first;

        @Override
        public void prepare(Exchange exchange, AsyncCallback callback) {
            this.exchange = (ExtendedExchange)exchange;
            this.callback = callback;
            this.first = true;
        }

        public String toString() {
            return "SimpleTask";
        }

        @Override
        public void reset() {
            this.exchange = null;
            this.callback = null;
            this.first = true;
        }

        public void done(boolean doneSync) {
            this.run();
        }

        @Override
        public void run() {
            boolean run = true;
            if (RedeliveryErrorHandler.this.shutdownStrategy.isForceShutdown()) {
                run = false;
            }
            if (run && RedeliveryErrorHandler.this.isStoppingOrStopped()) {
                run = false;
            }
            if (!run) {
                LOG.trace("Run not allowed, will reject executing exchange: {}", (Object)this.exchange);
                if (this.exchange.getException() == null) {
                    this.exchange.setException((Throwable)new RejectedExecutionException());
                }
                AsyncCallback cb = this.callback;
                RedeliveryErrorHandler.this.taskFactory.release(this);
                cb.done(false);
                return;
            }
            if (this.exchange.isInterrupted()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Is exchangeId: {} interrupted? true", (Object)this.exchange.getExchangeId());
                }
                this.exchange.setRouteStop(true);
                AsyncCallback cb = this.callback;
                RedeliveryErrorHandler.this.taskFactory.release(this);
                cb.done(false);
                return;
            }
            boolean failure = this.exchange.getException() != null && !this.exchange.isRedeliveryExhausted() && !ExchangeHelper.isFailureHandled((Exchange)this.exchange);
            boolean bridge = ExchangeHelper.isErrorHandlerBridge((Exchange)this.exchange);
            if (failure || bridge) {
                this.handleException();
                this.onExceptionOccurred();
                this.prepareExchangeAfterFailure((Exchange)this.exchange);
                AsyncCallback cb = this.callback;
                RedeliveryErrorHandler.this.taskFactory.release(this);
                RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)cb);
            } else if (this.first) {
                this.first = false;
                RedeliveryErrorHandler.this.outputAsync.process((Exchange)this.exchange, (AsyncCallback)this);
            } else {
                AsyncCallback cb = this.callback;
                RedeliveryErrorHandler.this.taskFactory.release(this);
                RedeliveryErrorHandler.this.reactiveExecutor.schedule((Runnable)cb);
            }
        }

        protected void handleException() {
            Exception e = this.exchange.getException();
            Throwable previous = (Throwable)this.exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
            if (previous != null && previous != e) {
                Throwable[] suppressed = e.getSuppressed();
                boolean found = false;
                for (Throwable t : suppressed) {
                    if (t != previous) continue;
                    found = true;
                }
                if (!found) {
                    StackTraceElement[] ste1 = e.getStackTrace();
                    StackTraceElement[] ste2 = previous.getStackTrace();
                    boolean same = false;
                    if (ste1 != null && ste2 != null && ste1.length > 0 && ste2.length > 0) {
                        boolean bl = same = ste1[0].getClassName().equals(ste2[0].getClassName()) && ste1[0].getLineNumber() == ste2[0].getLineNumber();
                    }
                    if (!same) {
                        e.addSuppressed(previous);
                    }
                }
            }
            this.exchange.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)e);
        }

        protected void onExceptionOccurred() {
            if (RedeliveryErrorHandler.this.onExceptionProcessor == null) {
                return;
            }
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("OnExceptionOccurred processor {} is processing Exchange: {} due exception occurred", (Object)RedeliveryErrorHandler.this.onExceptionProcessor, (Object)this.exchange);
                }
                RedeliveryErrorHandler.this.onExceptionProcessor.process((Exchange)this.exchange);
            }
            catch (Throwable e) {
                LOG.warn("Error during processing OnExceptionOccurred. This exception is ignored.", e);
            }
            LOG.trace("OnExceptionOccurred processor done");
        }

        protected void prepareExchangeAfterFailure(Exchange exchange) {
            ExtendedExchange ee = (ExtendedExchange)exchange;
            ExchangeHelper.setFailureHandled((Exchange)exchange);
            boolean alreadySet = ee.isErrorHandlerHandledSet();
            if (alreadySet) {
                boolean handled = ee.isErrorHandlerHandled();
                LOG.trace("This exchange has already been marked for handling: {}", (Object)handled);
                if (!handled) {
                    exchange.setException((Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class));
                    exchange.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, exchange.getProperty(ExchangePropertyKey.TO_ENDPOINT));
                }
                return;
            }
            this.prepareExchangeAfterFailureNotHandled(exchange);
        }

        private void prepareExchangeAfterFailureNotHandled(Exchange exchange) {
            ExtendedExchange ee = (ExtendedExchange)exchange;
            LOG.trace("This exchange is not handled or continued so its marked as failed: {}", (Object)ee);
            ee.setErrorHandlerHandled(Boolean.valueOf(false));
            ee.setException((Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class));
            ee.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, ee.getProperty(ExchangePropertyKey.TO_ENDPOINT));
            Route rc = ExchangeHelper.getRoute((Exchange)ee);
            if (rc != null) {
                ee.setProperty(ExchangePropertyKey.FAILURE_ROUTE_ID, (Object)rc.getRouteId());
            }
            String msg = "Failed delivery for " + ExchangeHelper.logIds((Exchange)exchange);
            msg = msg + ". Exhausted after delivery attempt: 1 caught: " + ee.getException();
            this.logFailedDelivery(exchange, msg, null);
        }

        private void logFailedDelivery(Exchange exchange, String message, Throwable e) {
            if (RedeliveryErrorHandler.this.logger == null) {
                return;
            }
            if (e == null) {
                e = (Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
            }
            if (exchange.isRollbackOnly() || exchange.isRollbackOnlyLast()) {
                ExchangeFormatter formatter;
                String routeStackTrace;
                Exception cause;
                String msg = "Rollback " + ExchangeHelper.logIds((Exchange)exchange);
                Throwable throwable = cause = exchange.getException() != null ? exchange.getException() : (Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
                if (cause != null) {
                    msg = msg + " due: " + cause.getMessage();
                }
                if (RedeliveryErrorHandler.this.redeliveryPolicy.isLogExhaustedMessageHistory() && (routeStackTrace = MessageHelper.dumpMessageHistoryStacktrace((Exchange)exchange, (ExchangeFormatter)(formatter = RedeliveryErrorHandler.this.customExchangeFormatter ? RedeliveryErrorHandler.this.exchangeFormatter : (RedeliveryErrorHandler.this.redeliveryPolicy.isLogExhaustedMessageBody() || RedeliveryErrorHandler.this.camelContext.isLogExhaustedMessageBody() != false ? RedeliveryErrorHandler.this.exchangeFormatter : null)), (boolean)false)) != null) {
                    msg = msg + "\n" + routeStackTrace;
                }
                if (RedeliveryErrorHandler.this.logger.getLevel() == LoggingLevel.ERROR) {
                    RedeliveryErrorHandler.this.logger.log(msg, LoggingLevel.WARN);
                } else {
                    RedeliveryErrorHandler.this.logger.log(msg);
                }
            } else {
                ExchangeFormatter formatter;
                String routeStackTrace;
                Object msg = message;
                if (RedeliveryErrorHandler.this.redeliveryPolicy.isLogExhaustedMessageHistory() && (routeStackTrace = MessageHelper.dumpMessageHistoryStacktrace((Exchange)exchange, (ExchangeFormatter)(formatter = RedeliveryErrorHandler.this.customExchangeFormatter ? RedeliveryErrorHandler.this.exchangeFormatter : (RedeliveryErrorHandler.this.redeliveryPolicy.isLogExhaustedMessageBody() || RedeliveryErrorHandler.this.camelContext.isLogExhaustedMessageBody() != false ? RedeliveryErrorHandler.this.exchangeFormatter : null)), (e != null && RedeliveryErrorHandler.this.redeliveryPolicy.isLogStackTrace() ? 1 : 0) != 0)) != null) {
                    msg = (String)msg + "\n" + routeStackTrace;
                }
                if (e != null && RedeliveryErrorHandler.this.redeliveryPolicy.isLogStackTrace()) {
                    RedeliveryErrorHandler.this.logger.log((String)msg, e);
                } else {
                    RedeliveryErrorHandler.this.logger.log((String)msg);
                }
            }
        }
    }
}

