/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.apache.camel.kafkaconnector.miniosource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelMiniosourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_BUCKET_NAME_CONF = "camel.kamelet.minio-source.bucketName";
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_BUCKET_NAME_DOC = "The MinIO Bucket name.";
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_BUCKET_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_DELETE_AFTER_READ_CONF = "camel.kamelet.minio-source.deleteAfterRead";
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_DELETE_AFTER_READ_DOC = "Delete objects after consuming them.";
    public static final Boolean CAMEL_SOURCE_MINIOSOURCE_KAMELET_DELETE_AFTER_READ_DEFAULT = true;
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_ACCESS_KEY_CONF = "camel.kamelet.minio-source.accessKey";
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_ACCESS_KEY_DOC = "The access key obtained from MinIO.";
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_SECRET_KEY_CONF = "camel.kamelet.minio-source.secretKey";
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_SECRET_KEY_DOC = "The secret key obtained from MinIO.";
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_SECRET_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_ENDPOINT_CONF = "camel.kamelet.minio-source.endpoint";
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_ENDPOINT_DOC = "The MinIO Endpoint. You can specify an URL, domain name, IPv4 address, or IPv6 address. Example: http://localhost:9000";
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_ENDPOINT_DEFAULT = null;
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_AUTO_CREATE_BUCKET_CONF = "camel.kamelet.minio-source.autoCreateBucket";
    public static final String CAMEL_SOURCE_MINIOSOURCE_KAMELET_AUTO_CREATE_BUCKET_DOC = "Specifies to automatically create the MinIO bucket.";
    public static final Boolean CAMEL_SOURCE_MINIOSOURCE_KAMELET_AUTO_CREATE_BUCKET_DEFAULT = false;

    public CamelMiniosourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelMiniosourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_MINIOSOURCE_KAMELET_BUCKET_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MINIOSOURCE_KAMELET_BUCKET_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MINIOSOURCE_KAMELET_BUCKET_NAME_DOC);
        conf.define(CAMEL_SOURCE_MINIOSOURCE_KAMELET_DELETE_AFTER_READ_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_MINIOSOURCE_KAMELET_DELETE_AFTER_READ_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MINIOSOURCE_KAMELET_DELETE_AFTER_READ_DOC);
        conf.define(CAMEL_SOURCE_MINIOSOURCE_KAMELET_ACCESS_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_MINIOSOURCE_KAMELET_ACCESS_KEY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MINIOSOURCE_KAMELET_ACCESS_KEY_DOC);
        conf.define(CAMEL_SOURCE_MINIOSOURCE_KAMELET_SECRET_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_MINIOSOURCE_KAMELET_SECRET_KEY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MINIOSOURCE_KAMELET_SECRET_KEY_DOC);
        conf.define(CAMEL_SOURCE_MINIOSOURCE_KAMELET_ENDPOINT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MINIOSOURCE_KAMELET_ENDPOINT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MINIOSOURCE_KAMELET_ENDPOINT_DOC);
        conf.define(CAMEL_SOURCE_MINIOSOURCE_KAMELET_AUTO_CREATE_BUCKET_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_MINIOSOURCE_KAMELET_AUTO_CREATE_BUCKET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MINIOSOURCE_KAMELET_AUTO_CREATE_BUCKET_DOC);
        return conf;
    }
}