/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OutputExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="split")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SplitDefinition
extends OutputExpressionNode
implements ExecutorServiceAwareDefinition<SplitDefinition> {
    @XmlTransient
    private ExecutorService executorServiceBean;
    @XmlTransient
    private AggregationStrategy aggregationStrategyBean;
    @XmlTransient
    private Processor onPrepareProcessor;
    @XmlAttribute
    @Metadata(defaultValue=",")
    private String delimiter;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.AggregationStrategy")
    private String aggregationStrategy;
    @XmlAttribute
    @Metadata(label="advanced")
    private String aggregationStrategyMethodName;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String aggregationStrategyMethodAllowNull;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String parallelAggregate;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String parallelProcessing;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String synchronous;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String streaming;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String stopOnException;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.time.Duration", defaultValue="0")
    private String timeout;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ExecutorService")
    private String executorService;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.Processor")
    private String onPrepare;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String shareUnitOfWork;

    public SplitDefinition() {
    }

    public SplitDefinition(Expression expression) {
        super(expression);
    }

    public SplitDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public String toString() {
        return "Split[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    public String getShortName() {
        return "split";
    }

    @Override
    public String getLabel() {
        return "split[" + this.getExpression() + "]";
    }

    public SplitDefinition delimiter(String delimiter) {
        this.setDelimiter(delimiter);
        return this;
    }

    public SplitDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategyBean = aggregationStrategy;
        return this;
    }

    public SplitDefinition aggregationStrategy(String aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public SplitDefinition aggregationStrategyMethodName(String methodName) {
        this.setAggregationStrategyMethodName(methodName);
        return this;
    }

    public SplitDefinition aggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull(true);
    }

    public SplitDefinition aggregationStrategyMethodAllowNull(boolean aggregationStrategyMethodAllowNull) {
        return this.aggregationStrategyMethodAllowNull(Boolean.toString(aggregationStrategyMethodAllowNull));
    }

    public SplitDefinition aggregationStrategyMethodAllowNull(String aggregationStrategyMethodAllowNull) {
        this.setAggregationStrategyMethodAllowNull(aggregationStrategyMethodAllowNull);
        return this;
    }

    public SplitDefinition parallelProcessing() {
        return this.parallelProcessing(true);
    }

    public SplitDefinition parallelProcessing(boolean parallelProcessing) {
        return this.parallelProcessing(Boolean.toString(parallelProcessing));
    }

    public SplitDefinition parallelProcessing(String parallelProcessing) {
        this.setParallelProcessing(parallelProcessing);
        return this;
    }

    public SplitDefinition parallelAggregate() {
        return this.parallelAggregate(true);
    }

    public SplitDefinition parallelAggregate(boolean parallelAggregate) {
        return this.parallelAggregate(Boolean.toString(parallelAggregate));
    }

    public SplitDefinition parallelAggregate(String parallelAggregate) {
        this.setParallelAggregate(parallelAggregate);
        return this;
    }

    public SplitDefinition synchronous() {
        return this.synchronous(true);
    }

    public SplitDefinition synchronous(boolean synchronous) {
        return this.synchronous(Boolean.toString(synchronous));
    }

    public SplitDefinition synchronous(String synchronous) {
        this.setSynchronous(synchronous);
        return this;
    }

    public SplitDefinition streaming() {
        return this.streaming(true);
    }

    public SplitDefinition streaming(boolean streaming) {
        return this.streaming(Boolean.toString(streaming));
    }

    public SplitDefinition streaming(String streaming) {
        this.setStreaming(streaming);
        return this;
    }

    public SplitDefinition stopOnException() {
        return this.stopOnException(true);
    }

    public SplitDefinition stopOnException(boolean stopOnException) {
        return this.stopOnException(Boolean.toString(stopOnException));
    }

    public SplitDefinition stopOnException(String stopOnException) {
        this.setStopOnException(stopOnException);
        return this;
    }

    @Override
    public SplitDefinition executorService(ExecutorService executorService) {
        this.executorServiceBean = executorService;
        return this;
    }

    @Override
    public SplitDefinition executorService(String executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public SplitDefinition onPrepare(Processor onPrepare) {
        this.onPrepareProcessor = onPrepare;
        return this;
    }

    public SplitDefinition onPrepare(String onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public SplitDefinition timeout(long timeout) {
        return this.timeout(Long.toString(timeout));
    }

    public SplitDefinition timeout(String timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public SplitDefinition shareUnitOfWork() {
        return this.shareUnitOfWork(true);
    }

    public SplitDefinition shareUnitOfWork(boolean shareUnitOfWork) {
        return this.shareUnitOfWork(Boolean.toString(shareUnitOfWork));
    }

    public SplitDefinition shareUnitOfWork(String shareUnitOfWork) {
        this.setShareUnitOfWork(shareUnitOfWork);
        return this;
    }

    public AggregationStrategy getAggregationStrategyBean() {
        return this.aggregationStrategyBean;
    }

    public Processor getOnPrepareProcessor() {
        return this.onPrepareProcessor;
    }

    @Override
    public ExecutorService getExecutorServiceBean() {
        return this.executorServiceBean;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorService;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(String parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public String getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(String synchronous) {
        this.synchronous = synchronous;
    }

    public String getStreaming() {
        return this.streaming;
    }

    public void setStreaming(String streaming) {
        this.streaming = streaming;
    }

    public String getParallelAggregate() {
        return this.parallelAggregate;
    }

    public void setParallelAggregate(String parallelAggregate) {
        this.parallelAggregate = parallelAggregate;
    }

    public String getStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(String stopOnException) {
        this.stopOnException = stopOnException;
    }

    public String getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(String aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategyBean) {
        this.aggregationStrategyBean = aggregationStrategyBean;
    }

    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }

    public String getAggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull;
    }

    public void setAggregationStrategyMethodAllowNull(String aggregationStrategyMethodAllowNull) {
        this.aggregationStrategyMethodAllowNull = aggregationStrategyMethodAllowNull;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(String onPrepare) {
        this.onPrepare = onPrepare;
    }

    public String getShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(String shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.executorService = executorService;
    }
}

