/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import io.minio.messages.Metadata;
import io.minio.messages.Owner;
import io.minio.messages.ResponseDate;
import java.time.ZonedDateTime;
import java.util.Map;
import org.simpleframework.xml.Element;

public abstract class Item {
    @Element(name="ETag", required=false)
    private String etag;
    @Element(name="Key")
    private String objectName;
    @Element(name="LastModified")
    private ResponseDate lastModified;
    @Element(name="Owner", required=false)
    private Owner owner;
    @Element(name="Size", required=false)
    private long size;
    @Element(name="StorageClass", required=false)
    private String storageClass;
    @Element(name="IsLatest", required=false)
    private boolean isLatest;
    @Element(name="VersionId", required=false)
    private String versionId;
    @Element(name="UserMetadata", required=false)
    private Metadata userMetadata;
    private boolean isDir = false;

    public Item() {
    }

    public Item(String prefix) {
        this.objectName = prefix;
        this.isDir = true;
    }

    public String objectName() {
        return this.objectName;
    }

    public ZonedDateTime lastModified() {
        return this.lastModified.zonedDateTime();
    }

    public String etag() {
        return this.etag;
    }

    public long size() {
        return this.size;
    }

    public String storageClass() {
        return this.storageClass;
    }

    public Owner owner() {
        return this.owner;
    }

    public Map<String, String> userMetadata() {
        return this.userMetadata == null ? null : this.userMetadata.get();
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public String versionId() {
        return this.versionId;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public boolean isDeleteMarker() {
        return this.etag == null && this.size == 0L && this.storageClass == null && this.versionId != null;
    }
}

