/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.io.BaseEncoding;
import io.minio.ServerSideEncryptionCustomerKey;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public abstract class ServerSideEncryption
implements Destroyable {
    protected boolean destroyed = false;

    public abstract Type type();

    public abstract Map<String, String> headers();

    public Map<String, String> copySourceHeaders() throws IllegalArgumentException {
        throw new IllegalArgumentException(this.type().name() + " is not supported in copy source");
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private static boolean isCustomerKeyValid(SecretKey key) {
        if (key == null) {
            return false;
        }
        return !key.isDestroyed() && key.getAlgorithm().equals("AES") && key.getEncoded().length == 32;
    }

    public static ServerSideEncryptionCustomerKey withCustomerKey(SecretKey key) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!ServerSideEncryption.isCustomerKeyValid(key)) {
            throw new InvalidKeyException("The secret key is not a 256 bit AES key");
        }
        return new ServerSideEncryptionCustomerKey(key);
    }

    public static ServerSideEncryption atRest() {
        return new ServerSideEncryptionS3();
    }

    public static ServerSideEncryption withManagedKeys(String keyId, Map<String, String> context) throws IllegalArgumentException, UnsupportedEncodingException {
        if (keyId == null) {
            throw new IllegalArgumentException("The key-ID cannot be null");
        }
        if (context == null) {
            return new ServerSideEncryptionKms(keyId, Optional.empty());
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        builder.append('{');
        for (Map.Entry<String, String> entry : context.entrySet()) {
            builder.append('\"');
            builder.append(entry.getKey());
            builder.append('\"');
            builder.append(':');
            builder.append('\"');
            builder.append(entry.getValue());
            builder.append('\"');
            if (i >= context.entrySet().size() - 1) continue;
            builder.append(',');
        }
        builder.append('}');
        String contextString = BaseEncoding.base64().encode(builder.toString().getBytes(StandardCharsets.UTF_8));
        return new ServerSideEncryptionKms(keyId, Optional.of(contextString));
    }

    static final class ServerSideEncryptionKms
    extends ServerSideEncryption {
        final Map<String, String> headers;

        public ServerSideEncryptionKms(String keyId, Optional<String> context) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-Amz-Server-Side-Encryption", "aws:kms");
            headers.put("X-Amz-Server-Side-Encryption-Aws-Kms-Key-Id", keyId);
            if (context.isPresent()) {
                headers.put("X-Amz-Server-Side-Encryption-Context", context.get());
            }
            this.headers = Collections.unmodifiableMap(headers);
        }

        @Override
        public final Type type() {
            return Type.SSE_KMS;
        }

        @Override
        public final Map<String, String> headers() {
            if (this.isDestroyed()) {
                throw new IllegalStateException("object is already destroyed");
            }
            return this.headers;
        }

        @Override
        public final void destroy() throws DestroyFailedException {
            this.destroyed = true;
        }
    }

    static final class ServerSideEncryptionS3
    extends ServerSideEncryption {
        private static final Map<String, String> headers;

        ServerSideEncryptionS3() {
        }

        @Override
        public final Type type() {
            return Type.SSE_S3;
        }

        @Override
        public final Map<String, String> headers() {
            return headers;
        }

        @Override
        public final void destroy() throws DestroyFailedException {
            this.destroyed = true;
        }

        static {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("X-Amz-Server-Side-Encryption", "AES256");
            headers = Collections.unmodifiableMap(map);
        }
    }

    public static enum Type {
        SSE_C,
        SSE_S3,
        SSE_KMS;


        public boolean requiresTls() {
            return this.equals((Object)SSE_C) || this.equals((Object)SSE_KMS);
        }
    }
}

